import 'package:flutter/material.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:amos_iot_login_tpl/entity/platform_menu.dart';
import 'package:get/get.dart';
import 'package:jcs_airport/view/Home/iot_monitor.dart';
import './config.dart';

int processStatusIndex = 0;
const int TIMES_INDEX = 0;
int alarmIndex = 0;

/// 创建下拉菜单内容
DropdownMenu buildDropdownMenu() {
  return DropdownMenu(maxMenuHeight: kDropdownMenuItemHeight * 10, blur: 0.0, menus: [
    DropdownMenuBuilder(
        builder: (BuildContext context) {
          return DropdownListMenu(
            selectedIndex: TIMES_INDEX,
            data: TIMES,
            itemBuilder: buildCheckItem,
          );
        },
        height: kDropdownMenuItemHeight * TIMES.length),
    DropdownMenuBuilder(
        builder: (BuildContext context) {
          return DropdownListMenu(
            selectedIndex: processStatusIndex,
            data: PROCESS_STATUS,
            itemBuilder: buildCheckItem,
          );
        },
        height: kDropdownMenuItemHeight * PROCESS_STATUS.length),
    DropdownMenuBuilder(
        builder: (BuildContext context) {
          return DropdownListMenu(
            selectedIndex: alarmIndex,
            data: ALARM_TYPE,
            itemBuilder: buildCheckItem,
          );
        },
        height: kDropdownMenuItemHeight * ALARM_TYPE.length),
    DropdownMenuBuilder(
        builder: (BuildContext context) {
          return DropdownListMenu(
            selectedIndex: 0,
            data: ALARM_TYPE,
            itemBuilder: (BuildContext context, dynamic data, bool selected) {
              return Padding(
                  padding: const EdgeInsets.all(10.0),
                  child: Row(
                    children: <Widget>[
                      Expanded(
                        child: Text(
                          defaultGetItemLabel(data),
                          textAlign: TextAlign.center,
                          style: selected
                              ? const TextStyle(fontSize: 14.0, fontWeight: FontWeight.w400)
                              : const TextStyle(fontSize: 14.0),
                        ),
                      ),
                    ],
                  ));
            },
          );
        },
        height: kDropdownMenuItemHeight * ALARM_TYPE.length)
  ]);
}

/// 创建下拉菜单 header
DropdownHeader buildDropdownHeader({DropdownMenuHeadTapCallback onTap}) {
  PlatformMenu platformMenu = Get.arguments;
  alarmIndex = 0;
  processStatusIndex = 0;

  if (platformMenu != null) {
    String type = platformMenu.frontComponent;
    int i = 0;
    for (i = 0; i < ALARM_TYPE.length; i++) {
      if (type == ALARM_TYPE[i]['id']) {
        alarmIndex = i;
      }
    }

    if (alarmIndex == 0) {
      for (i = 0; i < PROCESS_STATUS.length; i++) {
        if (type == PROCESS_STATUS[i]['id']) {
          processStatusIndex = i;
        }
      }
    }
    //处理从首页统计跳转进来的情况
    if (platformMenu.frontComponent == IotMonitor.iotMonitorFireControlWarning) {
      alarmIndex = 1;
      processStatusIndex = 1;
    } else if (platformMenu.frontComponent == IotMonitor.iotMonitorMalfunctionWarning) {
      alarmIndex = 2;
      processStatusIndex = 1;
    }
  }

  return DropdownHeader(
    onTap: onTap,
    fontSize: 13,
    titles: [TIMES[TIMES_INDEX], PROCESS_STATUS[processStatusIndex], ALARM_TYPE[alarmIndex], '筛选'],
  );
}
