/// @author ilex.h

import 'package:flutter/material.dart';
import 'package:chewie/chewie.dart';
import 'package:video_player/video_player.dart';


/// 播放监控视频
/// 
/// 网络地址视频，支持 MP4 格式
class PlayMonitorVideo extends StatefulWidget {
  const PlayMonitorVideo({Key key, this.url}) : super(key: key);

  /// 视频播放地址
  final String url;

  @override
  _PlayMonitorVideoState createState() => _PlayMonitorVideoState();
}

class _PlayMonitorVideoState extends State<PlayMonitorVideo> {
  VideoPlayerController _controller;
  ChewieController _chewieController;

  @override
  void initState() {
    super.initState();
    _controller = VideoPlayerController.network(widget.url)
      ..initialize().then((_) {
        setState(() {});
      });
    _chewieController = ChewieController(
      videoPlayerController: _controller,
      autoPlay: true,
      looping: true,
    );
  }

  @override
  Widget build(BuildContext context) {
    return Chewie(
      controller: _chewieController,
    );
  }

  @override
  void dispose() {
    super.dispose();
    _controller.dispose();
    _chewieController.dispose();
  }
}

