import 'dart:convert' show json;

class MessageDetail {
  num createBy;
  num fixedTime;
  num createDate;
  num id;
  num relationId;
  num sendTime;
  num status;
  num userId;
  bool isImmediately;
  bool isRead;
  String body;
  String msgType;
  String orgCode;
  String targetTel;
  String title;

  MessageDetail.fromParams(
      {this.createBy,
      this.fixedTime,
      this.createDate,
      this.id,
      this.relationId,
      this.sendTime,
      this.status,
      this.userId,
      this.isImmediately,
      this.isRead,
      this.body,
      this.msgType,
      this.orgCode,
      this.targetTel,
      this.title});

  factory MessageDetail(jsonStr) => jsonStr == null
      ? null
      : jsonStr is String
          ? new MessageDetail.fromJson(json.decode(jsonStr))
          : new MessageDetail.fromJson(jsonStr);

  MessageDetail.fromJson(jsonRes) {
    createBy = jsonRes['createBy'];
    fixedTime = jsonRes['fixedTime'];
    createDate = jsonRes['createDate'];
    id = jsonRes['id'];
    relationId = jsonRes['relationId'];
    sendTime = jsonRes['sendTime'];
    status = jsonRes['status'];
    userId = jsonRes['userId'];
    isImmediately = jsonRes['isImmediately'];
    isRead = jsonRes['isRead'];
    body = jsonRes['body'];
    msgType = jsonRes['msgType'];
    orgCode = jsonRes['orgCode'];
    targetTel = jsonRes['targetTel'];
    title = jsonRes['title'];
  }

  @override
  String toString() {
    return '{"createBy": $createBy,"fixedTime": $fixedTime,"createDate": $createDate,"id": $id,"relationId": $relationId,"sendTime": $sendTime,"status": $status,"userId": $userId,"isImmediately": $isImmediately,"isRead": $isRead,"body": ${body != null ? '${json.encode(body)}' : 'null'},"msgType": ${msgType != null ? '${json.encode(msgType)}' : 'null'},"orgCode": ${orgCode != null ? '${json.encode(orgCode)}' : 'null'},"targetTel": ${targetTel != null ? '${json.encode(targetTel)}' : 'null'},"title": ${title != null ? '${json.encode(title)}' : 'null'}}';
  }
}
