import 'dart:convert' show json;

class SubscribeInfo {
  List<CheckPlan> checkPlans;
  List<ItemInfo> checks;
  List<ItemInfo> emails;
}

class CheckPlan {
  String attribute3;
  String attribute4;
  String attribute5;
  num createDate;
  num id;
  num userId;
  String attribute1;
  String attribute2;
  String msgType;
  String orgCode;

  CheckPlan.fromParams(
      {this.attribute3,
      this.attribute4,
      this.attribute5,
      this.createDate,
      this.id,
      this.userId,
      this.attribute1,
      this.attribute2,
      this.msgType,
      this.orgCode});

  factory CheckPlan(jsonStr) => jsonStr == null
      ? null
      : jsonStr is String
          ? new CheckPlan.fromJson(json.decode(jsonStr))
          : new CheckPlan.fromJson(jsonStr);

  CheckPlan.fromJson(jsonRes) {
    attribute3 = jsonRes['attribute3'];
    attribute4 = jsonRes['attribute4'];
    attribute5 = jsonRes['attribute5'];
    createDate = jsonRes['createDate'];
    id = jsonRes['id'];
    userId = jsonRes['userId'];
    attribute1 = jsonRes['attribute1'];
    attribute2 = jsonRes['attribute2'];
    msgType = jsonRes['msgType'];
    orgCode = jsonRes['orgCode'];
  }

  @override
  String toString() {
    return '{"attribute3": $attribute3,"attribute4": $attribute4,"attribute5": $attribute5,"createDate": $createDate,"id": $id,"userId": $userId,"attribute1": ${attribute1 != null ? '${json.encode(attribute1)}' : 'null'},"attribute2": ${attribute2 != null ? '${json.encode(attribute2)}' : 'null'},"msgType": ${msgType != null ? '${json.encode(msgType)}' : 'null'},"orgCode": ${orgCode != null ? '${json.encode(orgCode)}' : 'null'}}';
  }
}

class ItemInfo {
  String code;
  String message;
  String ower;

  ItemInfo.fromParams({this.code, this.message, this.ower});

  factory ItemInfo(jsonStr) => jsonStr == null
      ? null
      : jsonStr is String
          ? new ItemInfo.fromJson(json.decode(jsonStr))
          : new ItemInfo.fromJson(jsonStr);

  ItemInfo.fromJson(jsonRes) {
    code = jsonRes['code'];
    message = jsonRes['message'];
    ower = jsonRes['ower'];
  }

  @override
  String toString() {
    return '{"code": ${code != null ? '${json.encode(code)}' : 'null'},"message": ${message != null ? '${json.encode(message)}' : 'null'},"ower": ${ower != null ? '${json.encode(ower)}' : 'null'}}';
  }
}
