import 'dart:async';
import 'dart:convert' show json;

import '../model/CompanyInfo.dart';
import '../model/ContactInfo.dart';
import '../model/DepartmentInfo.dart';
import '../model/InitData.dart';
import '../services/api_address.dart';
import '../utils/HttpUtil.dart';

Future<List<CompanyInfo>> getCompanyList() async {
  try {
    List<CompanyInfo> companyList = [];

    Map request = {};

    // 调用接口查询数据
    var data = await HttpUtil().get(ApiAddress.QUERY_AUTH_COMPANY_LEAVES, data: json.encode(request));

    //具体实现函数待编写
    if (data['result'] == 'SUCCESS') {
      var dataList = data['dataList'];

      for (var _dataList in dataList) {
        companyList.add(CompanyInfo.fromJson(_dataList));
      }
    }
    return companyList;
  } catch (e) {
    throw e;
  }
}

Future<void> selectCompany(String orgcode) async {
  try {
    // 调用接口查询数据
    var data = await HttpUtil().get(ApiAddress.CHANGE_COMPANY + '/' + orgcode);
    //具体实现函数待编写
    if (data['result'] == 'SUCCESS') {
      print('公司切换成功！');
    }
  } catch (e) {
    print('公司切换失败！');
  }
}

// 获取部门信息
Future<List<DepartmentInfo>> getDepartmentInfo() async {
  List<DepartmentInfo> lst = new List();

  var data = await HttpUtil().get(ApiAddress.DEPARTMENT_INFO);
  if (data['result'] == 'SUCCESS') {
    var dataList = data['dataList'];
    for (var _data in dataList) {
      lst.add(DepartmentInfo.fromParams(id: _data['id'].toString(), name: _data['name'].toString()));
    }
  }
  return lst;
}

// 获取通讯录信息
// Future<List<ContractInfo>> getContractInfo() async{
//   List<ContractInfo> rst = List();
//   var data = await HttpUtil().get(ApiAddress.CONTACT_INFO);
//   if (data['result'] == 'SUCCESS' ) {
//     var dataList = data['dataList'];
//     for(var _data in dataList){
//       ContractInfo _contract = ContractInfo.fromParams(id: _data['id'].toString(),name: _data['name'].toString(),departmentName: _data['departmentName'],email: _data['email'],telephone:  _data['telephone'],mobile:  _data['mobile'], depId: _data['depid']);
//       List<ChildInfo> children = List();
//       for(var child in _data['children']){
//         children.add(ChildInfo.fromParams(id: child['id'].toString(),
//             label: child['label'].toString(),name: child['name'].toString(),departmentName: child['departmentName'],email: child['email'],telephone:  child['telephone'],mobile:  child['mobile'], depId: child['depid']));
//       }
//       _contract.children = children;
//       rst.add(_contract);
//     }
//   }
//   return rst;
// }
// 获取通讯录信息
Future<List<ContractInfo>> getContractInfo(companyId) async {
  List<ContractInfo> rst = [];
  var data = await HttpUtil().get(ApiAddress.CONTACT_INFO, isAuth: true);
  if (data['result'] == 'SUCCESS') {
    var dataList = data['dataList'];
    for (var _data in dataList) {
      ContractInfo _contract = ContractInfo.fromJson(_data);
      List<ChildInfo> children = List();
      //部门下由用户
      if (_data['children'] != null) {
        addChildItem(children, _data['children'], _data['name']);
      }
      _contract.children = children;
      rst.add(_contract);
    }
  }
  rst.sort((left, right) => left.type.compareTo(right.type));
  return rst;
}

// 获取治理人
Future<List> getPersonList() async {
  var data = await HttpUtil().get(ApiAddress.PERSON_LIST, isAuth: true);
  if (data['result'] == 'SUCCESS') {
    return data['dataList'] ?? [];
  }
  return [];
}

addChildItem(List<ChildInfo> children, var current, deptName) {
  for (var child in current) {
    ChildInfo childs = ChildInfo.fromJson(child);
    //id: child['id'].toString(),name: child['name'].toString(),parentId: child['parentId'],departmentName: deptName,type: child['type'] ,objects: json.encode(child['object']));
    List<ChildInfo> childrenChild = List();
    if (child['children'] != null) {
      addChildItem(childrenChild, child['children'], child['name']);
    }
    childs.children = childrenChild;
    children.add(childs);
    // children.addAll(childrenChild);
  }
  children.sort((left, right) => left.type.compareTo(right.type));
}

Future<int> getQueryPlanTaskCount() async {
  int count = 0;
  var data = await HttpUtil().post(ApiAddress.QUERY_PLAN_TASK_COUNT);
  if (data['result'] == 'SUCCESS') {
    count = data['dataList'];
  }
  return count;
}

Future<int> getUnreadCount() async {
  int count = 0;
  var data = await HttpUtil().get(ApiAddress.UNREAD_COUNT);
  if (data['result'] == 'SUCCESS') {
    count = data['dataList'];
  }
  return count;
}

Future<List> getPatrolCount() async {
  List count = [];
  var data = await HttpUtil().get(ApiAddress.PATROL_COUNT);
  if (data['result'] == 'SUCCESS') {
    count = data['dataList'];
  }
  return count;
}

// 获取初始化信息
Future<InitData> getInitData() async {
  InitData initData = InitData();
  var data = await HttpUtil().get(ApiAddress.INIT_DATA);
  if (data['result'] == 'SUCCESS') {
    var dataList = data['dataList'];

    List<CompanyInfo> companyList = new List();
    for (var _dataList in dataList['companys']) {
      companyList.add(CompanyInfo.fromJson(_dataList));
    }

    initData.companies = companyList;

    ////////////////////////////////////////////////
    String permissions = '';
    var permissionList = dataList['permissionitems'];
//    List children = json.decode(permissionList['children']);
    if (permissionList != null && permissionList.length > 0) {
      if (permissionList[0]['children'] != null) {
        for (var child in permissionList[0]['children']) {
//          print(child);
          if (child['isWriteable']) {
            permissions = child['permissionCode'] + ',' + permissions;
          }
        }
        initData.permissions = permissions;
      }
    } else {
      initData.permissions = null;
    }
  }
  return initData;
}

Future<InitData> getLogInInfo() async {
  InitData initData = InitData();
  var data = await HttpUtil().get(ApiAddress.LOGIN_INFOXJ, isAuth: true);
  if (data['result'] == 'SUCCESS') {
    var dataList = data['dataList'];

    List<CompanyInfos> companyList = new List();
    List<DeptInfo> deptList = new List();
    Map<String, List<DeptInfo>> deptMap = new Map();
    List<RoleInfo> roleList = new List();
    Map<String, List<RoleInfo>> roleMap = new Map();

    for (var _dataList in dataList['companys']) {
      companyList.add(CompanyInfos.fromJson(_dataList));
    }

//    for (var _dataList in dataList['departments']) {
    if (dataList['companyDepartments'] != null) {
      for (String key in dataList['companyDepartments'].keys) {
        deptList = [];
        for (var dpt in dataList['companyDepartments'][key]) {
          deptList.add(DeptInfo.fromJson(dpt));
        }
        deptMap[key] = deptList;
      }
    }

//    for (var _dataList in dataList['roles']) {
    if (dataList['orgRoles'] != null) {
      for (var key in dataList['orgRoles'].keys) {
        roleList = [];
        for (var role in dataList['orgRoles'][key]) {
          roleList.add(RoleInfo.fromJson(role));
        }
        roleMap[key] = roleList;
      }
    }

    initData.coms = companyList;
    initData.deptInfos = deptMap;
    initData.roleInfo = roleMap;
    return initData;
  }
  return null;
}
