import 'package:flutter/material.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';


// 主题定制参照官网地址
// https://api.flutter.dev/flutter/material/ThemeData-class.html
// https://api.flutter.dev/flutter/material/TextTheme-class.html

mixin AppTheme {
  static final Color backgroundColor = Color(0xFFefeff4);
  static final Color shadowColor = Color.fromRGBO(69, 91, 99, 0.08);
  static final double barTitleFontSize = 18.px.toDouble();

  static final double bodyFontSize = 12.px.toDouble();

  static final double smallFontSize = 8.px.toDouble();
  static final double normalFontSize = 14.px.toDouble();
  static final double largeFontSize = 20.px.toDouble();

  static final double headFontSize = 14.px.toDouble();
  static final double head2FontSize = 18.px.toDouble();
  static final double head3FontSize = 14.px.toDouble();
  static final double head5FontSize = 20.px.toDouble();
  static final double head6FontSize = 14.px.toDouble();

  // 普通模式
  static final ThemeData norTheme = ThemeData(
      primaryColor: Color(0xFFffffff), // 优先级
      textTheme: TextTheme(
        bodyText1: TextStyle(fontSize: bodyFontSize, color: Color(0xFF333333)),
        bodyText2: TextStyle(
            fontSize: bodyFontSize,
            color: Color(0xFF333333),
            fontWeight: FontWeight.w500),
        subtitle2: TextStyle(fontSize: smallFontSize, color: Color(0xFF999999)),
        headline1: TextStyle(fontSize: largeFontSize, color: Colors.black),
        headline2: TextStyle(fontSize: head2FontSize, color: Colors.white),
        headline3: TextStyle(fontSize: head3FontSize, color: Color(0xFF333333)),
        headline4: TextStyle(
            fontSize: headFontSize,
            color: Color(0xFF333333),
            fontWeight: FontWeight.bold),
        headline5: TextStyle(fontSize: head5FontSize, color: Color(0xFF333333)),
        headline6: TextStyle(fontSize: head6FontSize, color: Color(0xFF333333)),
      ),
      appBarTheme: AppBarTheme(
          textTheme:
              TextTheme(headline1: TextStyle(fontSize: barTitleFontSize))),
      tabBarTheme:
          TabBarTheme(labelStyle: TextStyle(fontSize: normalFontSize)));

  static final ThemeData darkTheme = ThemeData(
      primarySwatch: Colors.black26,
      canvasColor: Colors.black26,
      textTheme: TextTheme(),
      appBarTheme: AppBarTheme(textTheme: TextTheme()));
}
