import '../consts/qr_type_consts.dart';
import '../consts/route_category_front_component_const.dart';

class QueryQRType {
  // 根据不同分类和子项返回扫码类型
  static String queryQRType(String category, String item) {
    if (category == RouteCategoryFrontComponentConst.equipment) {
      if (item == RouteItemFrontComponentConst.inStock) {
        return QRType.equipment_beputinstorage;
      }
      if (item == RouteItemFrontComponentConst.maintain) {
        return QRType.equipment_maintenance;
      }
      if (item == RouteItemFrontComponentConst.repair) {
        return QRType.euipment_repair;
      }
      if (item == RouteItemFrontComponentConst.repaired) {
        return QRType.equipment_repaircomplete;
      }
      if (item == RouteItemFrontComponentConst.scraped) {
        return QRType.equipment_scrap;
      }
      return QRType.equipment_beputinstorage;
    } else if (category ==
        RouteCategoryFrontComponentConst.fireExtinguishingAgent) {
      if (item == RouteItemFrontComponentConst.extinguishWastage) {
        return QRType.agent_deliveryofcargofromstorage;
      }
      if (item == RouteItemFrontComponentConst.extinguishLoad) {
        return QRType.agent_deliveryofcargofromstorage;
      }
      if (item == RouteItemFrontComponentConst.inStock) {
        return QRType.agent_beputinstorage;
      }
      return QRType.qrGlobal;
    } else if (category ==
        RouteCategoryFrontComponentConst.fireFightingVehicle) {
      if (item == RouteItemFrontComponentConst.maintain) {
        return QRType.car_maintenance;
      }
      if (item == RouteItemFrontComponentConst.repair) {
        return QRType.car_repair;
      }
      if (item == RouteItemFrontComponentConst.repaired) {
        return QRType.car_repaircomplete;
      }
      if (item == RouteItemFrontComponentConst.scraped) {
        return QRType.car_scrap;
      }
    }

    return '';
  }
}
