import 'dart:convert';

import 'package:shared_preferences/shared_preferences.dart';
import 'package:amos_iot_login_tpl/const/const.dart';

class UserInfoManager {
  static String _token;
  static String _userName;
  static String _userPwd;
  static Map<String, dynamic> _baseInfo;

  // token
  static Future<String> getToken() async {
    if (_token == null) {
      SharedPreferences prefers = await SharedPreferences.getInstance();
      _token = prefers.getString(GlobalConst.token);
    }
    return _token;
  }

  static Future<void> clearToken() async {
    _token = null;
    SharedPreferences prefers = await SharedPreferences.getInstance();
    if (prefers.containsKey(GlobalConst.token)) {
      await prefers.remove(GlobalConst.token);
    }
  }

  // 密码
  static Future<void> saveUserPwd(String text) async {
    if (text == null) {
      return;
    }
    SharedPreferences prefers = await SharedPreferences.getInstance();
    prefers.setString(GlobalConst.AMOS_USER_PWD, text);
  }

  static Future<String> getUserPwd() async {
    if (_userPwd == null) {
      SharedPreferences prefers = await SharedPreferences.getInstance();
      if (prefers.containsKey(GlobalConst.AMOS_USER_PWD)) {
        _userPwd = prefers.getString(GlobalConst.AMOS_USER_PWD);
      }
    }
    return _userPwd;
  }

  static Future<void> clearUserPwd() async {
    _userPwd = null;
    SharedPreferences prefers = await SharedPreferences.getInstance();
    if (prefers.containsKey(GlobalConst.AMOS_USER_PWD)) {
      await prefers.remove(GlobalConst.AMOS_USER_PWD);
    }
  }

  // 用户名
  static Future<void> saveUserName(String text) async {
    if (text == null) {
      return;
    }
    SharedPreferences prefers = await SharedPreferences.getInstance();
    prefers.setString(GlobalConst.AMOS_USER_NAME, text);
  }

  static Future<String> getUserName() async {
    if (_userName == null) {
      SharedPreferences prefers = await SharedPreferences.getInstance();
      if (prefers.containsKey(GlobalConst.AMOS_USER_NAME)) {
        _userName = prefers.getString(GlobalConst.AMOS_USER_NAME);
      }
    }
    return _userName;
  }

  static Future<void> clearUserName() async {
    _userName = null;
    SharedPreferences prefers = await SharedPreferences.getInstance();
    if (prefers.containsKey(GlobalConst.AMOS_USER_NAME)) {
      await prefers.remove(GlobalConst.AMOS_USER_NAME);
    }
  }

  static Future<void> saveLoginBaseInfo(Map result) async {
    if (result == null) {
      return;
    }
    SharedPreferences prefers = await SharedPreferences.getInstance();
    String string = json.encode(result);
    prefers.setString(GlobalConst.login_base_info, string);
    prefers.setString(GlobalConst.token, result['token']);
  }

  // 获取基础信息
  static Future<Map<String, dynamic>> getLoginBaseInfo() async {
    SharedPreferences prefers = await SharedPreferences.getInstance();
    String token = prefers.getString(GlobalConst.token) ?? '';
    String product = prefers.getString(GlobalConst.product) ?? '';
    String appKey = prefers.getString(GlobalConst.appKey) ?? '';
    _baseInfo ??= {};
    return _baseInfo..addAll({'appKey': appKey, 'product': product, 'token': token});
  }

  // 清除基础信息内存缓存
  static void clearBaseInfoMemoryCache() {
    _baseInfo = null;
  }

  // 登出清除缓存
  static void logoutClear() {
    clearBaseInfoMemoryCache();
    clearToken();
  }
}
