import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../consts/color.dart';
import '../../model/name_value.dart';
import '../../services/route_list_services.dart';

class LinesPage extends StatefulWidget {
  final List<String> selectedRoute;

  const LinesPage(this.selectedRoute);

  @override
  _LinesPageState createState() => _LinesPageState();
}

class _LinesPageState extends State<LinesPage> {
  final TextEditingController _controller = TextEditingController();
  List<bool> checklist = [];
  String theme = '';

  bool _checkIdInSelected(num id) {
    bool selected = false;
    widget.selectedRoute.forEach((f) {
      if (f == id.toString()) {
        selected = true;
      }
    });
    return selected;
  }

  List<NameValue> routeList = [];
  List<NameValue> tmpRouteList = [];
  List<NameValue> selected = [];

  @override
  void initState() {
    super.initState();
    getInitInfo();
    initConfig();
  }

  Future<void> initConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        theme = preferences.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        backgroundColor: const Color.fromRGBO(242, 246, 249, 1),
        appBar: AppBar(
          elevation: 0.2,
          title: Container(
            height: 30,
            width: 220,
            padding: const EdgeInsets.only(bottom: 5),
            decoration: BoxDecoration(
              color: Colors.grey[100],
              borderRadius: const BorderRadius.all(Radius.circular(25.0)),
            ),
            child: Row(
              children: <Widget>[
                Container(
                  padding: const EdgeInsets.only(left: 5, right: 5, top: 6),
                  child: const Icon(
                    Icons.search,
                    color: Colors.grey,
                  ),
                ),
                Container(
                  width: MediaQuery.of(context).size.width - 180,
                  child: TextField(
                      controller: _controller,
                      style: const TextStyle(fontSize: 16.0, color: Colors.black),
                      decoration: const InputDecoration(border: InputBorder.none, contentPadding: EdgeInsets.only(top: -16))),
                )
              ],
            ),
          ),
          centerTitle: true,
          actions: <Widget>[
            Align(
                child: Padding(
              padding: const EdgeInsets.only(right: 8),
              child: GestureDetector(
                onTap: () {
                  setState(() {
                    if (_controller.text.isEmpty) {
                      routeList = tmpRouteList;
                    } else {
                      routeList = tmpRouteList.where((f) => f.name.contains(_controller.text)).toList();
                    }
                  });
                },
                child: const Text(
                  '搜索',
                ),
              ),
            ))
          ],
        ),
        body: ListView.builder(
            itemCount: routeList.length,
            itemBuilder: (BuildContext context, int index) {
              return Container(
                  color: Colors.white,
                  child: Column(crossAxisAlignment: CrossAxisAlignment.start, children: <Widget>[
                    Row(mainAxisAlignment: MainAxisAlignment.spaceBetween, children: <Widget>[
                      Container(
                        width: 250.0,
                        margin: const EdgeInsets.only(left: 20.0, top: 10.0),
                        child: Text(
                          routeList[index].name,
                          style: const TextStyle(fontSize: 16.0, color: Colors.black),
                        ),
                      ),
                      Checkbox(
                          value: checklist[index],
                          onChanged: (bool val) {
                            setState(() {
                              checklist[index] = !checklist[index];
                              // 保存数据
                              if (val) {
                                selected.add(routeList[index]);
                              } else {
                                selected.remove(routeList[index]);
                              }
                            });
                          })
                    ]),
                    const Padding(
                      padding: EdgeInsets.only(left: 15.0, right: 15.0),
                      child: Divider(
                        height: 0.5,
                        color: Colors.grey,
                      ),
                    ),
                  ]));
            }));
  }

  Future<void> getInitInfo() async {
    // 获取线路数据
    await getRouteList().then((data) {
      setState(() {
        routeList = data;
        tmpRouteList = data;

        for (int i = 0; i < routeList.length; i++) {
          if (_checkIdInSelected(routeList[i].value)) {
            checklist.add(true);
            selected.add(routeList[i]);
          } else {
            checklist.add(false);
          }
        }
      });
    });
  }
}
