import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'dart:convert';

import '../../consts/http_config.dart';
import '../../model/warehouse_info_view_model.dart';
import '../../utils/request.dart';
import 'base_info_content.dart';

// 基本信息统计

class CompanyInfoCard extends StatefulWidget {
  @override
  _CompanyInfoCardState createState() => _CompanyInfoCardState();
}

class _CompanyInfoCardState extends State<CompanyInfoCard>
    with AutomaticKeepAliveClientMixin {
  List<String> numbers = [];
  bool hasError = false;
  String title = '';

  @override
  void initState() {
    super.initState();
    Future.delayed(Duration(seconds: HttpConfig.delayTime), () {
      String warehouseId =
          Provider.of<WarehouseInfoViewModel>(this.context, listen: false)
              .warehouseInfoModel
              ?.warehouse
              ?.id;
      if (warehouseId == null) return;
      HttpRequest.queryStatisticsAllCategoryBase(warehouseId).then((res) {
        if (res["status"] == 200) {
          Map<String, dynamic> result = res["result"];
          List<String> results = [];

          results.add(result["RY"] as String);
          results.add(result["CL"] as String);
          results.add(result["ZB"] as String);
          double str = double.parse(result["MHYJ"] as String);
          double val = str;
          if (str > 10000) {
            val = str / 10000;
          }
          results.add((val.toStringAsFixed(2) as String) + '万');
          setState(() {
            numbers.addAll(results);
          });
        }
      }).catchError((err) {
        setState(() {
          hasError = true;
        });
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    if (numbers.length == 0) {
      return Container(
          height: 150.px,
          child: const Center(
            child: CupertinoActivityIndicator(),
          ));
    } else if (hasError) {
      return Container(
          height: 150.px,
          child: const Center(
            child: Text("请求数据失败"),
          ));
    } else {
      return Padding(
        padding: EdgeInsets.only(left: 8.px, right: 8.px, top: 5.px),
        child: Card(
          shape:
              RoundedRectangleBorder(borderRadius: BorderRadius.circular(6.px)),
          shadowColor: Color.fromRGBO(69, 91, 99, 0.08),
          elevation: 4,
          child: BaseInfoContent(
              title: title ??
                  "",
              numbers: numbers,
              categories: ["消防人员", "消防车辆", "消防装备", "灭火药剂"]),
        ),
      );
    }
  }

  @override
  bool get wantKeepAlive => true;
}
