import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';

import '../../consts/http_config.dart';
import '../../model/warehouse_info_view_model.dart';
import '../../utils/request.dart';
import 'base_info_content.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'dart:convert';

// 消防装备统计

class FireEquipmentStatisticCard extends StatefulWidget {
  @override
  _FireEquipmentStatisticCardState createState() =>
      _FireEquipmentStatisticCardState();
}

class _FireEquipmentStatisticCardState
    extends State<FireEquipmentStatisticCard> {
  List<String> numbers = [];
  bool hasError = false;

  @override
  void initState() {
    super.initState();
    Future.delayed(Duration(seconds: HttpConfig.delayTime), () {
      String warehouseId =
          Provider
              .of<WarehouseInfoViewModel>(this.context, listen: false)
              .warehouseInfoModel
              ?.warehouse
              ?.id;
      if (warehouseId == null) return;
      HttpRequest.queryEquipmentStatus(warehouseId).then((res) {
        if (res["status"] == 200) {
          Map<String, dynamic> result = res["result"];
          List<String> results = [];

          results.add(result["ALL"] as String);
          results.add(result["REPERTORY"] as String);
          results.add(result["REPAIR"] as String);
          results.add(result["SCRAP"] as String);
          setState(() {
            numbers.addAll(results);
          });
        }
      }).catchError((err) {
        setState(() {
          hasError = true;
        });
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    if (numbers.length == 0) {
      return Container(
          height: 150.px,
          child: Center(
            child: CupertinoActivityIndicator(),
          ));
    } else if (hasError) {
      return Container(
          height: 150.px,
          child: Center(
            child: Text("请求数据失败"),
          ));
    } else {
      return Padding(
        padding: EdgeInsets.only(left: 8.px, right: 8.px),
        child: Card(
          shape:
              RoundedRectangleBorder(borderRadius: BorderRadius.circular(6.px)),
          shadowColor: Color.fromRGBO(69, 91, 99, 0.08),
          elevation: 4,
          child: BaseInfoContent(
            title: "消防装备统计",
            categories: ["全部装备", "入账装备", "维修装备", "报废装备"],
            numbers: numbers,
          ),
        ),
      );
    }
  }
}
