import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'dart:convert';
import '../../consts/http_config.dart';

import '../../model/warehouse_info_view_model.dart';
import '../../utils/request.dart';
import 'pie_chart.dart';

// 消防车统计
class FireVehicleStatisticCard extends StatefulWidget {
  @override
  _FireVehicleStatisticCardState createState() =>
      _FireVehicleStatisticCardState();
}

class _FireVehicleStatisticCardState extends State<FireVehicleStatisticCard>
    with AutomaticKeepAliveClientMixin {
  List<String> labels = [];
  List<Map<String, dynamic>> values = [];
  bool hasError = false;

  @override
  void initState() {
    super.initState();

    Future.delayed(Duration(seconds: HttpConfig.delayTime), () {
      String orgCode =
          Provider.of<WarehouseInfoViewModel>(this.context, listen: false)
              .warehouseInfoModel
              ?.warehouse
              ?.orgCode;
      if (orgCode == null) return;
      HttpRequest.queryCarCategory(orgCode).then((res) {
        if (res["status"] == 200) {
          Map<String, dynamic> result = res["result"];
          List<String> results1 = [];
          List<Map<String, dynamic>> results2 = [];
          double a = double.parse(result["ZQBZ"]);
          double b = double.parse(result["ZQ"]);
          double c = double.parse(result["MH"]);
          double d = double.parse(result["JG"]);
          double total = a + b + c + d;
          if (result["ZQBZ"] != null) {
            results1.add("战勤保障类");
            String value = (a / total * 100).toStringAsFixed(0);
            results2.add({"title": "$value%", "value": value});
          }
          if (result["ZQ"] != null) {
            results1.add("专勤类");
            String value = (b / total * 100).toStringAsFixed(0);
            results2.add({"title": "$value%", "value": value});
          }
          if (result["MH"] != null) {
            results1.add("灭火类");
            String value = (c / total * 100).toStringAsFixed(0);
            results2.add({"title": "$value%", "value": value});
          }
          if (result["JG"] != null) {
            results1.add("举高类");
            String value = (d / total * 100).toStringAsFixed(0);
            results2.add({"title": "$value%", "value": value});
          }

          setState(() {
            labels = results1;
            values = results2;
          });
        }
      }).catchError((err) {
        setState(() {
          hasError = true;
        });
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    if (hasError) {
      return Container(
          height: 150.px,
          child: Center(
            child: Text("请求数据失败"),
          ));
    } else if (labels.length == 0) {
      return Container(
          height: 150.px,
          child: Center(
            child: CupertinoActivityIndicator(),
          ));
    } else {
      return Padding(
        padding: EdgeInsets.only(left: 8.px, right: 8.px, top: 3.px),
        child: Card(
          shape:
              RoundedRectangleBorder(borderRadius: BorderRadius.circular(6.px)),
          shadowColor: Color.fromRGBO(69, 91, 99, 0.08),
          elevation: 4,
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: <Widget>[
              Padding(
                  padding: EdgeInsets.only(left: 18.px, top: 9.px),
                  child: Text(
                    "消防车统计按类别",
                    style: Theme.of(context).textTheme.headline4,
                  )),
              PieChartContent(
                labels: labels,
                values: values,
              )
            ],
          ),
        ),
      );
    }
  }

  @override
  bool get wantKeepAlive => true;
}
