import 'package:flutter/material.dart';
import 'package:fl_chart/fl_chart.dart';

import '../../widgets/indicator.dart';

class PieChartContent extends StatefulWidget {
  final List<String> labels;
  final List<Map<String, dynamic>> values;

  PieChartContent({this.values, this.labels});

  @override
  _PieChartState createState() => _PieChartState();
}

class _PieChartState extends State<PieChartContent>
    with AutomaticKeepAliveClientMixin {
  int touchedIndex;

  List<Color> colors = [
    Color(0xff0293ee),
    Color(0xfff8b250),
    Color(0xff845bef),
    Color(0xff13d38e)
  ];

  @override
  Widget build(BuildContext context) {
    return Row(
      children: <Widget>[
        const SizedBox(
          width: 50,
        ),
        Column(
            mainAxisSize: MainAxisSize.max,
            mainAxisAlignment: MainAxisAlignment.end,
            crossAxisAlignment: CrossAxisAlignment.start,
            children: List.generate(widget.labels.length, (index) {
              return Column(
                children: <Widget>[
                  Indicator(
                    color: colors[index],
                    text: widget.labels[index],
                  ),
                  SizedBox(
                    height: 20,
                  ),
                ],
              );
            }).toList()),
        Expanded(
          child: PieChart(
            PieChartData(
                pieTouchData: PieTouchData(touchCallback: (pieTouchResponse) {
                  setState(() {
                    if (pieTouchResponse.touchInput is FlLongPressEnd ||
                        pieTouchResponse.touchInput is FlPanEnd) {
                      touchedIndex = -1;
                    } else {
                      touchedIndex = pieTouchResponse.touchedSectionIndex;
                    }
                  });
                }),
                borderData: FlBorderData(
                  show: false,
                ),
                sectionsSpace: 0,
                centerSpaceRadius: 40,
                sections: showingSections()),
          ),
        ),
      ],
    );
  }

  List<PieChartSectionData> showingSections() {
    return List.generate(widget.values.length, (i) {
      Map<String, dynamic> e = widget.values[i];

      final isTouched = i == touchedIndex;
      final double fontSize = isTouched ? 25 : 16;
      final double radius = isTouched ? 60 : 50;
      return PieChartSectionData(
        color: colors[i],
        value: (e["value"] is String) ? double.parse(e["value"]) : e["value"],
        title: e["title"] == "0%" ? "" : e["title"],
        radius: radius,
        titleStyle: TextStyle(
            fontSize: fontSize,
            fontWeight: FontWeight.bold,
            color: const Color(0xffffffff)),
      );
    });

//    return List.generate(4, (i) {
//      final isTouched = i == touchedIndex;
//      final double fontSize = isTouched ? 25 : 16;
//      final double radius = isTouched ? 60 : 50;
//      switch (i) {
//        case 0:
//          return PieChartSectionData(
//            color: const Color(0xff0293ee),
//            value: 40,
//            title: '40%',
//            radius: radius,
//            titleStyle: TextStyle(
//                fontSize: fontSize,
//                fontWeight: FontWeight.bold,
//                color: const Color(0xffffffff)),
//          );
//        case 1:
//          return PieChartSectionData(
//            color: const Color(0xfff8b250),
//            value: 30,
//            title: '30%',
//            radius: radius,
//            titleStyle: TextStyle(
//                fontSize: fontSize,
//                fontWeight: FontWeight.bold,
//                color: const Color(0xffffffff)),
//          );
//        case 2:
//          return PieChartSectionData(
//            color: const Color(0xff845bef),
//            value: 15,
//            title: '15%',
//            radius: radius,
//            titleStyle: TextStyle(
//                fontSize: fontSize,
//                fontWeight: FontWeight.bold,
//                color: const Color(0xffffffff)),
//          );
//        case 3:
//          return PieChartSectionData(
//            color: const Color(0xff13d38e),
//            value: 15,
//            title: '15%',
//            radius: radius,
//            titleStyle: TextStyle(
//                fontSize: fontSize,
//                fontWeight: FontWeight.bold,
//                color: const Color(0xffffffff)),
//          );
//        default:
//          return null;
//      }
//    });
  }

  @override
  bool get wantKeepAlive => true;
}
