import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';

import '../../consts/color.dart';
import '../../widgets/back_button.dart';
import '../../widgets/common_alert_dialog.dart';
import 'company_info_card.dart';
import 'fire_agent_statistic_card.dart';
import 'fire_equipment_statistic_card.dart';
import 'fire_vehicle_statistic_card.dart';

class Statistic extends StatefulWidget {
  @override
  _MineState createState() => _MineState();
}

class _MineState extends State<Statistic> {
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    initThemeConfig();
  }

  String theme = '';

  initThemeConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        this.theme =
            preferences.getString("theme") ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Color(0xFFefeff4),
      appBar: AppBar(
        leading: LeadingButton(
          theme: theme,
        ),
        automaticallyImplyLeading: false,
        title: Text(
          "统计"
        ),
        // SearchBar(
        //   title: "查找装备",
        //   onTap: (){
        //     Application.navigateTo(context, Routes.commonSearchList);
        //   },
        // ),
        centerTitle: true,
        //   actions: <Widget>[
        //     Container(
        //       padding: EdgeInsets.symmetric(horizontal: 10.px),
        //       child: SvgButton(
        //         src:"assets/images/home_bar_scan.svg",
        //         size: 30.px,
        //         imageSize: 18.px,
        //         onTap: (){
        //           final params = {
        //             "title":"查询",
        //             "category":RouteCategoryFrontComponentConst.query
        //           };
        //           Application.navigateToPath(context, Routes.equipWareHousing,params: params);
        //         },
        //       ),
        //     )
        //   ],
      ),
      body: ListView(
        children: <Widget>[
          CompanyInfoCard(),
          //FireFighterCard(),
          FireEquipmentStatisticCard(),
          FireVehicleStatisticCard(),
          FireAgentStatisticCard()
        ],
      ),
//      floatingActionButton: FloatingActionButton(
//        child: Icon(Icons.add),
//        onPressed:() => showDialog2(context),
//      ),
    );
  }

  void showDialog2(context) async {
//    showDialog(context: context,builder: (ctx){
//      return LoadingDialog(
//        barrierDismissible: false,
//      );
//    });

    showDialog<Null>(
        context: context, //BuildContext对象
        builder: (BuildContext context) {
          return CommonAlertDialog(
            theme: theme,
            onTap: () {},
            onCancelTap: () {},
            content: "是否放回原位？",
            subtitle: "选择否的话需要重新入账",
          );
        });
//      final params = {
//        "title":"车辆详情",
//        "type":"2"
//      };
//      Application.navigateToPath(context, Routes.submitSuccess);

//    String data = await rootBundle.loadString("assets/json/position.json");
//    List items = json.decode(data);
//
//    showModalBottomSheet(
//        enableDrag:false,
//        shape: RoundedRectangleBorder(
//          borderRadius: BorderRadius.circular(10.px)
//        ),
//        context: context,
//        builder: (BuildContext context){
//          return ChoosePositionDialog(
//            data: items,
//          );
//        }
//    );
//     final parmas = {
//       "qrCode":"01#150088725963",
//       "warehouseId":"1"
//     };
//     HttpRequest.queryGlobalQR(params: parmas).then((value) {
//
//     });
  }
}
