import 'dart:ui';

import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';

import '../utils/GetConfig.dart';
import 'number_limit_input_format.dart';

class AddCountDialog extends Dialog {
  final Function(String value) callback;
  final String title;
  final String until;
  final String theme;
  AddCountDialog({Key key, this.callback, this.title, this.until, this.theme})
      : super(key: key);

  TextEditingController controller = TextEditingController();

  @override
  Widget build(BuildContext context) {
    return Material(
      //创建透明层
      type: MaterialType.transparency, //透明类型
      child: Container(
        child: Center(
          child: Container(
            decoration: ShapeDecoration(
                color: Colors.white,
                shape: RoundedRectangleBorder(
                    borderRadius: BorderRadius.circular(10.px))),
            width: MediaQuery.of(context).size.width - 40.px,
            child: Column(
              mainAxisSize: MainAxisSize.min,
              children: <Widget>[
                buildTopBar(context),
                buildTextField(context),
                buildButton(context)
              ],
            ),
          ),
        ),
      ),
    );
  }

  // 头部
  Widget buildTopBar(context) {
    return Container(
      height: 44.px,
      child: Stack(children: [
        Container(
          padding: EdgeInsets.symmetric(vertical: 10.px),
          decoration: ShapeDecoration(
              color: const Color(0xFFefeff4),
              shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.only(
                      topLeft: Radius.circular(5.px),
                      topRight: Radius.circular(5.px)))),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Text(
                "${title ?? "输入数量"}",
                style: Theme.of(context)
                    .textTheme
                    .headline4
                    .copyWith(fontSize: 16.px),
              )
            ],
          ),
        ),
        Align(
            alignment: Alignment.centerRight,
            child: Container(
              padding: const EdgeInsets.only(right: 10),
              child: SvgButton(
                src: 'assets/images/icon_close.svg',
                imageSize: 12.px,
                onTap: () {
                  Navigator.of(context).pop();
                },
              ),
            ))
      ]),
    );
  }

  // 输入框
  Widget buildTextField(context) {
    return Padding(
      padding: EdgeInsets.symmetric(horizontal: 20.px, vertical: 10.px),
      child: Row(
        children: <Widget>[
          Text(
            '数量',
            style:
                Theme.of(context).textTheme.headline3.copyWith(fontSize: 16.px),
          ),
          SizedBox(
            width: 10.px,
          ),
          Expanded(
            child: TextField(
              autofocus: true,
              decoration: const InputDecoration(border: InputBorder.none),
              keyboardType: TextInputType.number,
              controller: controller,
              inputFormatters: [NumberTextInputFormatter(digit: 2)],
            ),
          ),
          Text(
            "${until ?? "吨"}",
            style:
                Theme.of(context).textTheme.headline3.copyWith(fontSize: 16.px),
          ),
        ],
      ),
    );
  }

  // 按钮
  Widget buildButton(context) {
    return Container(
      padding: EdgeInsets.only(top: 10.px),
      width: MediaQuery.of(context).size.width,
      height: 50.px,
      child: RaisedButton(
        color: GetConfig.getColor(theme),
        child: Text(
          '确定',
          style: Theme.of(context).textTheme.headline6.copyWith(
              color: Colors.white),
        ),
        onPressed: () {
          Navigator.of(context).pop();
          if (callback != null) {
            callback(controller.text);
          }
        },
      ),
    );
  }
}
