import 'package:flutter/material.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';

import '../../utils/GetConfig.dart';
import '../../utils/flutter_toast.dart';

class SelectReasonDialog extends StatefulWidget {
  final ValueChanged<String> callback;
  final List requestReasons;
  final String theme;

  SelectReasonDialog({this.callback, this.requestReasons, this.theme});

  @override
  _PositionDescriptionDialogState createState() =>
      _PositionDescriptionDialogState();
}

class _PositionDescriptionDialogState extends State<SelectReasonDialog> {
  int count = 0;
  List reasons = [
    {"name": "过期"},
    {"name": "失效"},
    {"name": "其他原因"}
  ];
  @override
  void initState() {
    super.initState();

    List requestReasons = widget.requestReasons;
    if (requestReasons != null) {
      for (var reason in requestReasons) {
        reason["selected"] = "0";
      }
    } else {
      for (var reason in reasons) {
        reason["selected"] = "0";
      }
    }
  }

  @override
  Widget build(BuildContext context) {
    return StreamBuilder<Object>(builder: (context, snapshot) {
      return SingleChildScrollView(
        child: Container(
          padding:
              EdgeInsets.only(bottom: MediaQuery.of(context).viewInsets.bottom),
          child: Column(
            mainAxisSize: MainAxisSize.min,
            children: <Widget>[
              buildTopBar(context),
              buildListContent(context),
              Container(
                width: double.infinity,
                height: 96.rpx,
                child: RaisedButton(
                  shape: BeveledRectangleBorder(),
                  color: GetConfig.getColor(widget.theme),
                  onPressed: () => confirm(context),
                  child: Text(
                    "确定",
                    style: Theme.of(context)
                        .textTheme
                        .headline5
                        .copyWith(color: Colors.white),
                  ),
                ),
              )
            ],
          ),
        ),
      );
    });
  }

  Widget buildTopBar(context) {
    return Container(
      height: 44.px,
      child: Stack(children: [
        Container(
          padding: EdgeInsets.symmetric(vertical: 10.px),
          decoration: ShapeDecoration(
              color: Color(0xFFefeff4),
              shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.only(
                      topLeft: Radius.circular(5.px),
                      topRight: Radius.circular(5.px)))),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Text(
                "请选择原因(可多选)",
                style: Theme.of(context).textTheme.headline4.copyWith(fontSize: 16),
              )
            ],
          ),
        ),
        Align(
            alignment: Alignment.centerRight,
            child: Container(
              padding: EdgeInsets.only(right: 10),
              child: SvgButton(
                src: "assets/images/icon_close.svg",
                imageSize: 12.px,
                onTap: () {
                  Navigator.of(context).pop();
                },
              ),
            ))
      ]),
    );
  }

  Widget buildListContent(context) {
    return Container(
      height: 300.px,
      child: ListView.builder(
          itemCount: widget.requestReasons != null
              ? widget.requestReasons.length
              : reasons.length,
          shrinkWrap: true,
          itemBuilder: (ctx, index) {
            Map item;
            if (widget.requestReasons != null) {
              item = widget.requestReasons[index];
            } else {
              item = reasons[index];
            }

            return Padding(
                padding: EdgeInsets.symmetric(horizontal: 30.px),
                child: InkWell(
                    onTap: () {
                      String selected = item["selected"];
                      if (selected == "0") {
                        item["selected"] = "1";
                      } else {
                        item["selected"] = "0";
                      }
                      setState(() {});
                    },
                    child: Padding(
                      padding: EdgeInsets.symmetric(vertical: 15.px),
                      child: Text(
                        "${item["name"]}",
                        style: TextStyle(
                            color: item["selected"] == "1"
                                ? GetConfig.getColor(widget.theme)
                                : Color(0xFF999999)),
                      ),
                    )));
          }),
    );
  }

  // 确定
  void confirm(context) {
    List subReason = [];
    if (widget.requestReasons != null) {
      subReason.addAll(widget.requestReasons);
    } else {
      subReason.addAll(reasons);
    }

    List<String> result = [];
    for (int index = 0, length = subReason.length; index < length; index++) {
      final reason = subReason[index];
      if (reason["selected"] == "1") {
        result.add(reason["name"]);
      }
    }
    if (result.length == 0) {
      FlutterToast.toastCenter("请选择原因!");
      return;
    }
    if (widget.callback != null) {
      widget.callback(result.join(","));
    }
    Navigator.of(context).pop();
  }
}
