import 'package:flutter/material.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';

import '../../utils/GetConfig.dart';
import '../../utils/flutter_toast.dart';

class VehicleModalDialog extends StatefulWidget {
  final List vehicles;
  final ValueChanged<Map<String, dynamic>> confirm;
  final String theme;
  VehicleModalDialog({this.vehicles, this.confirm, this.theme});

  @override
  _VehicleModalDialogState createState() => _VehicleModalDialogState();
}

class _VehicleModalDialogState extends State<VehicleModalDialog> {
  int _index;

  @override
  Widget build(BuildContext context) {
    return StreamBuilder<Object>(builder: (context, snapshot) {
      return Container(
        padding:
            EdgeInsets.only(bottom: MediaQuery.of(context).viewInsets.bottom),
        child: Column(
          children: <Widget>[
            buildTopBar(context),
            Expanded(
              child: Padding(
                padding: EdgeInsets.only(left: 77.rpx),
                child: ListView.builder(
                    padding: EdgeInsets.zero,
                    shrinkWrap: true,
                    itemCount: widget.vehicles.length,
                    itemBuilder: (ctx, index) {
                      return InkWell(
                        onTap: () {
                          setState(() {
                            _index = index;
                          });
                        },
                        child: Padding(
                          padding: EdgeInsets.symmetric(vertical: 14.px),
                          child: Text(
                            "${widget.vehicles[index]["carNum"]}",
                            style: Theme.of(context)
                                .textTheme
                                .headline6
                                .copyWith(
                                    color: _index == index
                                        ? GetConfig.getColor(widget.theme)
                                        : Color(0xFF666666)),
                          ),
                        ),
                      );
                    }),
              ),
            ),
            Container(
              width: double.infinity,
              height: 96.rpx,
              child: RaisedButton(
                color: GetConfig.getColor(widget.theme),
                onPressed: () => confirm(context),
                child: Text(
                  "确定",
                  style: Theme.of(context)
                      .textTheme
                      .headline6
                      .copyWith(color: Colors.white),
                ),
              ),
            )
          ],
        ),
      );
    });
  }

  // 顶部布局
  Widget buildTopBar(context) {
    return Container(
      height: 44.px,
      child: Stack(children: [
        Container(
          padding: EdgeInsets.symmetric(vertical: 10.px),
          decoration: ShapeDecoration(
              color: Color(0xFFefeff4),
              shape: RoundedRectangleBorder(
                  borderRadius: BorderRadius.only(
                      topLeft: Radius.circular(5.px),
                      topRight: Radius.circular(5.px)))),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.center,
            children: <Widget>[
              Text(
                "选择车辆",
                // style: Theme.of(context).textTheme.headline6,
              )
            ],
          ),
        ),
        Align(
            alignment: Alignment.centerRight,
            child: Container( 
              padding: EdgeInsets.only(right: 10),
              child: SvgButton(
                src: "assets/images/icon_close.svg",
                imageSize: 12.px,
                onTap: () {
                  Navigator.of(context).pop();
                },
              ),
            ))
      ]),
    );
  }

  // 确定
  void confirm(BuildContext context) {
    if (_index == null) {
      FlutterToast.toastCenter("请选择车辆!");
    } else {
      Navigator.of(context).pop();
      if (widget.confirm != null) {
        widget.confirm(widget.vehicles[_index]);
      }
    }
  }
}
