import 'package:flutter/material.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';

import '../utils/GetConfig.dart';

class QuoteChip extends StatelessWidget {
  final String quote;
  final String theme;

  QuoteChip({@required this.quote, this.theme});

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: EdgeInsets.symmetric(horizontal: 2.px, vertical: 1.px),
      //margin: EdgeInsets.all(2.px),
      decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(5.px),
          border: Border.all(width: 1.px, color: GetConfig.getColor(theme))),
      child: Text(
        this.quote,
        style: Theme.of(context)
            .textTheme
            .bodyText1
            .copyWith(color: GetConfig.getColor(theme)),
      ),
    );
  }
}
