import 'package:flutter/material.dart';

class HotSugWidget extends StatelessWidget {
  final List hotWords;
  final ValueChanged<String> searchData;
  final Function deleteBtnClick;
  final title;
  final String theme;

  const HotSugWidget({Key key, this.theme, this.hotWords, this.title, this.searchData, this.deleteBtnClick})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: <Widget>[
        Container(
          height: 40,
          padding: const EdgeInsets.only(left: 20),
          alignment: Alignment.centerLeft,
          color: Colors.white,
          child: Row(
            children: <Widget>[
              Expanded(
                child: Text(
                  title,
                  style: const TextStyle(color: Color(0xff333333), fontSize: 17, fontWeight: FontWeight.bold),
                ),
                flex: 9,
              ),
              Expanded(
                child: GestureDetector(child: const Icon(Icons.clear), onTap: () => deleteBtnClick()),
                flex: 1,
              ),
            ],
          ),
          margin: const EdgeInsets.only(bottom: 10),
        ),
        const Divider(
          height: 1,
        ),
        Padding(
          padding: const EdgeInsets.only(left: 10, right: 10, top: 10, bottom: 10),
          child: Wrap(
            spacing: 10,
            runSpacing: 10,
            children: hotWords
                .map((i) => GestureDetector(
                      onTap: () => searchData(i),
                      child: Container(
                          decoration:
                              BoxDecoration(color: const Color(0xFFF2F2F2), borderRadius: BorderRadius.circular(5)),
                          padding: const EdgeInsets.symmetric(vertical: 5, horizontal: 7),
                          child: Text(
                            i,
                            style: const TextStyle(color: Color(0xFF999999)),
                          )),
                    ))
                .toList(),
          ),
        )
      ],
    );
  }
}
