import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg_provider/flutter_svg_provider.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';


class TopBarButton extends StatelessWidget {
  final String name;
  final VoidCallback onPressed;

  TopBarButton({@required this.name, @required this.onPressed});

  @override
  Widget build(BuildContext context) {
    return FlatButton(
      onPressed: onPressed,
      child: Row(
        mainAxisSize: MainAxisSize.min,
        crossAxisAlignment: CrossAxisAlignment.center,
        children: <Widget>[
          Text(
            name,
            style: Theme.of(context).textTheme.headline4,
          ),
          SizedBox(
            width: 4.px,
          ),
          Image(
            image: Svg("assets/images/icon_filter.svg", size: Size(12, 12)),
          )
        ],
      ),
    );
  }
}
