class CarScanModel {
  CarScanModel({
    this.qrCode,
    this.amount,
    this.equipmentId,
    this.carId,
    this.carNum,
    this.equipName,
    this.img,
    this.unit,
    this.equProperties,
    this.total,
    this.Status,
  });

  String qrCode;
  dynamic amount;
  String equipmentId;
  String carId;
  String carNum;
  String equipName;
  String img;
  String unit;
  List<CarEquProperty> equProperties;
  dynamic total;
  String Status;

  CarScanModel.fromJson(Map<String, dynamic> json) {
    qrCode = json["qrCode"];

    amount = double.parse(json["amount"].toString()).round();
    equipmentId = json["equipmentId"];
    carId = json["carId"];
    carNum = json["carNum"];
    equipName = json["equipName"];
    img = json["img"];
    unit = json["unit"];
    if (json['equProperties'] != null) {
      equProperties = new List<CarEquProperty>();
      json['equProperties'].forEach((v) {
        equProperties.add(new CarEquProperty.fromJson(v));
      });
    }
    // equProperties: List<EquProperty>.from(json["equProperties"].map((x) => EquProperty.fromJson(x))),
    total = json["total"];
    Status = json['carState'];
  }

  Map<String, dynamic> toJson() => {
        "qrCode": qrCode,
        "amount": amount,
        "equipmentId": equipmentId,
        "carId": carId,
        "carNum": carNum,
        "equipName": equipName,
        "img": img,
        "unit": unit,
        "equProperties":
            List<dynamic>.from(equProperties.map((x) => x.toJson())),
        "total": total,
      };
}

class CarEquProperty {
  CarEquProperty({
    this.name,
    this.value,
    this.unit,
    this.symbol,
    this.textLine,
    this.isImportentParameter,
  });

  String name;
  String value;
  String unit;
  String symbol;
  String textLine;
  bool isImportentParameter;

  factory CarEquProperty.fromJson(Map<String, dynamic> json) => CarEquProperty(
        name: json["name"],
        value: json["value"],
        unit: json["unit"],
        symbol: json["symbol"],
        textLine: json["textLine"],
        isImportentParameter: json["isImportentParameter"],
      );

  Map<String, dynamic> toJson() => {
        "name": name,
        "value": value,
        "unit": unit,
        "symbol": symbol,
        "textLine": textLine,
        "isImportentParameter": isImportentParameter,
      };
}
