class EquipmentInfoModel {
  EquipmentInfoModel({
    this.maintenanceCycle,
    this.equipName,
    this.equipmentCode,
    this.equipCate,
    this.equipCategoryCode,
    this.perfQuota,
    this.equipmentId,
    this.equipmentDetailId,
    this.film,
    this.img,
    this.unit,
    this.qrCode,
    this.manufacturer,
    this.standard,
    this.supplier,
    this.brand,
    this.dateProduced,
    this.remark,
    this.contractCode,
    this.equProperties,
    this.count,
    this.isCarLoad,
    this.carId,
    this.carNum,
    this.stockDetailId,
    this.thumbnail,
    this.goodsAllocationCode,
    this.shelfCellId,
    this.total,
    this.status,
    this.carCompany,
    this.carType,
    this.warehouseName,
  });

  dynamic maintenanceCycle;
  String equipName;
  dynamic equipmentCode;
  dynamic equipCate;
  String equipCategoryCode;
  String perfQuota;
  String equipmentId;
  String equipmentDetailId;
  dynamic film;
  String img;
  String unit;
  String qrCode;
  dynamic manufacturer;
  String standard;
  dynamic supplier;
  String brand;
  DateTime dateProduced;
  dynamic remark;
  String contractCode;
  List<dynamic> equProperties;
  dynamic count;
  bool isCarLoad;
  dynamic carId;
  dynamic carNum;
  dynamic stockDetailId;
  String thumbnail;
  dynamic goodsAllocationCode;
  dynamic shelfCellId;
  dynamic total;
  dynamic status;
  String carCompany;
  dynamic carType;
  dynamic warehouseName;

  factory EquipmentInfoModel.fromJson(Map<String, dynamic> json) =>
      EquipmentInfoModel(
        maintenanceCycle: json["maintenanceCycle"],
        equipName: json["equipName"],
        equipmentCode: json["equipmentCode"],
        equipCate: json["equipCate"],
        equipCategoryCode: json["equipCategoryCode"],
        perfQuota: json["perfQuota"],
        equipmentId: json["equipmentId"],
        equipmentDetailId: json["equipmentDetailId"],
        film: json["film"],
        img: json["img"],
        unit: json["unit"],
        qrCode: json["qrCode"],
        manufacturer: json["manufacturer"],
        standard: json["standard"],
        supplier: json["supplier"],
        brand: json["brand"],
        dateProduced: DateTime.parse(json["dateProduced"]),
        remark: json["remark"],
        contractCode: json["contractCode"],
        equProperties: List<dynamic>.from(json["equProperties"].map((x) => x)),
        count: json["count"],
        isCarLoad: json["isCarLoad"],
        carId: json["carId"],
        carNum: json["carNum"],
        stockDetailId: json["stockDetailId"],
        thumbnail: json["thumbnail"],
        goodsAllocationCode: json["goodsAllocationCode"],
        shelfCellId: json["shelfCellId"],
        total: json["total"].round(),
        status: json["status"],
        carCompany: json["carCompany"],
        carType: json["carType"],
        warehouseName: json["warehouseName"],
      );

  Map<String, dynamic> toJson() => {
        "maintenanceCycle": maintenanceCycle,
        "equipName": equipName,
        "equipmentCode": equipmentCode,
        "equipCate": equipCate,
        "equipCategoryCode": equipCategoryCode,
        "perfQuota": perfQuota,
        "equipmentId": equipmentId,
        "equipmentDetailId": equipmentDetailId,
        "film": film,
        "img": img,
        "unit": unit,
        "qrCode": qrCode,
        "manufacturer": manufacturer,
        "standard": standard,
        "supplier": supplier,
        "brand": brand,
        "dateProduced": dateProduced.toIso8601String(),
        "remark": remark,
        "contractCode": contractCode,
        "equProperties": List<dynamic>.from(equProperties.map((x) => x)),
        "count": count,
        "isCarLoad": isCarLoad,
        "carId": carId,
        "carNum": carNum,
        "stockDetailId": stockDetailId,
        "thumbnail": thumbnail,
        "goodsAllocationCode": goodsAllocationCode,
        "shelfCellId": shelfCellId,
        "total": total,
        "status": status,
        "carCompany": carCompany,
        "carType": carType,
        "warehouseName": warehouseName,
      };
}
