class EquipmentTypeModel {
  EquipmentTypeModel({
    this.id,
    this.createDate,
    this.parentId,
    this.code,
    this.name,
    this.isConsumptive,
    this.description,
    this.remark,
    this.level,
    this.count,
    this.hasLowerClassification,
    this.children,
  });

  String id;
  DateTime createDate;
  dynamic parentId;
  String code;
  String name;
  bool isConsumptive;
  dynamic description;
  String remark;
  dynamic level;
  dynamic count;
  bool hasLowerClassification;
  List<dynamic> children;

  factory EquipmentTypeModel.fromJson(Map<String, dynamic> json) =>
      EquipmentTypeModel(
        id: json["id"],
        createDate: DateTime.parse(json["createDate"]),
        parentId: json["parentId"],
        code: json["code"],
        name: json["name"],
        isConsumptive: json["isConsumptive"],
        description: json["description"],
        remark: json["remark"],
        level: json["level"],
        count: json["count"],
        hasLowerClassification: json["hasLowerClassification"],
        children: List<dynamic>.from(json["children"].map((x) => x)),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "createDate": createDate.toIso8601String(),
        "parentId": parentId,
        "code": code,
        "name": name,
        "isConsumptive": isConsumptive,
        "description": description,
        "remark": remark,
        "level": level,
        "count": count,
        "hasLowerClassification": hasLowerClassification,
        "children": List<dynamic>.from(children.map((x) => x)),
      };
}
