class ScrapDetailListModel {
  ScrapDetailListModel({
    this.id,
    this.createDate,
    this.scrapId,
    this.stockDetailId,
    this.stockDetail,
    this.amount,
    this.car,
    this.carId,
    this.reason,
    this.img,
  });

  String id;
  DateTime createDate;
  String scrapId;
  String stockDetailId;
  StockDetail stockDetail;
  dynamic amount;
  dynamic carId;
  dynamic car;
  String reason;
  String img;

  factory ScrapDetailListModel.fromJson(Map<String, dynamic> json) =>
      ScrapDetailListModel(
          id: json["id"],
          createDate: DateTime.parse(json["createDate"]),
          scrapId: json["scrapId"],
          stockDetailId: json["stockDetailId"],
          stockDetail: StockDetail.fromJson(json["stockDetail"]),
          amount: json["amount"],
          car: json["car"],
          carId: json["carId"],
          reason: json["reason"],
          img: json['img']);

  Map<String, dynamic> toJson() => {
        "id": id,
        "createDate": createDate.toIso8601String(),
        "scrapId": scrapId,
        "stockDetailId": stockDetailId,
        "stockDetail": stockDetail.toJson(),
        "amount": amount,
        "car": car,
        "carId": carId,
        "reason": reason,
        "img": img,
      };
}

class StockDetail {
  StockDetail({
    this.id,
    this.createDate,
    this.amount,
    this.stockId,
    this.warehouseStructureId,
    //this.batchNum,
    this.rfid,
    this.equipmentDetailId,
    this.equipmentDetail,
    this.warehouseId,
    this.qrCode,
    this.status,
    this.description,
    this.companyName,
    this.orgCode,
    this.departmentName,
    this.departmentOrgcode,
  });

  String id;
  dynamic createDate;
  dynamic amount;
  String stockId;
  String warehouseStructureId;
  //DateTime batchNum;
  dynamic rfid;
  String equipmentDetailId;
  EquipmentDetail equipmentDetail;
  String warehouseId;
  String qrCode;
  String status;
  String description;
  String companyName;
  String orgCode;
  String departmentName;
  String departmentOrgcode;

  factory StockDetail.fromJson(Map<String, dynamic> json) => StockDetail(
        id: json["id"],
        createDate: json["createDate"],
        amount: json["amount"],
        stockId: json["stockId"],
        warehouseStructureId: json["warehouseStructureId"],
        //batchNum: DateTime.parse(json["batchNum"]),
        rfid: json["rfid"],
        equipmentDetailId: json["equipmentDetailId"],
        equipmentDetail: json.containsKey('equipmentDetail')
            ? EquipmentDetail.fromJson(json["equipmentDetail"])
            : EquipmentDetail(),
        warehouseId: json["warehouseId"],
        qrCode: json["qrCode"],
        status: json["status"],
        description: json["description"],
        companyName: json["companyName"],
        orgCode: json["orgCode"],
        departmentName: json["departmentName"],
        departmentOrgcode: json["departmentOrgcode"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "createDate": createDate.toIso8601String(),
        "amount": amount,
        "stockId": stockId,
        "warehouseStructureId": warehouseStructureId,
        //"batchNum": "${batchNum.year.toString().padLeft(4, '0')}-${batchNum.month.toString().padLeft(2, '0')}-${batchNum.day.toString().padLeft(2, '0')}",
        "rfid": rfid,
        "equipmentDetailId": equipmentDetailId,
        "equipmentDetail": equipmentDetail.toJson(),
        "warehouseId": warehouseId,
        "qrCode": qrCode,
        "status": status,
        "description": description,
        "companyName": companyName,
        "orgCode": orgCode,
        "departmentName": departmentName,
        "departmentOrgcode": departmentOrgcode,
      };
}

class EquipmentDetail {
  EquipmentDetail({
    this.id,
    this.createDate,
    this.name,
    this.code,
    this.equipmentId,
    this.equipment,
    this.categoryName,
    this.remark,
    this.creatorId,
    this.unitId,
    this.manufacturerId,
    this.manufacturerName,
    this.manufacturerInfo,
    this.standard,
    this.img,
    this.video,
    this.maintenanceCycle,
    this.updateDate,
    this.agent,
    this.brand,
    this.contractCode,
    this.productionDate,
    this.perfQuotaStr,
    this.expiryDate,
    this.priceInterregional,
    this.country,
    this.supplierId,
    this.certifications,
    this.instructionManual,
    this.equPropertyList,
    this.orgCode,
    this.companyName,
    this.departmentOrgcode,
    this.departmentName,
    this.equipmentDetailImport,
  });

  String id;
  dynamic createDate;
  String name;
  String code;
  String equipmentId;
  Equipment equipment;
  dynamic categoryName;
  String remark;
  dynamic creatorId;
  String unitId;
  String manufacturerId;
  dynamic manufacturerName;
  dynamic manufacturerInfo;
  String standard;
  dynamic img;
  dynamic video;
  dynamic maintenanceCycle;
  dynamic updateDate;
  String agent;
  String brand;
  String contractCode;
  dynamic productionDate;
  String perfQuotaStr;
  dynamic expiryDate;
  dynamic priceInterregional;
  dynamic country;
  dynamic supplierId;
  dynamic certifications;
  dynamic instructionManual;
  List<dynamic> equPropertyList;
  String orgCode;
  String companyName;
  String departmentOrgcode;
  String departmentName;
  bool equipmentDetailImport;

  factory EquipmentDetail.fromJson(Map<String, dynamic> json) =>
      EquipmentDetail(
        id: json["id"],
        createDate: json["createDate"],
        name: json["name"],
        code: json["code"],
        equipmentId: json["equipmentId"],
        equipment: json["equipment"] != null
            ? Equipment.fromJson(json["equipment"])
            : Equipment(),
        categoryName: json["categoryName"],
        remark: json["remark"],
        creatorId: json["creatorId"],
        unitId: json["unitId"],
        manufacturerId: json["manufacturerId"],
        manufacturerName: json["manufacturerName"],
        manufacturerInfo: json["manufacturerInfo"],
        standard: json["standard"],
        img: json["img"],
        video: json["video"],
        maintenanceCycle: json["maintenanceCycle"],
        updateDate: json["updateDate"],
        agent: json["agent"],
        brand: json["brand"],
        contractCode: json["contractCode"],
        productionDate: json["productionDate"],
        perfQuotaStr: json["perfQuotaStr"],
        expiryDate: json["expiryDate"],
        priceInterregional: json["priceInterregional"],
        country: json["country"],
        supplierId: json["supplierId"],
        certifications: json["certifications"],
        instructionManual: json["instructionManual"],
        equPropertyList: json["equPropertyList"] != null
            ? List<dynamic>.from(json["equPropertyList"].map((x) => x))
            : [],
        orgCode: json["orgCode"],
        companyName: json["companyName"],
        departmentOrgcode: json["departmentOrgcode"],
        departmentName: json["departmentName"],
        equipmentDetailImport: json["import"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "createDate": createDate,
        "name": name,
        "code": code,
        "equipmentId": equipmentId,
        "equipment": equipment.toJson(),
        "categoryName": categoryName,
        "remark": remark,
        "creatorId": creatorId,
        "unitId": unitId,
        "manufacturerId": manufacturerId,
        "manufacturerName": manufacturerName,
        "manufacturerInfo": manufacturerInfo,
        "standard": standard,
        "img": img,
        "video": video,
        "maintenanceCycle": maintenanceCycle,
        "updateDate": updateDate,
        "agent": agent,
        "brand": brand,
        "contractCode": contractCode,
        "productionDate": productionDate,
        "perfQuotaStr": perfQuotaStr,
        "expiryDate": expiryDate,
        "priceInterregional": priceInterregional,
        "country": country,
        "supplierId": supplierId,
        "certifications": certifications,
        "instructionManual": instructionManual,
        "equPropertyList": List<dynamic>.from(equPropertyList.map((x) => x)),
        "orgCode": orgCode,
        "companyName": companyName,
        "departmentOrgcode": departmentOrgcode,
        "departmentName": departmentName,
        "import": equipmentDetailImport,
      };
}

class Equipment {
  Equipment({
    this.id,
    this.createDate,
    this.name,
    this.code,
    this.categoryId,
    this.country,
    this.maintenanceCycle,
    this.checkCycle,
    this.remark,
    this.managementStyle,
    this.reviserId,
    this.dateUpdated,
    this.createrId,
    this.dateCreated,
    this.unitId,
    this.unit,
    this.madeIn,
    this.manufacturer,
    this.img,
    this.video,
    this.markSpecification,
    this.supplierId,
    this.prefQuota,
    this.equipmentCategory,
  });

  String id;
  dynamic createDate;
  String name;
  String code;
  String categoryId;
  dynamic country;
  dynamic maintenanceCycle;
  dynamic checkCycle;
  dynamic remark;
  dynamic managementStyle;
  dynamic reviserId;
  dynamic dateUpdated;
  dynamic createrId;
  DateTime dateCreated;
  String unitId;
  dynamic unit;
  dynamic madeIn;
  dynamic manufacturer;
  String img;
  dynamic video;
  dynamic markSpecification;
  dynamic supplierId;
  dynamic prefQuota;
  EquipmentCategory equipmentCategory;

  factory Equipment.fromJson(Map<String, dynamic> json) => Equipment(
        id: json["id"],
        createDate: json["createDate"],
        name: json["name"],
        code: json["code"],
        categoryId: json["categoryId"],
        country: json["country"],
        maintenanceCycle: json["maintenanceCycle"],
        checkCycle: json["checkCycle"],
        remark: json["remark"],
        managementStyle: json["managementStyle"],
        reviserId: json["reviserId"],
        dateUpdated: json["dateUpdated"],
        createrId: json["createrId"],
        unitId: json["unitId"],
        unit: json["unit"],
        madeIn: json["madeIn"],
        manufacturer: json["manufacturer"],
        img: json["img"],
        video: json["video"],
        markSpecification: json["markSpecification"],
        supplierId: json["supplierId"],
        prefQuota: json["prefQuota"],
        equipmentCategory:
            EquipmentCategory.fromJson(json["equipmentCategory"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "createDate": createDate,
        "name": name,
        "code": code,
        "categoryId": categoryId,
        "country": country,
        "maintenanceCycle": maintenanceCycle,
        "checkCycle": checkCycle,
        "remark": remark,
        "managementStyle": managementStyle,
        "reviserId": reviserId,
        "dateUpdated": dateUpdated,
        "createrId": createrId,
        "dateCreated": dateCreated.toIso8601String(),
        "unitId": unitId,
        "unit": unit,
        "madeIn": madeIn,
        "manufacturer": manufacturer,
        "img": img,
        "video": video,
        "markSpecification": markSpecification,
        "supplierId": supplierId,
        "prefQuota": prefQuota,
        "equipmentCategory": equipmentCategory.toJson(),
      };
}

class EquipmentCategory {
  EquipmentCategory({
    this.id,
    this.createDate,
    this.parentId,
    this.code,
    this.name,
    this.isConsumptive,
    this.description,
    this.remark,
    this.level,
    this.count,
    this.hasLowerClassification,
    this.children,
  });

  String id;
  DateTime createDate;
  String parentId;
  String code;
  String name;
  bool isConsumptive;
  dynamic description;
  String remark;
  dynamic level;
  dynamic count;
  bool hasLowerClassification;
  dynamic children;

  factory EquipmentCategory.fromJson(Map<String, dynamic> json) =>
      EquipmentCategory(
        id: json["id"],
        createDate: DateTime.parse(json["createDate"]),
        parentId: json["parentId"],
        code: json["code"],
        name: json["name"],
        isConsumptive: json["isConsumptive"],
        description: json["description"],
        remark: json["remark"],
        level: json["level"],
        count: json["count"],
        hasLowerClassification: json["hasLowerClassification"],
        children: json["children"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "createDate": createDate.toIso8601String(),
        "parentId": parentId,
        "code": code,
        "name": name,
        "isConsumptive": isConsumptive,
        "description": description,
        "remark": remark,
        "level": level,
        "count": count,
        "hasLowerClassification": hasLowerClassification,
        "children": List<dynamic>.from(children.map((x) => x)),
      };
}
