class TreeNodeModel {
  TreeNodeModel({
    this.id,
    // this.createDate,
    this.code,
    this.name,
    this.fullName,
    this.parentId,
    this.cellType,
    this.cellCode,
    this.warehouseId,
    this.remark,
    this.children,
    this.absolutePosition,
  });

  String id;
  //DateTime createDate;
  String code;
  String name;
  String fullName;
  dynamic parentId;
  dynamic cellType;
  String cellCode;
  String warehouseId;
  String remark;
  String absolutePosition;
  List<TreeNodeModel> children;

  bool expand; // 是否在展开
  int depth; // 深度
  int fatherId; // 是否根
  bool selected; // 是否选中

  factory TreeNodeModel.withData(Map<String, dynamic> json,
      {int depth, bool expand, int fatherId}) {
    TreeNodeModel model = TreeNodeModel.fromJson(json);
    model.depth = depth;
    model.expand = expand;
    model.fatherId = fatherId;
    model.selected = false;
    return model;
  }

  factory TreeNodeModel.fromJson(Map<String, dynamic> json) => TreeNodeModel(
        id: json["id"],
        //createDate: json["createDate"]??DateTime.parse(json["createDate"]),
        code: json["code"],
        name: json["name"],
        fullName: json["fullName"],
        parentId: json["parentId"],
        cellType: json["cellType"],
        cellCode: json["cellCode"],
        warehouseId: json["warehouseId"],
        remark: json["remark"],
        absolutePosition: json['absolutePosition'],
        children: json["children"] == null
            ? null
            : (json["children"].toString() == '[]'
                ? null
                : List<TreeNodeModel>.from(
                    json["children"].map((x) => TreeNodeModel.fromJson(x)))),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        //"createDate": createDate.toIso8601String(),
        "code": code,
        "name": name,
        "fullName": fullName,
        "parentId": parentId,
        "cellType": cellType,
        "cellCode": cellCode,
        "warehouseId": warehouseId,
        "remark": remark,
        "children": children == null
            ? null
            : List<dynamic>.from(children.map((x) => x.toJson())),
      };
}
