class BasicBean {
  String id;
  String createDate;
  String name;
  String carNum;
  String equipmentId;
  dynamic carState;
  String brand;
  dynamic remark;
  String standard;
  String chassisBrand;
  String manufacturerId;
  String chassisCountry;
  String country;
  bool isImport;
  dynamic qrCode;
  dynamic maintenanceCycle;
  bool cccAuth;
  dynamic creatorId;
  dynamic orgCode;
  dynamic companyName;
  dynamic departmentOrgcode;
  dynamic departmentName;
  List<Img> img;
  // List<Video> video;
  // List<Certification> certification;
  List<Instruction> instruction;
  Equipment equipment;
  dynamic manufacturerName;
  String countryName;
  String chassisCountryName;
  ManufacturerInfo manufacturerInfo;
  List<CarPropertyList> carPropertyList;
  List<Journals> journals;
  List<EquipmentsOnCar> equipmentsOnCar;
  EquipmentBase equipmentBase;
  List<CarPropertyList> perfQuotaS;
  List<Instruction> excel;

  BasicBean(
      {this.perfQuotaS,
      this.equipmentBase,
      this.excel,
      this.id,
      this.createDate,
      this.name,
      this.carNum,
      this.equipmentId,
      this.carState,
      this.brand,
      this.remark,
      this.standard,
      this.chassisBrand,
      this.manufacturerId,
      this.chassisCountry,
      this.country,
      this.isImport,
      this.qrCode,
      this.maintenanceCycle,
      this.cccAuth,
      this.creatorId,
      this.orgCode,
      this.companyName,
      this.departmentOrgcode,
      this.departmentName,
      this.img,
      // this.video,
      // this.certification,
      this.instruction,
      this.equipment,
      this.manufacturerName,
      this.countryName,
      this.chassisCountryName,
      this.manufacturerInfo,
      this.carPropertyList,
      this.journals,
      this.equipmentsOnCar});

  BasicBean.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    createDate = json['createDate'];
    name = json['name'];
    carNum = json['carNum'];
    equipmentId = json['equipmentId'];
    carState = json['carState'];
    brand = json['brand'];
    remark = json['remark'];
    standard = json['standard'];
    chassisBrand = json['chassisBrand'];
    manufacturerId = json['manufacturerId'];
    chassisCountry = json['chassisCountry'];
    country = json['country'];
    isImport = json['isImport'];
    qrCode = json['qrCode'];
    maintenanceCycle = json['maintenanceCycle'];
    cccAuth = json['cccAuth'];
    creatorId = json['creatorId'];
    orgCode = json['orgCode'];
    companyName = json['companyName'];
    departmentOrgcode = json['departmentOrgcode'];
    departmentName = json['departmentName'];
    if (json['img'] != null) {
      img = new List<Img>();
      json['img'].forEach((v) {
        img.add(new Img.fromJson(v));
      });
    }
    // if (json['video'] != null) {
    // video = new List<Video>();
    // json['video'].forEach((v) {
    // video.add(new Video.fromJson(v));
    // });
    // }
    // if (json['certification'] != null) {
    // certification = new List<Certification>();
    // json['certification'].forEach((v) {
    // certification.add(new Certification.fromJson(v));
    // });
    // }
    if (json['instruction'] != null) {
      instruction = new List<Instruction>();
      json['instruction'].forEach((v) {
        instruction.add(new Instruction.fromJson(v));
      });
    }
    equipment = json['equipment'] != null
        ? new Equipment.fromJson(json['equipment'])
        : null;
    manufacturerName = json['manufacturerName'];
    countryName = json['countryName'];
    chassisCountryName = json['chassisCountryName'];
    manufacturerInfo = json['manufacturerInfo'] != null
        ? new ManufacturerInfo.fromJson(json['manufacturerInfo'])
        : null;
    if (json['carPropertyList'] != null) {
      carPropertyList = new List<CarPropertyList>();
      json['carPropertyList'].forEach((v) {
        carPropertyList.add(new CarPropertyList.fromJson(v));
      });
    }
    if (json['perfQuotaS'] != null) {
      perfQuotaS = new List<CarPropertyList>();
      json['perfQuotaS'].forEach((v) {
        perfQuotaS.add(new CarPropertyList.fromJson(v));
      });
    }
    if (json['journals'] != null) {
      journals = new List<Journals>();
      json['journals'].forEach((v) {
        journals.add(new Journals.fromJson(v));
      });
    }
    if (json['equipmentsOnCar'] != null) {
      equipmentsOnCar = new List<EquipmentsOnCar>();
      json['equipmentsOnCar'].forEach((v) {
        equipmentsOnCar.add(new EquipmentsOnCar.fromJson(v));
      });
    }
    if (json['excel'] != null) {
      excel = new List<Instruction>();
      json['excel'].forEach((v) {
        excel.add(new Instruction.fromJson(v));
      });
    }
    equipmentBase = json['equipmentBase'] != null
        ? new EquipmentBase.fromJson(json['equipmentBase'])
        : null;
  }
}

class EquipmentBase {
  String standard;
  dynamic country;
  dynamic maintenanceCycle;
  dynamic manufacturerName;
  String brand;
  String categoryName;
  dynamic description;
  dynamic createTime;
  String manufacturerId;
  List<dynamic> img;
  String equipName;
  dynamic equipCode;
  String expiryDate;
  String qrCode;
  String alarmTime;
  String alarmType;
  String status;
  EquipmentBase(
      {this.equipName,
      this.equipCode,
      this.expiryDate,
      this.standard,
      this.country,
      this.maintenanceCycle,
      this.manufacturerName,
      this.brand,
      this.categoryName,
      this.description,
      this.createTime,
      this.manufacturerId,
      this.qrCode,
      this.alarmTime,
      this.alarmType,
      this.status,
      this.img});

  EquipmentBase.fromJson(Map<String, dynamic> json) {
    standard = json['standard'];
    country = json['country'];
    maintenanceCycle = json['maintenanceCycle'];
    manufacturerName = json['manufacturerName'];
    brand = json['brand'];
    categoryName = json['categoryName'];
    description = json['description'];
    createTime = json['createTime'];
    manufacturerId = json['manufacturerId'];
    equipName = json['equipName'];
    equipCode = json['equipCode'];
    qrCode = json['qrCode'];
    alarmTime = json['alarmTime'];
    alarmType = json['alarmType'];
    status = json['status'] == '1' ? '异常' : '正常';
    expiryDate = json['expiryDate'];
    if (json['img'] != null) {
      img = new List<dynamic>();
      json['img'].forEach((v) {
        img.add(new Img.fromJson(v));
      });
    }
  }
}

class Img {
  String id;
  String createDate;
  String url;
  String name;
  String size;
  String fileType;
  String objectType;
  String objectId;
  String userId;
  String companyName;
  String orgCode;
  String departmentName;
  String departmentOrgcode;

  Img(
      {this.id,
      this.createDate,
      this.url,
      this.name,
      this.size,
      this.fileType,
      this.objectType,
      this.objectId,
      this.userId,
      this.companyName,
      this.orgCode,
      this.departmentName,
      this.departmentOrgcode});

  Img.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    createDate = json['createDate'];
    url = json['url'];
    name = json['name'];
    size = json['size'];
    fileType = json['fileType'];
    objectType = json['objectType'];
    objectId = json['objectId'];
    userId = json['userId'];
    companyName = json['companyName'];
    orgCode = json['orgCode'];
    departmentName = json['departmentName'];
    departmentOrgcode = json['departmentOrgcode'];
  }
}

class Equipment {
  String id;
  dynamic createDate;
  String name;
  String code;
  String categoryId;
  dynamic country;
  dynamic maintenanceCycle;
  dynamic checkCycle;
  dynamic remark;
  dynamic managementStyle;
  dynamic reviserId;
  dynamic dateUpdated;
  dynamic createrId;
  String unitId;
  dynamic unit;
  dynamic madeIn;
  dynamic manufacturer;
  String img;
  dynamic video;
  dynamic markSpecification;
  dynamic supplierId;
  dynamic prefQuota;
  EquipmentCategory equipmentCategory;
  dynamic equPropertyList;

  Equipment(
      {this.id,
      this.createDate,
      this.name,
      this.code,
      this.categoryId,
      this.country,
      this.maintenanceCycle,
      this.checkCycle,
      this.remark,
      this.managementStyle,
      this.reviserId,
      this.dateUpdated,
      this.createrId,
      this.unitId,
      this.unit,
      this.madeIn,
      this.manufacturer,
      this.img,
      this.video,
      this.markSpecification,
      this.supplierId,
      this.prefQuota,
      this.equipmentCategory,
      this.equPropertyList});

  Equipment.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    createDate = json['createDate'];
    name = json['name'];
    code = json['code'];
    categoryId = json['categoryId'];
    country = json['country'];
    maintenanceCycle = json['maintenanceCycle'];
    checkCycle = json['checkCycle'];
    remark = json['remark'];
    managementStyle = json['managementStyle'];
    reviserId = json['reviserId'];
    dateUpdated = json['dateUpdated'];
    createrId = json['createrId'];
    unitId = json['unitId'];
    unit = json['unit'];
    madeIn = json['madeIn'];
    manufacturer = json['manufacturer'];
    img = json['img'];
    video = json['video'];
    markSpecification = json['markSpecification'];
    supplierId = json['supplierId'];
    prefQuota = json['prefQuota'];
    equipmentCategory = json['equipmentCategory'] != null
        ? new EquipmentCategory.fromJson(json['equipmentCategory'])
        : null;
    equPropertyList = json['equPropertyList'];
  }
}

class Instruction {
  String id;
  String createDate;
  dynamic extName;
  String url;
  String name;
  String size;
  String fileType;
  String objectType;
  String objectId;
  String userId;
  String companyName;
  String orgCode;
  String departmentName;
  String departmentOrgcode;

  Instruction(
      {this.id,
      this.createDate,
      this.extName,
      this.url,
      this.name,
      this.size,
      this.fileType,
      this.objectType,
      this.objectId,
      this.userId,
      this.companyName,
      this.orgCode,
      this.departmentName,
      this.departmentOrgcode});

  Instruction.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    createDate = json['createDate'];
    extName = json['extName'];
    url = json['url'];
    name = json['name'];
    size = json['size'];
    fileType = json['fileType'];
    objectType = json['objectType'];
    objectId = json['objectId'];
    userId = json['userId'];
    companyName = json['companyName'];
    orgCode = json['orgCode'];
    departmentName = json['departmentName'];
    departmentOrgcode = json['departmentOrgcode'];
  }
}

class EquipmentCategory {
  String id;
  String createDate;
  String parentId;
  String code;
  String name;
  bool isConsumptive;
  dynamic description;
  String remark;
  dynamic level;
  dynamic count;
  bool hasLowerClassification;
  List<Null> children;

  EquipmentCategory(
      {this.id,
      this.createDate,
      this.parentId,
      this.code,
      this.name,
      this.isConsumptive,
      this.description,
      this.remark,
      this.level,
      this.count,
      this.hasLowerClassification,
      this.children});

  EquipmentCategory.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    createDate = json['createDate'];
    parentId = json['parentId'];
    code = json['code'];
    name = json['name'];
    isConsumptive = json['isConsumptive'];
    description = json['description'];
    remark = json['remark'];
    level = json['level'];
    count = json['count'];
    hasLowerClassification = json['hasLowerClassification'];
    // if (json['children'] != null) {
    // children = new List<Null>();
    // json['children'].forEach((v) {
    // children.add(new Null.fromJson(v));
    // });
    // }
  }
}

class ManufacturerInfo {
  String id;
  String createDate;
  String name;
  dynamic address;
  String remark;
  dynamic contactNumber;
  dynamic maintenanceservices;
  String oldName;
  String legalRep;
  String salesTel;
  String serviceTel;
  String technicalStandard;
  var number;
  var technicianNumber;
  var fixedAssets;
  String testingEquipment;
  String qualifications;
  String historicalEvolution;
  String researchRecord;
  String productType;
  String img;
  var registeredCapital;
  dynamic natureId;
  dynamic typeId;
  dynamic countryId;
  dynamic provinceId;
  dynamic country;
  dynamic nature;
  dynamic province;
  dynamic type;

  ManufacturerInfo(
      {this.id,
      this.createDate,
      this.name,
      this.address,
      this.remark,
      this.contactNumber,
      this.maintenanceservices,
      this.oldName,
      this.legalRep,
      this.salesTel,
      this.serviceTel,
      this.technicalStandard,
      this.number,
      this.technicianNumber,
      this.fixedAssets,
      this.testingEquipment,
      this.qualifications,
      this.historicalEvolution,
      this.researchRecord,
      this.productType,
      this.img,
      this.registeredCapital,
      this.natureId,
      this.typeId,
      this.countryId,
      this.provinceId,
      this.country,
      this.nature,
      this.province,
      this.type});

  ManufacturerInfo.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    createDate = json['createDate'];
    name = json['name'];
    address = json['address'];
    remark = json['remark'];
    contactNumber = json['contactNumber'];
    maintenanceservices = json['maintenanceservices'];
    oldName = json['oldName'];
    legalRep = json['legalRep'];
    salesTel = json['salesTel'];
    serviceTel = json['serviceTel'];
    technicalStandard = json['technicalStandard'];
    number = json['number'];
    technicianNumber = json['technicianNumber'];
    fixedAssets = json['fixedAssets'];
    testingEquipment = json['testingEquipment'];
    qualifications = json['qualifications'];
    historicalEvolution = json['historicalEvolution'];
    researchRecord = json['researchRecord'];
    productType = json['productType'];
    img = json['img'];
    registeredCapital = json['registeredCapital'];
    natureId = json['natureId'];
    typeId = json['typeId'];
    countryId = json['countryId'];
    provinceId = json['provinceId'];
    country = json['country'];
    nature = json['nature'];
    province = json['province'];
    type = json['type'];
  }
}

class CarPropertyList {
  String id;
  String createDate;
  String unitId;
  String carId;
  String perfQuotaId;
  dynamic value;
  dynamic symbol;
  dynamic remark;
  String unitName;
  String perfQuotaName;
  String groupName;

  CarPropertyList(
      {this.id,
      this.createDate,
      this.unitId,
      this.carId,
      this.perfQuotaId,
      this.value,
      this.symbol,
      this.remark,
      this.unitName,
      this.perfQuotaName,
      this.groupName});

  CarPropertyList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    createDate = json['createDate'];
    unitId = json['unitId'];
    carId = json['carId'];
    perfQuotaId = json['perfQuotaId'];
    value = json['value'];
    symbol = json['symbol'];
    remark = json['remark'];
    unitName = json['unitName'];
    perfQuotaName = json['perfQuotaName'];
    groupName = json['groupName'];
  }
}

class Journals {
  String id;
  String createDate;
  dynamic equipmentDetailId;
  dynamic warehouseStructureId;
  String state;
  var amount;
  String remark;
  String stockDetailId;
  String carId;
  String userId;
  String userName;
  String companyName;
  String orgCode;
  String departmentName;
  String departmentOrgcode;

  Journals(
      {this.id,
      this.createDate,
      this.equipmentDetailId,
      this.warehouseStructureId,
      this.state,
      this.amount,
      this.remark,
      this.stockDetailId,
      this.carId,
      this.userId,
      this.userName,
      this.companyName,
      this.orgCode,
      this.departmentName,
      this.departmentOrgcode});

  Journals.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    createDate = json['createDate'];
    equipmentDetailId = json['equipmentDetailId'];
    warehouseStructureId = json['warehouseStructureId'];
    state = json['state'];
    amount = json['amount'];
    remark = json['remark'];
    stockDetailId = json['stockDetailId'];
    carId = json['carId'];
    userId = json['userId'];
    userName = json['userName'];
    companyName = json['companyName'];
    orgCode = json['orgCode'];
    departmentName = json['departmentName'];
    departmentOrgcode = json['departmentOrgcode'];
  }
}

class EquipmentsOnCar {
  String maintenanceCycle;
  String equipmentBrand;
  String equipmentStandard;
  String equipmentName;
  dynamic equipmentCode;
  String equipmentId;

  EquipmentsOnCar(
      {this.maintenanceCycle,
      this.equipmentBrand,
      this.equipmentStandard,
      this.equipmentName,
      this.equipmentCode,
      this.equipmentId});

  EquipmentsOnCar.fromJson(Map<String, dynamic> json) {
    maintenanceCycle = json['maintenanceCycle'];
    equipmentBrand = json['equipmentBrand'];
    equipmentStandard = json['equipmentStandard'];
    equipmentName = json['equipmentName'];
    equipmentCode = json['equipmentCode'];
    equipmentId = json['equipmentId'];
  }
}
