import 'package:base/consts/color.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:amos_flutter_utils/amos_flutter_utils.dart';

import 'package:base/model/route_model.dart';
import 'package:base/widgets/back_button.dart';
import 'equip_car_extinguish_detail_baseinfo.dart';
import 'equip_car_extinguish_detail_performance.dart';

GlobalKey<_EquipmentDetailContentState> childKey = GlobalKey();

// 装备信息详情
// 车辆详情
// 灭火药剂详情
class EquipmentCarExtinguishDetail extends StatelessWidget {
  final RouteModel routeModel;
  EquipmentCarExtinguishDetail({@required this.routeModel});

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text(
          routeModel.title ?? "",
          style: Theme.of(context).textTheme.headline2,
        ),
        centerTitle: true,
        elevation: 0,
        leading: LeadingButton(
          theme: childKey.currentState.theme,
        ),
      ),
      body: EquipmentDetailContent(routeModel),
    );
  }
}

// 需要显示的tab子项集合
final tabs = <Tab>[
  Tab(
    text: "基本信息",
  ),
  Tab(
    text: "性能参数",
  ),
];

class EquipmentDetailContent extends StatefulWidget {
  final RouteModel routeModel;
  EquipmentDetailContent(this.routeModel);

  @override
  _EquipmentDetailContentState createState() => _EquipmentDetailContentState();
}

class _EquipmentDetailContentState extends State<EquipmentDetailContent>
    with SingleTickerProviderStateMixin {
  TabController _tabController;

  @override
  void initState() {
    super.initState();
    _tabController = TabController(length: tabs.length, vsync: this);
    _tabController
        .addListener(() => print("当前点击的是第${_tabController.index}个tab"));
    initThemeConfig();
  }

  String theme = '';
  initThemeConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        this.theme =
            preferences.getString("theme") ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Color(0xFFEFEFEF),
      appBar: AppBar(
        elevation: 0,
        bottom: PreferredSize(
          preferredSize: Size.zero,
          child: Material(
            color: Colors.white,
            child: TabBar(
              indicatorWeight: 2.px,
              indicatorSize: TabBarIndicatorSize.label,
              indicatorColor: GetConfig.getColor(theme),
              unselectedLabelColor: Colors.black,
              labelColor: GetConfig.getColor(theme),
              labelStyle: Theme.of(context).textTheme.bodyText1,
              labelPadding: EdgeInsets.zero,
              controller: _tabController,
              tabs: tabs,
            ),
          ),
        ),
      ),
      body: TabBarView(
        controller: _tabController,
        children: [
          EquipmentCarExtinguishDetailBaseInfo(widget.routeModel),
          EquipmentCarExtinguishDetailPerformance()
        ],
      ),
    );
  }
}
