import 'package:base/consts/color.dart';
import 'package:flutter/material.dart';

import 'package:shared_preferences/shared_preferences.dart';

import 'package:base/widgets/back_button.dart';

GlobalKey<_VehicleLoadedContentState> childKey = GlobalKey();

class VehicleResume extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text(
          "电子履历",
          style: TextStyle(color: Colors.black),
        ),
        centerTitle: true,
        leading: LeadingButton(
          theme: childKey.currentState.theme,
        ),
      ),
      body: VehicleResumeContent(),
    );
  }
}

class VehicleResumeContent extends StatefulWidget {
  @override
  _VehicleLoadedContentState createState() => _VehicleLoadedContentState();
}

class _VehicleLoadedContentState extends State<VehicleResumeContent> {
  String theme = '';

  initThemeConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        this.theme =
            preferences.getString("theme") ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    initThemeConfig();
  }

  @override
  Widget build(BuildContext context) {
    return Container();
  }
}
