import 'package:flutter/material.dart';
import '../../model/vehicle_basic_model.dart';

class EquipmentPage extends StatefulWidget {
  //车载装备
  BasicBean baseBean;

  EquipmentPage(this.baseBean);

  @override
  _EquipmentState createState() {
    return _EquipmentState();
  }
}

class _EquipmentState extends State<EquipmentPage> {
  List<EquipmentsOnCar> basicList = [];

  @override
  void initState() {
    basicList = widget.baseBean.equipmentsOnCar;
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    // TODO: implement build
    return Material(
        color: Colors.black12,
        child: SingleChildScrollView(
          padding: EdgeInsets.only(left: 10, right: 10, top: 15, bottom: 40),
          child: ListView.builder(
              physics: const NeverScrollableScrollPhysics(),
              key: PageStorageKey('data'),
              itemCount: basicList.length,
              shrinkWrap: true,
              itemBuilder: (BuildContext context, int index) =>
                  ListItemView(index, basicList[index])),
        ));
  }
}

class ListItemView extends StatelessWidget {
  ListItemView(this.row, this.bean, {Key key}) : super(key: key);
  int row;
  EquipmentsOnCar bean;

  //EmergencyBean bean;
  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(top: 10, bottom: 10),
      //边框
      decoration: new BoxDecoration(
        //背景
        color: Colors.white,
        //设置四周圆角 角度
        borderRadius: BorderRadius.all(Radius.circular(0.0)),
        //设置四周边框
        border: new Border.all(width: 2, color: Colors.black26),
      ),
      child: Column(
        children: [
          Container(
              alignment: Alignment.centerLeft,
              height: 40,
              color: Color(0xff00ccff),
              padding: EdgeInsets.only(left: 5, right: 5),
              child: Row(
                children: [
                  Text(
                    (row + 1).toString() + '、' + '装备名称：',
                    style: TextStyle(fontSize: 12, color: Color(0xff666666)),
                    textAlign: TextAlign.left,
                  ),
                  Text(
                    bean.equipmentName == null ? "" : bean.equipmentName,
                    style: TextStyle(fontSize: 12, color: Color(0xff333333)),
                    textAlign: TextAlign.left,
                  )
                ],
              )),
          Container(
              padding: EdgeInsets.only(left: 5, right: 5),
              alignment: Alignment.centerLeft,
              height: 40,
              color: Colors.white,
              child: Row(
                children: [
                  Text(
                    '识别码：',
                    style: TextStyle(fontSize: 12, color: Color(0xff666666)),
                    textAlign: TextAlign.left,
                  ),
                  Text(
                    bean.equipmentCode == null
                        ? ""
                        : bean.equipmentCode.toString(),
                    style: TextStyle(fontSize: 12, color: Color(0xff333333)),
                    textAlign: TextAlign.left,
                  )
                ],
              )),
          Container(
              padding: EdgeInsets.only(left: 5, right: 5),
              alignment: Alignment.centerLeft,
              height: 40,
              color: Color(0xffefeff4),
              child: Row(
                children: [
                  Text(
                    '规格型号：',
                    style: TextStyle(fontSize: 12, color: Color(0xff666666)),
                    textAlign: TextAlign.left,
                  ),
                  Text(
                    bean.equipmentStandard == null
                        ? ""
                        : bean.equipmentStandard,
                    style: TextStyle(fontSize: 12, color: Color(0xff333333)),
                    textAlign: TextAlign.left,
                  )
                ],
              )),
          Container(
              padding: EdgeInsets.only(left: 5, right: 5),
              alignment: Alignment.centerLeft,
              height: 40,
              color: Colors.white,
              child: Row(
                children: [
                  Text(
                    '品牌：',
                    style: TextStyle(fontSize: 12, color: Color(0xff666666)),
                    textAlign: TextAlign.left,
                  ),
                  Text(
                    bean.equipmentBrand == null ? "" : bean.equipmentBrand,
                    style: TextStyle(fontSize: 12, color: Color(0xff333333)),
                    textAlign: TextAlign.left,
                  )
                ],
              )),
          Container(
              padding: EdgeInsets.only(left: 5, right: 5),
              alignment: Alignment.centerLeft,
              height: 40,
              color: Color(0xffefeff4),
              child: Row(
                children: [
                  Text(
                    '保养周期：',
                    style: TextStyle(fontSize: 12, color: Color(0xff666666)),
                    textAlign: TextAlign.left,
                  ),
                  Text(
                    bean.maintenanceCycle == null
                        ? ""
                        : bean.maintenanceCycle + '月',
                    style: TextStyle(fontSize: 12, color: Color(0xff333333)),
                    textAlign: TextAlign.left,
                  )
                ],
              )),
        ],
      ),
    );
  }
}
