import 'package:flutter/material.dart';
import '../../model/vehicle_basic_model.dart';

class ResumePage extends StatefulWidget {
  BasicBean baseBean;
//电子履历
  ResumePage(this.baseBean);

  @override
  _ResumePageState createState() {
    return _ResumePageState();
  }
}

class _ResumePageState extends State<ResumePage> {
  List<Journals> basicList = [];

  @override
  void initState() {
    basicList = widget.baseBean.journals;
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Material(
        color: Color(0xfff5f5f5),
        child: SingleChildScrollView(
          padding: EdgeInsets.only(left: 10, right: 10, top: 15, bottom: 40),
          child: ListView.builder(
              physics: const NeverScrollableScrollPhysics(),
              key: PageStorageKey('data'),
              itemCount: basicList.length,
              shrinkWrap: true,
              itemBuilder: (BuildContext context, int index) =>
                  ListItemView(index, basicList[index])),
        ));
  }
}

class ListItemView extends StatelessWidget {
  ListItemView(this.row, this.bean, {Key key}) : super(key: key);
  int row;
  Journals bean;

  @override
  Widget build(BuildContext context) {
    return Container(
      alignment: Alignment.centerLeft,
      // width: ScreenUtil.screenWidth - 48.getWidth(),
      //height: 40,
      padding: EdgeInsets.all(5),
      color: row % 2 == 0 ? Colors.white : Color(0xffefeff4),
      child: Text(
        (bean.createDate == null ? '' : bean.createDate) +
            '  ' +
            (bean.remark == null ? '' : bean.remark),
        style: TextStyle(fontSize: 12, color: Color(0xff333333)),
        textAlign: TextAlign.left,
      ),

      // height:  getStringHeight(txtKey),
    );
  }
}
