import 'package:flutter/material.dart';
import '../../model/vehicle_basic_model.dart';

class SpecificaPage extends StatefulWidget {
  BasicBean baseBean;
  final String type; //1为装备 3为车辆
//详细参数
  SpecificaPage(this.baseBean, this.type);

  @override
  _SpecificaPageState createState() {
    return _SpecificaPageState();
  }
}

class _SpecificaPageState extends State<SpecificaPage> {
  List<CarPropertyList> basicList = [];

  @override
  void initState() {
    basicList = widget.type == '3'
        ? widget.baseBean.carPropertyList
        : widget.baseBean.perfQuotaS;

    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Material(
        color: Color(0xfff5f5f5),
        child: SingleChildScrollView(
          //height: 40.0*basicList.length+380,
          padding: EdgeInsets.only(left: 10, right: 10, top: 15, bottom: 40),
          //color: ZHColors.headF5F5F5,
          child: basicList == null
              ? Container()
              : ListView.builder(
                  padding: EdgeInsets.only(left: 5, right: 5),
                  physics: const NeverScrollableScrollPhysics(),
                  key: PageStorageKey('data'),
                  itemCount: basicList.length,
                  shrinkWrap: true,
                  itemBuilder: (BuildContext context, int index) =>
                      ListItemView(index, basicList[index])),
        ));
  }
}

class ListItemView extends StatelessWidget {
  ListItemView(this.row, this.bean, {Key key}) : super(key: key);
  int row;
  CarPropertyList bean;

  @override
  Widget build(BuildContext context) {
    return Container(
        alignment: Alignment.centerLeft,
        padding: EdgeInsets.all(10),
        color: row % 2 == 0 ? Colors.white : Color(0xffefeff4),
        child: Row(
          children: [
            Text(
              bean.perfQuotaName == null ? '' : bean.perfQuotaName + ' :  ',
              style: TextStyle(fontSize: 12, color: Color(0xff666666)),
              textAlign: TextAlign.left,
            ),
            Expanded(
                child: Text(
              bean.value == null
                  ? ' '
                  : (bean.value.toString() +
                      ' ' +
                      (bean.unitName == null ? ' ' : bean.unitName)),
              style: TextStyle(fontSize: 12, color: Color(0xff333333)),
              textAlign: TextAlign.left,
              maxLines: 200,
              overflow: TextOverflow.ellipsis,
            )),
          ],
        )

        // height:  getStringHeight(txtKey),
        );
  }
}
