import 'package:fluro/fluro.dart';

import 'route_handler.dart';

mixin Routes {
  ///离线模式
  static String offlineEquipWareHousing = '/offlineEquipWareHousing';
  static String offlineEquipmentAddList = '/offlineEquipmentAddList';
  static String offlineFireAgentInStock = '/offlineFireAgentInStock';
  static String offlineAddFireAgentConfirm = '/offlineAddFireAgentConfirm';
  static String offlineScrapPostBill = '/offlineScrapPostBill';
  static String offlineSubmitSuccess = '/offlineSubmitSuccess';
  static String offlineCommonAddFireAgent = '/offlineCommonAddFireAgent';
  static String offlineCreateScrap = '/offlineCreateScrap';

  static void configureRoutes(FluroRouter router) {
    router.define(offlineEquipWareHousing,
        handler: offlineEquipWareHousingHandler);
    router.define(offlineEquipmentAddList,
        handler: OfflineEquipmentAddListHandler);
    router.define(offlineFireAgentInStock,
        handler: offlineFireAgentInStockHandler);
    router.define(offlineAddFireAgentConfirm,
        handler: offlineAddFireAgentConfirmHandler);
    router.define(offlineScrapPostBill, handler: offlineScrapPostBillHandler);
    router.define(offlineSubmitSuccess, handler: offlineSubmitSuccessHandler);
    router.define(offlineCommonAddFireAgent,
        handler: offlineCommonAddFireAgentHandler);
    router.define(offlineCreateScrap, handler: offlineCreateScrapHandler);
  }
}
