import 'package:amos_flutter_utils/amos_flutter_utils.dart';

import 'package:base/consts/color.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:flutter/material.dart';
import 'package:safe_control/model/plan_inspection/check_point_detail.dart';
import 'package:safe_control/view/CheckExecute/checkexec_item_content.dart';
import 'package:safe_control/view/task_addition/task_addition_screen.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../model/offline_plan_list_output.dart';

class CheckExecListContent extends StatefulWidget {
  final Point point;

  const CheckExecListContent(this.point);

  @override
  State<StatefulWidget> createState() {
    return _CheckExecListContent();
  }
}

class _CheckExecListContent extends State<CheckExecListContent> {
  CheckPointDetail _checkPointDetail;

  @override
  Widget build(BuildContext context) {
    if (_checkPointDetail == null) {
      return Scaffold(
        appBar: AppBar(
          title: const Text(
            '巡检点详情',
            style: TextStyle(color: Colors.black, fontSize: 19),
          ),
          centerTitle: true,
          elevation: 0.2,
          brightness: Brightness.light,
          backgroundColor: KColorConstant.topBarColor,
          leading: Container(
            child: GestureDetector(
              onTap: () => Navigator.pop(context),
              child: Icon(Icons.keyboard_arrow_left, color: GetConfig.getColor(theme), size: 32),
            ),
          ),
        ),
      );
    }

    return Scaffold(
        appBar: AppBar(
          title: Text(
            _checkPointDetail.pointName ?? '计划外',
            style: const TextStyle(color: Colors.black, fontSize: 19),
          ),
          centerTitle: true,
          elevation: 0.2,
          brightness: Brightness.light,
          backgroundColor: KColorConstant.topBarColor,
          leading: Container(
            child: GestureDetector(
              onTap: () => Navigator.pop(context),
              child: Icon(Icons.keyboard_arrow_left, color: GetConfig.getColor(theme), size: 32),
            ),
          ),
          actions: <Widget>[
            _checkPointDetail.pointStatus == '2'
                ? IconButton(
                    icon: const Icon(Icons.note_add),
                    tooltip: '添加任务',
                    onPressed: () {
                      Navigator.push(
                          context,
                          MaterialPageRoute(
                              builder: (context) => TaskAdditionScreen(checkId: _checkPointDetail.checkId)));
                    },
                    color: Colors.red,
                  )
                : Container(),
          ],
        ),
        body: SingleChildScrollView(
          child: Column(
            children: <Widget>[
              Row(
                children: <Widget>[
                  Container(
                    padding: const EdgeInsets.only(left: 20, top: 10),
                    width: 150,
                    height: 40,
                    child: const Text(
                      '点编号',
                      style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                    ),
                  ),
                  Text(_checkPointDetail.pointNo ?? ''),
                ],
              ),
              Divider(),
              Row(
                children: <Widget>[
                  Container(
                    padding: const EdgeInsets.only(left: 20, top: 10),
                    width: 150,
                    height: 40,
                    child: const Text(
                      '巡检计划',
                      style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                    ),
                  ),
                  Text(_checkPointDetail.planName ?? '计划外'),
                ],
              ),
              const Divider(),
              Row(
                children: <Widget>[
                  Container(
                    padding: const EdgeInsets.only(left: 20, top: 10),
                    width: 150,
                    height: 40,
                    child: const Text(
                      '执行时间',
                      style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                    ),
                  ),
                  Text(DateUtils.timestampToDate(_checkPointDetail.checkTime ?? 0)),
                ],
              ),
              const Divider(),
              Row(
                children: <Widget>[
                  Container(
                    padding: const EdgeInsets.only(left: 20, top: 10),
                    width: 150,
                    height: 40,
                    child: const Text(
                      '执行部门',
                      style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                    ),
                  ),
                  Text(_checkPointDetail.departmentName ?? ''),
                ],
              ),
              const Divider(),
              Row(
                children: <Widget>[
                  Container(
                    padding: const EdgeInsets.only(left: 20, top: 10),
                    width: 150,
                    height: 40,
                    child: const Text(
                      '执行人',
                      style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                    ),
                  ),
                  Text(_checkPointDetail.username ?? ''),
                ],
              ),
              const Divider(),
              Row(
                children: <Widget>[
                  Container(
                    padding: const EdgeInsets.only(left: 20, top: 10),
                    width: 150,
                    height: 40,
                    child: const Text(
                      '点状态',
                      style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                    ),
                  ),
                  Text(
                    getPointStatus(_checkPointDetail.pointStatus),
                    style: TextStyle(color: getPointColor(_checkPointDetail.pointStatus)),
                  ),
                ],
              ),
              Container(
                color: Colors.grey[100],
                height: 10,
              ),
              Container(
                padding: const EdgeInsets.only(left: 20, top: 10),
                height: 40,
                child: const Text(
                  '检查项目',
                  style: TextStyle(fontWeight: FontWeight.w500, fontSize: 18),
                ),
                alignment: Alignment.centerLeft,
              ),
              const Divider(
                height: 1,
              ),
              const Padding(
                padding: EdgeInsets.only(top: 10),
              ),
              Row(
                children: <Widget>[
                  Container(
                    padding: const EdgeInsets.only(left: 20, top: 15, right: 10),
                    width: 120,
                    height: 50,
                    child: const Text(
                      '关联检查项',
                      style: TextStyle(fontWeight: FontWeight.w500, fontSize: 16),
                    ),
                  ),
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: _checkPointDetail.checkInputs.keys.map((f) {
                      GestureDetector(
                          child: Container(
                              width: 280,
                              child: Column(
                                children: <Widget>[
                                  Text(f),
                                  Column(
                                      children: _checkPointDetail.checkInputs[f].keys.map((t) {
                                    return Column(
                                      children: <Widget>[
                                        Text(f),
                                        Column(
                                            children: _checkPointDetail.checkInputs[f][t].map((itemData) {
                                          return Text(itemData.inputName,
                                              style: TextStyle(
                                                  color: (itemData.inputStatus == '2' ? Colors.red : Colors.black),
                                                  fontSize: 14));
                                        }).toList())
                                      ],
                                    );
                                  }).toList())
                                ],
                              )),
                          onTap: () {
                            Navigator.push(context, MaterialPageRoute(builder: (context) {
                              return CheckExecItemContent(_checkPointDetail.checkId);
                            }));
                          });
                    }).toList(),
                  )
                ],
              ),
            ],
          ),
        ));
  }

  @override
  void initState() {
    super.initState();
    getData();
    initThemeConfig();
  }

  String theme = '';

  Future<void> initThemeConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        theme = preferences.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  Future<void> getData() async {
    print('this.widget.id:$this.widget.id');
    var point = widget.point;

    _checkPointDetail = CheckPointDetail.fromParams(
        checkId: 0,
        checkTime: '',
        pointId: JunMath.parseInt(point.pointId),
        departmentName: '',
        planName: '',
        pointName: '',
        pointNo: point.pointNO,
        pointStatus: point.status,
        username: '',
        remark: '');

    _checkPointDetail.checkInputs = {};

    for (var item in point.inputItems) {
      CheckInput chkInput = CheckInput();
      chkInput.remark = ''; //item.id;
      chkInput.checkInputId = JunMath.parseInt(item.id); //item.id;
      chkInput.dataJson = ''; //item.id;
      chkInput.inputName = ''; //item.id;
      chkInput.inputStatus = ''; //item.id;
      chkInput.inputValue = //item.id;
          chkInput.isMultiline = //item.id;
              chkInput.isMust = //item.id;
                  chkInput.itemType = //item.id;
                      chkInput.orderNo = item.orderNo; //item.id;
    }
  }

  String getPointStatus(String pointStatus) {
    if (pointStatus == '0') {
      return '未开始';
    } else if (pointStatus == '1') {
      return '合格';
    } else if (pointStatus == '2') {
      return '不合格';
    } else if (pointStatus == '3') {
      return '漏检';
    } else {
      return '';
    }
  }

  Color getPointColor(String pointStatus) {
    if (pointStatus == '0') {
      return Colors.grey;
    } else if (pointStatus == '1') {
      return Colors.green;
    } else if (pointStatus == '2') {
      return Colors.red;
    } else if (pointStatus == '3') {
      return Colors.orange;
    } else {
      return Colors.white;
    }
  }
}

class JunMath {
  static int parseInt(String str) {
    try {
      if (str == null) return 0;
      if (str == 'null') return 0;
      return int.parse(str);
    } catch (e) {
      return 0;
    }
  }
}
