import 'package:amos_flutter_ui/amos_flutter_ui.dart';

import 'package:base/consts/color.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
//import 'package:flutter_qr_reader/flutter_qr_reader.dart';
import 'package:permission_handler/permission_handler.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../model/offline_plan_list_output.dart';
import '../../services/dbAccess.dart';
import '../../services/offline_plan_inspection_services.dart';
import '../../view/CheckExecute/checkexec_inspection.dart';

class QrPage extends StatefulWidget {
  final num taskId;

  const QrPage({this.taskId});

  @override
  State<StatefulWidget> createState() => _QrPageState();
}

class _QrPageState extends State<QrPage> {
  final GlobalKey qrKey = GlobalKey(debugLabel: 'QR');
  var qrText = '';
  //QrReaderViewController _controller;

//  QrCamera qrCamera;
  bool camState = false;
  int returnTimes = 0;

  //PermissionStatus _permissionStatus = PermissionStatus.unknown;
  final Permission _permission = Permission.camera;
  PermissionStatus _permissionStatus = PermissionStatus.undetermined;
  String theme = '';

  initThemeConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        theme = preferences.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  void initState() {
    super.initState();
    initThemeConfig();
    _listenForPermissionStatus();
    //requestPermission(_permission);

    if (_permissionStatus == PermissionStatus.granted) {
      setState(() {
        camState = true;
      });
    } else {
      requestPermission(_permission).then((v) {
        if (_permissionStatus == PermissionStatus.granted) {
          setState(() {
            camState = true;
          });
        } else {
          setState(() {
            camState = false;
          });
          MsgBox.showMessageOnly('请授予权限后重新操作！', context);
        }
      });
    }
  }

  void _listenForPermissionStatus() async {
    final status = await _permission.status;
    setState(() => _permissionStatus = status);
  }

  Future<void> requestPermission(Permission permission) async {
    final status = await permission.request();

    setState(() {
      print(status);
      _permissionStatus = status;
      print(_permissionStatus);
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          title: Text(
            "二维码扫描",
            style: TextStyle(color: Colors.black, fontSize: 19),
          ),
          centerTitle: true,
          elevation: 0.7,
          brightness: Brightness.light,
          backgroundColor: Colors.grey,
          leading: Container(
            child: GestureDetector(
              onTap: () {
                Navigator.pop(context);
              },
              child: Icon(Icons.keyboard_arrow_left,
                  color: GetConfig.getColor(theme), size: 32),
            ),
          ),
//        actions: <Widget>[
//          IconButton(icon:ImageIcon(AssetImage("assets/images/noplan/no_plan_torch.png"),size: 30,),
//            onPressed: (){
//            this.controller.toggleTorch();
//          },)
//        ],
        ),
        body: Column(
          children: <Widget>[
            Expanded(
              child: Stack(
                children: <Widget>[
                  camState
                      ?
                      /*    LastQrScannerPreview(
                  key: qrKey,
                  onQRViewCreated: _onQRViewCreated,
                )*/
                      /*QrReaderView(
                          width: 400,
                          height: 1000,
                          callback: (container) {
                            this._controller = container;
                            _controller.startCamera(onScan);
                          })*/
                  Container(
                    decoration: BoxDecoration(
                      color: Colors.black,
                    ),
                  )
                      : Container(
                          decoration: BoxDecoration(
                            color: Colors.black,
                          ),
                        ),
                  Container(
                      height: 40,
                      width: double.infinity,
                      margin: EdgeInsets.only(left: 60, right: 60, top: 40),
                      child: Container(
//                      padding: EdgeInsets.only(left: 40,top:10),
                        child: const Text(
                          "对准二维码",
                          style: TextStyle(fontSize: 16, color: Colors.white),
                        ),
                      ),
                      decoration: BoxDecoration(
                        color: Colors.black38,
                        borderRadius:
                            BorderRadius.all(Radius.circular(25.0)),
                      ),
                      alignment: Alignment.center),
                  GestureDetector(
                    child: Center(
                      child: Stack(
                        children: <Widget>[
                          Padding(
                            padding: EdgeInsets.only(bottom: 10),
                          ),
                          SizedBox(
                            height: 300.0,
                            width: 270.0,
                            child: Container(
                              decoration: BoxDecoration(
                                  border: Border.all(
                                      color: Colors.white, width: 1.0)),
                            ),
                          ),
                          Positioned(
                            child: Container(
                              width: 270.0,
                              height: 1,
                              color: Colors.white,
                            ),
                          )
                        ],
                      ),
                    ),
                    onTap: () {
                      //this._controller.setFlashlight();
                    },
                  ),
                ],
              ),
              flex: 4,
            ),
          ],
        ));
  }

//  void _onQRViewCreated(/*QRViewController controller*/) {
//    this.controller = controller;
//    final channel = controller.channel;
//    controller.init(qrKey);
//    channel.setMethodCallHandler((MethodCall call)  async{
//      switch (call.method) {
//        case "onRecognizeQR":
//          controller.pauseScanner();
//          scan(call.arguments.toString());
//      }
//    });
//  }

  void onScan(String v, List<Offset> offsets) {
    if (v != null && v.isNotEmpty) {
      setState(() {
        returnTimes = returnTimes + 1;
      });
      if (returnTimes == 1) {
        scan(v);
      }
      //_controller.stopCamera();
    }
  }

  scan(String code) {
    if (code.isNotEmpty) {
      getContent(code);
    } else {
      shortMessage('标签内容无法识别！').then((v) {
        /*if (this._controller != null) {
          setState(() {
            returnTimes = 0;
          });
          this._controller.startCamera(onScan);
        }*/
      });
    }
  }

  getContent(String pointNo) async {
    // 查询参数
    List<dynamic> params = List<dynamic>();
    params.add(pointNo);
    // 根据点编号查询点信息
    List<Map<String, dynamic>> points = await dbAccess()
        .queryData("select * from Point where pointNo = ?;", params);
    print(points);

    if (points.length == 0) {
      shortMessage('没有对应的巡检点！').then((v) {
        /*if (this._controller != null) {
          setState(() {
            returnTimes = 0;
          });
          this._controller.startCamera(onScan);
        }*/
      });
    } else {
      List<Point> listPoint = await getOfflinePointList(points);
      Point chkPoint = listPoint[0];

      setState(() {
        camState = false;
      });

      Navigator.push(context, MaterialPageRoute(builder: (context) {
        return CheckExecInspection(chkPoint, "QR");
      })).then((v) {
       /* if (this._controller != null) {
          setState(() {
            returnTimes = 0;
          });
          this._controller.startCamera(onScan);
        }*/
        setState(() {
          camState = true;
        });
      });
    }
  }
}
