import 'package:amos_flutter_utils/amos_flutter_utils.dart';

import 'package:base/consts/color.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:base/consts/route_category_front_component_const.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

import 'package:base/model/route_model.dart';
import 'package:base/routes/routes.dart';
import 'package:base/utils/app_theme.dart';
import 'package:base/widgets/back_button.dart';

// 提交完成后单据页面
GlobalKey<_SubmitSuccessContentState> childKey = GlobalKey();

class OfflineSubmitSuccess extends StatelessWidget {
  final RouteModel routeModel;

  OfflineSubmitSuccess({this.routeModel});

  @override
  Widget build(BuildContext context) {
    // return WillPopScope(
    //     onWillPop: () {
    //       if (routeModel.item == RouteItemFrontComponentConst.scraped) {
    //         if(routeModel.category == RouteCategoryFrontComponentConst.fireExtinguishingAgent) {
    //           Navigator.of(context).pop();
    //           Navigator.of(context).pop();
    //           Navigator.of(context).pop();
    //           Navigator.of(context).pop();
    //           Navigator.of(context).pop();
    //         }else{
    //           Navigator.of(context).pop();
    //           Navigator.of(context).pop();
    //           Navigator.of(context).pop();
    //           Navigator.of(context).pop();
    //         }
    //
    //
    //       } else {
    //         if(routeModel.category == RouteCategoryFrontComponentConst.fireExtinguishingAgent) {
    //           Navigator.of(context).pop();
    //           Navigator.of(context).pop();
    //           Navigator.of(context).pop();
    //
    //         }else {
    //           Navigator.of(context).pop();
    //           Navigator.of(context).pop();
    //
    //         }
    //       }
    //       //Navigator.of(context).popUntil((route) => route.settings.name.startsWith(Routes.main));
    //       // ignore: missing_return
    //      // Navigator.of(context).popAndPushNamed(Routes.main);
    //     },
    //   child: Scaffold(
    //   backgroundColor: AppTheme.backgroundColor,
    //   appBar: AppBar(
    //     title: Text("${routeModel.title}",style: TextStyle(color: Colors.black),),
    //     leading: LeadingButton(
    //       theme: childKey.currentState.theme,
    //       onWillScope: true,
    //
    //
    //       onWillPop: (){
    //        // Navigator.of(context).popAndPushNamed(Routes.main);
    //         //Navigator.of(context).popUntil((route) => route.settings.name.startsWith(Routes.main));
    //         if (routeModel.item == RouteItemFrontComponentConst.scraped) {
    //           if(routeModel.category == RouteCategoryFrontComponentConst.fireExtinguishingAgent) {
    //             Navigator.of(context).pop();
    //             Navigator.of(context).pop();
    //             Navigator.of(context).pop();
    //             Navigator.of(context).pop();
    //             Navigator.of(context).pop();
    //           }else{
    //             Navigator.of(context).pop();
    //             Navigator.of(context).pop();
    //             Navigator.of(context).pop();
    //             Navigator.of(context).pop();
    //           }
    //
    //
    //         }else {
    //           if(routeModel.category == RouteCategoryFrontComponentConst.fireExtinguishingAgent) {
    //             Navigator.of(context).pop();
    //             Navigator.of(context).pop();
    //             Navigator.of(context).pop();
    //
    //           }else {
    //             Navigator.of(context).pop();
    //             Navigator.of(context).pop();
    //
    //           }
    //         }
    //         //Index
    //       },
    //     ),
    //     centerTitle: true,
    //   ),
    //   body:
    return SubmitSuccessContent(
      routeModel: routeModel,
    );
    //));
  }
}

class SubmitSuccessContent extends StatefulWidget {
  final RouteModel routeModel;

  SubmitSuccessContent({this.routeModel});

  @override
  _SubmitSuccessContentState createState() => _SubmitSuccessContentState();
}

class _SubmitSuccessContentState extends State<SubmitSuccessContent> {
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    initThemeConfig();
  }

  String theme = '';

  initThemeConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        this.theme =
            preferences.getString("theme") ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
        onWillPop: () {
          goBack(context, widget.routeModel.category, widget.routeModel.item);
        },
        child: Scaffold(
            backgroundColor: AppTheme.backgroundColor,
            appBar: AppBar(
              title: Text(
                "${widget.routeModel.title}",
                style: TextStyle(color: Colors.black),
              ),
              leading: LeadingButton(
                theme: theme,
                onWillScope: true,
                onWillPop: () {
                  goBack(context, widget.routeModel.category,
                      widget.routeModel.item);
                },
              ),
              centerTitle: true,
            ),
            body: Stack(
              children: <Widget>[
                ListView(
                  padding: EdgeInsets.only(bottom: 50.px),
                  shrinkWrap: true,
                  children: <Widget>[
                    buildTopCard(context),
                    // buildContent(context)
                  ],
                ),
                buildBottom(context)
              ],
            )));
  }

  // 顶部视图
  Widget buildTopCard(context) {
    return Padding(
      padding: EdgeInsets.symmetric(horizontal: 8.px, vertical: 5.px),
      child: Column(
        children: <Widget>[
          Padding(
            padding: EdgeInsets.only(top: 30.px),
            child: Image.asset(
              "assets/images/icon_submit_sucess_" + theme + ".png",
              width: 70.px,
            ),
          ),
          Padding(
            padding: EdgeInsets.only(top: 20.px, bottom: 36.px),
            child: Text(
              "成功",
              style: Theme.of(context)
                  .textTheme
                  .headline1
                  .copyWith(color: Color(0xFF666666)),
            ),
          )
        ],
      ),
    );
  }

  // 底部
  Widget buildBottom(context) {
    return Align(
      alignment: Alignment.bottomCenter,
      child: Container(
        height: 50.px,
        width: double.infinity,
        child: RaisedButton(
          color: GetConfig.getColor(theme),
          child: Text(
            "继续",
            style: Theme.of(context).textTheme.headline2,
          ),
          onPressed: () => goBack(
              context, widget.routeModel.category, widget.routeModel.item),
        ),
      ),
    );
  }

  // 内容
  // Widget buildContent(context) {
  //   return Padding(
  //     padding: EdgeInsets.symmetric(horizontal: 8.px,vertical: 3.px),
  //     child: Card(
  //       shape: RoundedRectangleBorder(
  //           borderRadius: BorderRadius.circular(6.px)
  //       ),
  //       shadowColor: Color.fromRGBO(69, 91, 99, 0.08),
  //       elevation: 4,
  //       child: Padding(
  //         padding: EdgeInsets.symmetric(horizontal: 16.px,vertical: 9.px),
  //         child: Column(
  //           crossAxisAlignment: CrossAxisAlignment.start,
  //           children: <Widget>[
  //             Padding(
  //               padding: EdgeInsets.only(bottom: 23.px),
  //               child: Text("单据信息",style: Theme.of(context).textTheme.headline4,),
  //             ),
  //             widget.routeModel.extension["number"]!=null? Padding(
  //               padding: EdgeInsets.only(bottom: 23.px),
  //               child: Text("单据编号   ${widget.routeModel.extension["number"]}",style: Theme.of(context).textTheme.headline3,),
  //             ):Container(),
  //             Padding(
  //               padding: EdgeInsets.only(bottom: 23.px),
  //               child: Text("创建时间   ${widget.routeModel.extension["time"]}",style: Theme.of(context).textTheme.headline3,),
  //             ),
  //             Padding(
  //               padding: EdgeInsets.only(bottom: 5.px),
  //               child: Text("经办人   ${widget.routeModel.extension["person"]}",style: Theme.of(context).textTheme.headline3,),
  //             )
  //           ],
  //         ),
  //       ),
  //     ),
  //   );
  // }

  // 继续
  void goBack(context, category, item) {
    if (item == RouteItemFrontComponentConst.scraped) {
      Navigator.of(context)
          .popUntil((route) => route.settings.name.startsWith(Routes.main));
    } else if (category ==
            RouteCategoryFrontComponentConst.fireExtinguishingAgent &&
        item == RouteItemFrontComponentConst.inStock) {
      Navigator.of(context)
          .popUntil((route) => route.settings.name.startsWith(Routes.main));
    } else if (category ==
            RouteCategoryFrontComponentConst.fireExtinguishingAgent &&
        (item == RouteItemFrontComponentConst.extinguishLoad ||
            item == RouteItemFrontComponentConst.extinguishWastage)) {
      Navigator.of(context)
          .popUntil((route) => route.settings.name.startsWith(Routes.main));
    } else {
      Navigator.of(context)
          .popUntil((route) => route.settings.name.startsWith(Routes.main));
    }
  }
}
