import 'dart:convert' show json;

// 巡检记录数据提交对象
class CheckRecordDto {
  int planTaskId;
  int pointId;
  String pointNo;
  String remark;
  num classId;
  String checkMode;
  String planName;
  String executor;
  String checkTime;
  List<CheckItemDto> checkItems;
  num routePointItemId;
  bool isOffline = false;
  String checkRecordImg;

  CheckRecordDto.fromParams({this.planTaskId, this.pointId, this.remark, this.checkItems, this.checkRecordImg});

  factory CheckRecordDto(jsonStr) => jsonStr == null
      ? null
      : jsonStr is String
          ? CheckRecordDto.fromJson(json.decode(jsonStr))
          : CheckRecordDto.fromJson(jsonStr);

  CheckRecordDto.fromJson(jsonRes) {
    planTaskId = jsonRes['planTaskId'];
    pointId = jsonRes['pointId'];
    remark = jsonRes['remark'];
    checkItems = jsonRes['checkItems'] == null ? null : [];
    routePointItemId = jsonRes['routePointItemId'];
    checkTime = jsonRes['checkTime'] == null ? null : '\"' + jsonRes['checkTime'] + '\"';
    isOffline = jsonRes['isOffline'];
    checkMode = jsonRes['checkMode'];
    checkRecordImg = jsonRes['checkRecordImg'].toString();
    for (final checkItemsItem in checkItems == null ? [] : jsonRes['checkItems']) {
      checkItems.add(checkItemsItem == null ? null : CheckItemDto.fromJson(checkItemsItem));
    }
  }

  @override
  String toString() {
    return '{"planTaskId": $planTaskId,"planName": ${planName != null ? '${json.encode(planName)}' : 'null'},"pointId": $pointId,"pointNo": ${pointNo != null ? '${json.encode(pointNo)}' : 'null'},"checkMode": "$checkMode","remark": ${remark != null ? '${json.encode(remark)}' : 'null'},"checkItems": $checkItems,"classId": $classId,"executor": ${executor != null ? '${json.encode(executor)}' : 'null'},"checkTime": $checkTime,"isOffline": $isOffline,"routePointItemId": $routePointItemId,"checkMode": ${checkMode != null ? '${json.encode(checkMode)}' : 'null'},"checkRecordImg":$checkRecordImg}';
  }
}

class CheckItemDto {
  int inputItemId;
  bool isCheck;
  String inputValue;
  String selectName;
  String remark;
  String classifyIds;
  num routePointItemId;
  String checkInputImg;

  CheckItemDto.fromParams(
      {this.inputItemId,
      this.isCheck,
      this.inputValue,
      this.selectName,
      this.remark,
      this.classifyIds,
      this.routePointItemId,
      this.checkInputImg});

  CheckItemDto.fromJson(jsonRes) {
    inputItemId = jsonRes['inputItemId'];
    isCheck = jsonRes['isCheck'];
    inputValue = jsonRes['inputValue'];
    selectName = jsonRes['selectName'];
    remark = jsonRes['remark'];
    classifyIds = jsonRes['classifyIds'];
    routePointItemId = jsonRes['routePointItemId'];
    checkInputImg = jsonRes['checkInputImg'].toString();
  }

  @override
  String toString() {
    return '{"inputItemId": $inputItemId,"isCheck": $isCheck,"inputValue": ${inputValue != null ? '${json.encode(inputValue)}' : 'null'},"selectName": ${selectName != null ? '${json.encode(selectName)}' : 'null'},"remark": ${remark != null ? '${json.encode(remark)}' : 'null'},"classifyIds": ${classifyIds != null ? '${json.encode(classifyIds)}' : 'null'},"routePointItemId": $routePointItemId,"checkInputImg":$checkInputImg}';
  }
}
