import 'dart:convert' show json;

class CalendarModel {
  int count;
  int omission;
  int qualified;
  int unqualified;
  List<CalendarDataModel> calendarData;

  CalendarModel.fromParams({this.count, this.omission, this.qualified, this.unqualified});

  factory CalendarModel(jsonStr) => jsonStr == null
      ? null
      : jsonStr is String
          ? CalendarModel.fromJson(json.decode(jsonStr))
          : CalendarModel.fromJson(jsonStr);

  CalendarModel.fromJson(jsonRes) {
    count = jsonRes['count'];
    omission = jsonRes['omission'];
    qualified = jsonRes['qualified'];
    unqualified = jsonRes['unqualified'];
  }

  @override
  String toString() {
    return '{"count": $count,"omission": $omission,"qualified": $qualified,"unqualified": $unqualified}';
  }
}

class CalendarDataModel {
  num omission;
  num qualified;
  num unqualified;
  String date;

  CalendarDataModel.fromParams({this.omission, this.qualified, this.unqualified, this.date});

  factory CalendarDataModel(jsonStr) => jsonStr == null
      ? null
      : jsonStr is String
          ? CalendarDataModel.fromJson(json.decode(jsonStr))
          : CalendarDataModel.fromJson(jsonStr);

  CalendarDataModel.fromJson(jsonRes) {
    omission = jsonRes['omission'];
    qualified = jsonRes['qualified'];
    unqualified = jsonRes['unqualified'];
    date = jsonRes['date'];
  }

  @override
  String toString() {
    return '{"omission": $omission,"qualified": $qualified,"unqualified": $unqualified,"date": ${date != null ? '${json.encode(date)}' : 'null'}}';
  }
}
