import 'dart:convert' show json;

import 'package:base/model/APIResponse.dart';
import 'package:base/services/api_address.dart';
import 'package:base/utils/HttpUtil.dart';

import '../model/CheckExecute/check_point_record_list.dart';
import '../model/CheckExecute/query_point_detail.dart';
import '../model/CheckRecordDto.dart';
import '../model/plan_list_input.dart';

Future<APIResponse> saveCheckRecord(CheckRecordDto dto) async {
  try {
    if (null == dto) {
      return APIResponse.error('必填参数不能为空！');
    }
    var data = await HttpUtil().post(ApiAddress.SAVE_CHECK_RECORD, data: dto.toString());
    return APIResponse(data);
  } catch (e) {
    return APIResponse.error('保存失败！');
  }
}

Future<Map<String, List<CheckPointRecordDetail>>> getCheckPointRecordList(PlanListInput planListInput, num pointId) async {
  try {
    List<Map> request = [];
    // 用户ID
    if (null != planListInput.userId && -1 != planListInput.userId) {
      request.add({'name': 'userId', 'value': planListInput.userId});
    }
    // 状态
    if (null != planListInput.finishStatus && -1 != planListInput.finishStatus) {
      request.add({'name': 'isOk', 'value': planListInput.finishStatus});
    }
    // 开始时间
    if (null != planListInput.startTime && '' != planListInput.startTime) {
      request.add({'name': 'startTime', 'value': planListInput.startTime + ' 00:00:00'});
    }
    // 结束时间
    if (null != planListInput.endTime && '' != planListInput.endTime) {
      request.add({'name': 'endTime', 'value': planListInput.endTime + ' 23:59:59'});
    }
    // 部门
    if (null != planListInput.departmentId && -1 != planListInput.departmentId) {
      request.add({'name': 'departmentId', 'value': planListInput.departmentId});
    }
    // 线路
    if (null != planListInput.routeId && -1 != planListInput.routeId) {
      request.add({'name': 'routeId', 'value': planListInput.routeId});
    }
    request.add({'name': 'pointId', 'value': pointId});
    Map<String, List<CheckPointRecordDetail>> rst = {};
    // 调用接口查询数据
    var data = await HttpUtil().post(ApiAddress.CHECK_POINT_RECORD_LIST, data: json.encode(request));
    //具体实现函数待编写
    if (data['result'] == 'SUCCESS') {
      if (data['dataList'].toString() != '[]') {
        Map<String, dynamic> _data = data['dataList'];
        _data.forEach((k, v) {
          List<CheckPointRecordDetail> detailLst = [];
          for (final _detail in v) {
            detailLst.add(CheckPointRecordDetail.fromJson(_detail));
          }
          rst[k] = detailLst;
        });
      }
    }
    return rst;
  } catch (e) {
    rethrow;
  }
}

// 巡检点详情
Future<QueryPointDetail> getQueryPointDetail(num pointId) async {
  QueryPointDetail detail = QueryPointDetail();
  var dataRst = await HttpUtil().get(ApiAddress.QUERY_POINT_DETAIL_BY_ID, data: {"pointId": pointId});
  if (dataRst['result'] == 'SUCCESS') {
    if (dataRst['dataList'].toString() != '[]') {
      var data = dataRst['dataList'];
      PointInfo pointInfo = PointInfo.fromJson(data['point']);
      for (final key in data['inputItems'].keys) {
        List<InputItems> inputItems = [];
        for (final item in data['inputItems'][key]) {
          inputItems.add(InputItems.fromParams(inputItenName: item['name']));
        }
        detail.inputItems[key] = inputItems;
      }
      List<Route> routs = [];
      for (final route in data['routes']) {
        routs.add(Route.fromJson(route));
      }
      detail.pointInfo = pointInfo;
      detail.routs = routs;
    }
  }
  return detail;
}
