import 'package:base/services/api_address.dart';
import 'package:base/utils/HttpUtil.dart';

import '../model/no_plan_inspection/NoPlanPlanInfo.dart';

//Future<List<NoPlanPlanInfo>> getQueryPlanTaskBySerialInfo(num dataType,String serial) async{
//
//  List<NoPlanPlanInfo> rst = List();
//  var data = await HttpUtil().get(ApiAddress.QUERY_PLANT_ASK_BY_SERIAL,data:{"dataType":dataType,"serial":serial});
//  if(data["result"] == "SUCCESS"){
//    if(data["dataList"].toString()!="[]"){
//      for(var _info in data["dataList"]){
//        rst.add(NoPlanPlanInfo.fromJson(_info));
//      }
//    }
//  }
//  return rst;
//}

Future<NoPlanPlanInfo> getQueryPlanTaskBySerialInfo(
    num dataType, String serial, dynamic planTaskId) async {
  NoPlanPlanInfo rst;
  var data;
  if (planTaskId != null) {
    data = await HttpUtil().get(ApiAddress.QUERY_PLANT_ASK_BY_SERIAL, data: {
      "dataType": dataType,
      "serial": serial,
      "planTaskId": planTaskId
    });
  } else {
    data = await HttpUtil().get(ApiAddress.QUERY_PLANT_ASK_BY_SERIAL,
        data: {"dataType": dataType, "serial": serial});
  }
//  var data = await HttpUtil().get(ApiAddress.QUERY_PLANT_ASK_BY_SERIAL,data:{"dataType":dataType,"serial":serial,"planTaskId":planTaskId});
//  var data = await HttpUtil().get(ApiAddress.QUERY_PLANT_ASK_BY_SERIAL,data:{"serial":serial});
  if (data["result"] == "SUCCESS") {
    if (data["dataList"].toString() != "[]" &&
        data["dataList"].toString() != "null") {
      rst = NoPlanPlanInfo.fromJson(data["dataList"]);
      rst.success = true;
      rst.message = "";
    }
  } else {
    rst = NoPlanPlanInfo.fromParams();
    rst.success = false;
    rst.message = data["message"];
  }
  return rst;
}
