import 'dart:io';
import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:base/model/tree_node_model.dart';
import 'package:base/model/warehouse_tree_postion_view_model.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:base/utils/request.dart';
import 'package:base/widgets/choose_position.dart';
import 'package:base/widgets/loading_dialog.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:modal_progress_hud/modal_progress_hud.dart';
import 'package:provider/provider.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../services/HiddenDanger.dart';
import '../../view/CheckExecute/ImageList.dart';

class HideDanger {
  TextEditingController dangerPlace = TextEditingController(); //隐患地点
  TextEditingController department = TextEditingController(); //责任单位
  String dangerPlaceId = '';
  String bizOrgCode = '';
  TextEditingController dangerPlacedetal = TextEditingController(); //隐患详细地点
  TextEditingController dangerName = TextEditingController(); //隐患名称
  num dangerLevel = 0; //隐患等级   1 一般隐患  2重大隐患
  TextEditingController remark = TextEditingController(); //备注信息
  TextEditingController limitDate = TextEditingController(); //治理时间
  String reviewUserIds; //评审人id
  TextEditingController reviewUserName = TextEditingController(); //评审人
  int reviewDeptIds; //评审部门id
  TextEditingController reviewDeptName = TextEditingController(); //评审部门
  TextEditingController delayLimitDate = TextEditingController();
  TextEditingController wentimiaoshu = TextEditingController();
  TextEditingController juyifansan = TextEditingController();
  String photoUrls = '';
  int needCompanyVerify = 0;
}

class HiddenDangerFound extends StatefulWidget {
  const HiddenDangerFound({Key key}) : super(key: key);

  ///消息提示
  static popUpMsg(String msg, {txtColor, bgColor, gravity, time}) {
    shortMessage(msg,
        gravity: gravity ?? ToastGravity.CENTER,
        toastLength: time,
        textColor: txtColor ?? Colors.white,
        backgroundColor: bgColor ?? Colors.black54);
  }

  @override
  _HiddenDangerFound createState() => _HiddenDangerFound();
}

class _HiddenDangerFound extends State<HiddenDangerFound> {
  HideDanger hidedanger = HideDanger();
  String theme = 'blue';
  TreeNodeModel model = TreeNodeModel();
  TreeNodeModel model1 = TreeNodeModel();

  // 当前点的附件
  List<File> imageList = [];
  bool isAnimating = false;
  bool canOperate = true;

  Future<void> _saveHideDangerInfo(HideDanger jsonStr) async {
    setState(() {
      isAnimating = true;
      canOperate = false;
    });
    await saveHideDangerInfo(jsonStr).then((data) {
      setState(() {
        if (data) {
          HiddenDangerFound.popUpMsg('隐患提交成功!');
          reSetValue(); //重置数据
          Navigator.pop(context);
        } else {}
        isAnimating = false;
        canOperate = true;
      });
    }).catchError((e) {
      setState(() {
        isAnimating = false;
        canOperate = true;
      });
    });
  }

  Future<void> _upDateImg(List<File> att) async {
    if (att is List && att.isEmpty) {
      return;
    }
    setState(() {
      isAnimating = true;
      canOperate = false;
    });
    await updataImg(att).then((data) {
      if (mounted) {
        setState(() {
          if (data.success) {
            hidedanger.photoUrls = data.message;
          } else {
            isAnimating = false;
            canOperate = true;
            HiddenDangerFound.popUpMsg(data.message);
            setState(() {
              imageList.clear();
            });
          }
          isAnimating = false;
          canOperate = true;
        });
      }
    }).catchError((onError) {
      setState(() {
        isAnimating = false;
        canOperate = true;
      });
    });
  }

  Future<void> reSetValue() async {
    setState(() {
      hidedanger.reviewUserIds = '';
      hidedanger.reviewUserName.text = '';
      hidedanger.reviewDeptIds = 0;
      hidedanger.reviewDeptName.text = '';
      hidedanger.dangerName.text = '';
      hidedanger.dangerLevel = 0;
      hidedanger.dangerPlace.text = '';
      hidedanger.department.text = '';
      hidedanger.remark.text = '';
      hidedanger.limitDate.text = '';
      hidedanger.photoUrls = '';
      hidedanger.dangerPlacedetal.text = '';
      hidedanger.dangerPlaceId = '';
      hidedanger.bizOrgCode = '';
      imageList = [];
    });
  }

  bool _checkNeed() {
    if (hidedanger.dangerPlace.text == null || hidedanger.dangerPlace.text == '') {
      HiddenDangerFound.popUpMsg('请选择隐患地点！');
      return false;
    }
    if (hidedanger.department.text == null || hidedanger.department.text == '') {
      HiddenDangerFound.popUpMsg('请选择责任单位/部门！');
      return false;
    }
    if (hidedanger.dangerName.text == null || hidedanger.dangerName.text == '') {
      HiddenDangerFound.popUpMsg('请填写隐患名称！');
      return false;
    }
    if (hidedanger.dangerLevel == -1) {
      HiddenDangerFound.popUpMsg('请选择隐患等级！');
      return false;
    }
    if (imageList.isEmpty || imageList == null) {
      HiddenDangerFound.popUpMsg('请上传隐患图片');
      return false;
    }
    return true;
  }

  // 获取仓库位置信息
  Future<void> getWarehousePosition(BuildContext context, {String code = 'FFjKkk'}) async {
    Future.delayed(Duration.zero, () {
      showDialog(
          context: context,
          builder: (ctx) {
            return LoadingDialog(
              barrierDismissible: true,
            );
          });
      HttpRequest.getHiddenPositionStructureTree(code)
          .then((res) {
            if (res['status'] == 200) {
              Provider.of<WarehouseTreePositionViewModel>(context, listen: false).positions =
                  res['result'];
            }
          }).catchError((_) {}).whenComplete(() => Navigator.of(context).pop());

    });
  }

  // 获取单位树
  Future<void> geDepartmentTree(BuildContext context) async {
    Future.delayed(Duration.zero, () {
      showDialog(
          context: context,
          builder: (ctx) {
            return LoadingDialog(
              barrierDismissible: true,
            );
          });
      HttpRequest.companyTreeByUserAndType()
          .then((res) {
        if (res['status'] == 200) {
          Provider.of<WarehouseTreePositionViewModel>(context, listen: false).department =
          res['result'];
        }
      }).catchError((_) {}).whenComplete(() => Navigator.of(context).pop());

    });
  }
  // 选择位置
  void selectPosition(context) {
    List items = Provider.of<WarehouseTreePositionViewModel>(context, listen: false).positions;
    showModalBottomSheet(
        isDismissible: false,
        enableDrag: false,
        shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(10)),
        context: context,
        builder: (BuildContext context) {
          return ChoosePositionDialog(
            theme: theme,
            data: items,
            name:'选择隐患地点',
            selectedModel: model,
            close: () {},
            callback: (TreeNodeModel model) {
              // setState(() {
              //   hidedanger.dangerPlace.text = model.absolutePosition ?? model.name;
              //   this.model = model;
              // });
            },
            confirm: (TreeNodeModel model) {
              this.model = model;
              hidedanger.dangerPlaceId = model.id;
            },
          );
        });
  }

  // 选择责任部门
  void selectPosition1(context) {
    List items = Provider.of<WarehouseTreePositionViewModel>(context, listen: false).department;
    showModalBottomSheet(
        isDismissible: false,
        enableDrag: false,
        shape: RoundedRectangleBorder(borderRadius: BorderRadius.circular(10)),
        context: context,
        builder: (BuildContext context) {
          return ChoosePositionDialog(
            theme: theme,
            data: items,
            name:'选择责任单位/部门',
            selectedModel: model1,
            close: () {},
            callback: (TreeNodeModel model) {
              setState(() {
                hidedanger.department.text = model.absolutePosition ?? model.name;
                this.model1 = model;
              });
            },
            confirm: (TreeNodeModel model) {
              this.model1 = model;
              hidedanger.bizOrgCode = model.id;
              setState(() {
                this.model.name = '';
                hidedanger.dangerPlaceId = '';
                hidedanger.dangerPlace.text = '';
              });
              hidedanger.dangerPlaceId = '';
              hidedanger.dangerPlace.text = '';
            },
          );
        });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: const Text(
          '发现隐患',
        ),
        centerTitle: true,
        elevation: 0.2,
        brightness: Brightness.light,
      ),
      body: ModalProgressHUD(
        child: SingleChildScrollView(
          child: Container(
            padding: const EdgeInsets.only(bottom: 10),
            child: Column(
              children: <Widget>[
                /// 责任单位/部门
                Row(
                  children: <Widget>[
                    Expanded(
                      child: Container(
                        padding: const EdgeInsets.only(left: 20, top: 10, bottom: 5),
                        width: MediaQuery.of(context).size.width - 50,
                        child: Column(
                          children: <Widget>[
                            Row(
                              children: const <Widget>[
                                Expanded(
                                  child: Text(
                                    '*',
                                    style: TextStyle(color: Colors.red),
                                  ),
                                  flex: 0,
                                ),
                                Expanded(
                                  child: Text(
                                    '责任单位/部门',
                                    style: TextStyle(
                                      color: Colors.black,
                                      fontSize: 18,
                                    ),
                                  ),
                                  flex: 19,
                                ),
                              ],
                            ),
                            Container(
                              width: MediaQuery.of(context).size.width - 50,
                              padding: const EdgeInsets.only(
                                top: 5,
                                bottom: 10,
                              ),
                              child: Row(
                                children: <Widget>[
                                  Expanded(
                                    child: TextField(
                                      enableInteractiveSelection: false,
                                      autofocus: false,
                                      controller: hidedanger.department,
                                      onTap: () {
                                        FocusScope.of(context).requestFocus(FocusNode());
                                        selectPosition1(context);
                                      },
                                      maxLines: 1,
                                      decoration: InputDecoration(
                                          contentPadding: const EdgeInsets.symmetric(vertical: 10.0, horizontal: 10),
                                          border: InputBorder.none,
                                          hintText: '请选择责任单位/部门',
                                          filled: true,
                                          fillColor: const Color.fromRGBO(244, 244, 244, 1),
                                          suffixIcon: Icon(
                                            Icons.chevron_right,
                                            color: Theme.of(context).primaryColor,
                                          )),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ],
                        ),
                      ),
                    ),
                  ],
                ),
                /// 隐患位置
                Row(
                  children: <Widget>[
                    Expanded(
                      child: Container(
                        padding: const EdgeInsets.only(left: 20, top: 10, bottom: 5),
                        width: MediaQuery.of(context).size.width - 50,
                        child: Column(
                          children: <Widget>[
                            Row(
                              children: const <Widget>[
                                Expanded(
                                  child: Text(
                                    '*',
                                    style: TextStyle(color: Colors.red),
                                  ),
                                  flex: 0,
                                ),
                                Expanded(
                                  child: Text(
                                    '隐患地点',
                                    style: TextStyle(
                                      color: Colors.black,
                                      fontSize: 18,
                                    ),
                                  ),
                                  flex: 19,
                                ),
                              ],
                            ),
                            Container(
                              width: MediaQuery.of(context).size.width - 50,
                              padding: const EdgeInsets.only(
                                top: 5,
                                bottom: 10,
                              ),
                              child: Row(
                                children: <Widget>[
                                  Expanded(
                                    child: TextField(
                                      enableInteractiveSelection: false,
                                      autofocus: false,
                                      controller: hidedanger.dangerPlace,
                                      onTap: () {
                                        FocusScope.of(context).requestFocus(FocusNode());
                                        HttpRequest.getHiddenPositionStructureTree(hidedanger.bizOrgCode)
                                            .then((res) {
                                          if (res['status'] == 200) {
                                            Provider.of<WarehouseTreePositionViewModel>(context, listen: false).positions =
                                            res['result'];
                                            selectPosition(context);
                                          }
                                        });
                                      },
                                      maxLines: 1,
                                      decoration: InputDecoration(
                                          contentPadding: const EdgeInsets.symmetric(vertical: 10.0, horizontal: 10),
                                          border: InputBorder.none,
                                          hintText: '请选择隐患地点',
                                          filled: true,
                                          fillColor: const Color.fromRGBO(244, 244, 244, 1),
                                          suffixIcon: Icon(
                                            Icons.chevron_right,
                                            color: Theme.of(context).primaryColor,
                                          )),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ],
                        ),
                      ),
                    ),
                  ],
                ),

                /// 隐患地点
                Row(
                  children: <Widget>[
                    Expanded(
                      child: Container(
                        padding: const EdgeInsets.only(left: 20, top: 10, bottom: 5),
                        width: MediaQuery.of(context).size.width - 50,
                        child: Column(
                          children: <Widget>[
                            Row(
                              children: const <Widget>[
                                Expanded(
                                  child: Text(
                                    '详细地址',
                                    style: TextStyle(
                                      color: Colors.black,
                                      fontSize: 18,
                                    ),
                                  ),
                                  flex: 19,
                                ),
                              ],
                            ),
                            Container(
                              width: MediaQuery.of(context).size.width - 50,
                              padding: const EdgeInsets.only(
                                top: 5,
                                bottom: 10,
                              ),
                              child: Row(
                                children: <Widget>[
                                  Expanded(
                                    child: TextField(
                                      onSubmitted: (text) {
                                        FocusScope.of(context).requestFocus(FocusNode());
                                      },
                                      autofocus: false,
                                      controller: hidedanger.dangerPlacedetal,
                                      maxLines: 1,
                                      decoration: const InputDecoration(
                                        contentPadding: EdgeInsets.symmetric(vertical: 10.0, horizontal: 10),
                                        border: InputBorder.none,
                                        hintText: '请输入详细地址',
                                        filled: true,
                                        fillColor: Color.fromRGBO(244, 244, 244, 1),
                                      ),
                                      inputFormatters: <TextInputFormatter>[
                                        LengthLimitingTextInputFormatter(255) //限制长度
                                      ],
                                      onEditingComplete: () {},
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ],
                        ),
                      ),
                    ),
                  ],
                ),

                ///隐患名称
                Row(
                  children: <Widget>[
                    Expanded(
                      child: Container(
                        padding: const EdgeInsets.only(left: 20, top: 10, bottom: 5),
                        width: MediaQuery.of(context).size.width - 50,
                        child: Column(
                          children: <Widget>[
                            Row(
                              children: const <Widget>[
                                Expanded(
                                  child: Text(
                                    '*',
                                    style: TextStyle(color: Colors.red),
                                  ),
                                  flex: 0,
                                ),
                                Expanded(
                                  child: Text(
                                    '隐患名称',
                                    style: TextStyle(
                                      color: Colors.black,
                                      fontSize: 18,
                                    ),
                                  ),
                                  flex: 19,
                                ),
                              ],
                            ),
                            Container(
                              width: MediaQuery.of(context).size.width - 50,
                              padding: const EdgeInsets.only(
                                top: 5,
                                bottom: 10,
                              ),
                              child: Row(
                                children: <Widget>[
                                  Expanded(
                                    child: TextField(
                                      onSubmitted: (text) {
                                        FocusScope.of(context).requestFocus(FocusNode());
                                      },
                                      autofocus: false,
                                      controller: hidedanger.dangerName,
                                      enableInteractiveSelection: true,
                                      maxLines: 1,
                                      decoration: const InputDecoration(
                                        contentPadding: EdgeInsets.symmetric(vertical: 10.0, horizontal: 10),
                                        border: InputBorder.none,
                                        hintText: '请输入隐患名称',
                                        filled: true,
                                        fillColor: Color.fromRGBO(244, 244, 244, 1),
                                      ),
                                      inputFormatters: <TextInputFormatter>[
                                        LengthLimitingTextInputFormatter(50) //限制长度
                                      ],
                                      onEditingComplete: () {
                                        //print(this._controller.text);
                                      },
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ],
                        ),
                      ),
                    ),
                  ],
                ),

                ///隐患等级
                Row(
                  children: <Widget>[
                    Expanded(
                      child: Container(
                        padding: const EdgeInsets.only(left: 20, top: 10, bottom: 5),
                        width: MediaQuery.of(context).size.width - 50,
                        child: Column(
                          children: <Widget>[
                            Row(
                              children: const <Widget>[
                                Expanded(
                                  child: Text(
                                    '*',
                                    style: TextStyle(color: Colors.red),
                                  ),
                                  flex: 0,
                                ),
                                Expanded(
                                  child: Text(
                                    '隐患等级',
                                    style: TextStyle(
                                      color: Colors.black,
                                      fontSize: 18,
                                    ),
                                  ),
                                  flex: 19,
                                ),
                              ],
                            ),
                            Container(
                              width: MediaQuery.of(context).size.width - 20,
                              padding: const EdgeInsets.only(
                                top: 5,
                                bottom: 5,
                              ),
                              child: Row(
                                mainAxisAlignment: MainAxisAlignment.start,
                                children: <Widget>[
                                  Expanded(
                                    flex: 1,
                                    child: Row(
                                      children: <Widget>[
                                        Radio(
                                          activeColor: Theme.of(context).primaryColor,
                                          value: 0,
                                          groupValue: hidedanger.dangerLevel,
                                          onChanged: (val) {
                                            setState(() {
                                              hidedanger.dangerLevel = val;
                                            });
                                          },
                                        ),
                                        GestureDetector(
                                          child: const Text('安全问题'),
                                          onTap: () {
                                            setState(() {
                                              hidedanger.dangerLevel = 0;
                                            });
                                          },
                                        )
                                      ],
                                    ),
                                  ),
                                  Expanded(
                                    flex: 1,
                                    child: Row(
                                      children: <Widget>[
                                        Radio(
                                          activeColor: Theme.of(context).primaryColor,
                                          value: 1,
                                          groupValue: hidedanger.dangerLevel,
                                          onChanged: (val) {
                                            setState(() {
                                              hidedanger.dangerLevel = val;
                                            });
                                          },
                                        ),
                                        GestureDetector(
                                          child: const Text('一般隐患'),
                                          onTap: () {
                                            setState(() {
                                              hidedanger.dangerLevel = 1;
                                            });
                                          },
                                        )
                                      ],
                                    ),
                                  ),
                                  Expanded(
                                    flex: 1,
                                    child: Row(
                                      children: <Widget>[
                                        Radio(
                                          activeColor: Theme.of(context).primaryColor,
                                          value: 2,
                                          groupValue: hidedanger.dangerLevel,
                                          onChanged: (val) {
                                            setState(() {
                                              hidedanger.dangerLevel = val;
                                            });
                                          },
                                        ),
                                        GestureDetector(
                                          child: const Text('重大隐患'),
                                          onTap: () {
                                            setState(() {
                                              hidedanger.dangerLevel = 2;
                                            });
                                          },
                                        )
                                      ],
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ],
                        ),
                      ),
                    ),
                  ],
                ),
                Container(
                  color: Colors.grey[100],
                  height: 10,
                ),

                ///拍照取证
                Container(
                  child: GestureDetector(
                    child: Row(
                      children: <Widget>[
                        Expanded(
                          flex: 10,
                          child: Container(
                            padding: const EdgeInsets.only(left: 20, top: 10, bottom: 10),
                            height: 80,
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              children: const <Widget>[
                                Expanded(
                                  child: Text(
                                    '*',
                                    style: TextStyle(color: Colors.red),
                                  ),
                                  flex: 0,
                                ),
                                Expanded(
                                  child: Text(
                                    '拍照取证',
                                    textAlign: TextAlign.left,
                                    style: TextStyle(
                                      color: Colors.black,
                                      fontSize: 18,
                                    ),
                                  ),
                                  flex: 9,
                                ),
                              ],
                            ),
                          ),
                        ),
                        Expanded(
                          flex: 0,
                          child: Container(
                            child: Icon(
                              Icons.photo_camera,
                              color: Theme.of(context).primaryColor,
                              size: 22,
                            ),
                          ),
                        ),
                        Expanded(
                          flex: 1,
                          child: Container(
                            child: GestureDetector(
                              //50  89  206
                              child: Icon(
                                Icons.keyboard_arrow_right,
                                color: Theme.of(context).primaryColor,
                                size: 22,
                              ),
                              onTap: () {
                                FocusScope.of(context).requestFocus(FocusNode());
                                Navigator.push(context, MaterialPageRoute(builder: (context) {
                                  return ImageList(imageList);
                                })).then((v) {
                                  print(v);
                                  if (v != null) {
                                    setState(() {
                                      imageList = v;
                                      //保存图片
                                      _upDateImg(imageList);
                                    });
                                  } else {
                                    hidedanger.photoUrls = '';
                                  }
                                });
                              },
                            ),
                          ),
                        ),
                      ],
                    ),
                    onTap: () {
                      FocusScope.of(context).requestFocus(FocusNode());
                      Navigator.push(context, MaterialPageRoute(builder: (context) {
                        return ImageList(imageList);
                      })).then((v) {
                        print(v);
                        if (v != null) {
                          setState(() {
                            imageList = v;
                            //保存图片
                            _upDateImg(imageList);
                            // }
                          });
                        } else {
                          hidedanger.photoUrls = '';
                        }
                      });
                    },
                  ),
                ),
                Container(
                  color: Colors.grey[100],
                  height: 10,
                ),

                /// 备注
                Container(
                  padding: const EdgeInsets.only(left: 20, top: 10, bottom: 10),
                  child: Column(
                    children: <Widget>[
                      Row(
                        children: const <Widget>[
                          Expanded(
                            child: Text(
                              '备注',
                              style: TextStyle(
                                color: Colors.black,
                                fontSize: 18,
                              ),
                            ),
                          ),
                        ],
                      ),
                      Container(
                          margin: const EdgeInsets.only(top: 30, right: 15),
                          decoration: const BoxDecoration(color: Color.fromRGBO(244, 244, 244, 1)),
                          child: TextField(
                            autofocus: false,
                            maxLength: 500,
                            controller: hidedanger.remark,
                            enableInteractiveSelection: true,
                            maxLines: null,
                            decoration: const InputDecoration(
                              contentPadding: EdgeInsets.symmetric(vertical: 10.0, horizontal: 10),
                              border: InputBorder.none,
                              hintText: '请输入备注信息',
                              filled: true,
                              fillColor: Color.fromRGBO(244, 244, 244, 1),
                            ),
                            inputFormatters: <TextInputFormatter>[
                              LengthLimitingTextInputFormatter(500) //限制长度
                            ],
                            onEditingComplete: () {},
                          )),
                    ],
                  ),
                ),
                const SizedBox(
                  height: 10,
                ),
                Container(
                  padding: const EdgeInsets.symmetric(horizontal: 10),
                  child: Row(
                    children: <Widget>[
                      Expanded(
                        child: MaterialButton(
                          color: const Color.fromRGBO(242, 246, 249, 1),
                          height: 45,
                          textColor: Colors.black,
                          child: const Text(
                            '重置',
                            style: TextStyle(fontSize: 20),
                          ),
                          onPressed: () {
                            if (canOperate) {
                              reSetValue();
                            } else {
                              HiddenDangerFound.popUpMsg('网速较慢！请等待图片上传完成');
                            }
                          },
                        ),
                      ),
                      const SizedBox(
                        width: 10,
                      ),
                      Expanded(
                        child: MaterialButton(
                          color: Theme.of(context).primaryColor,
                          height: 45,
                          textColor: Colors.white,
                          child: const Text('确定', style: TextStyle(fontSize: 20)),
                          onPressed: () {
                            //必填项判断
                            if (canOperate) {
                              if (_checkNeed()) {
                                // _upDateImg(imageList);
                                _saveHideDangerInfo(hidedanger);
                              }
                            } else {
                              HiddenDangerFound.popUpMsg('正在执行操作！请稍等...');
                            }
                          },
                        ),
                      ),
                    ],
                  ),
                ),
              ],
            ),
          ),
        ),
        inAsyncCall: isAnimating,
        opacity: 0.7,
        progressIndicator: const CircularProgressIndicator(),
      ),
      resizeToAvoidBottomPadding: false,
    );
  }

  @override
  void initState() {
    super.initState();
    getInitInfo();
    geDepartmentTree(context);
    getWarehousePosition(context);
  }

  Future<void> getInitInfo() async {
    await SharedPreferences.getInstance().then((data) {
      theme = data.getString('theme') ?? 'blue';
    }).then((data) {});
  }
}

