import 'dart:convert';

import 'package:base/consts/color.dart';
import 'package:base/view/ImageViewPage.dart';
import 'package:flutter/material.dart';
import 'package:intl/intl.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../model/Hidden_Danger/hidden_danger_model.dart';
import '../../services/HiddenDanger.dart';
import '../../view/hidedanger_manage/hidden_danger_flowRecord.dart';
import '../../view/hidedanger_manage/hidden_danger_found.dart';
import '../../view/hidedanger_manage/hidden_danger_processed_rectification_measures_show.dart';

class HiddenDangerProcessedCheckedDetail extends StatefulWidget {
  final int dangerId;
  final String taskId;
  final bool isFinish;

  const HiddenDangerProcessedCheckedDetail(this.dangerId, this.taskId, this.isFinish);

  @override
  _HiddenDangerProcessedCheckedDetail createState() => _HiddenDangerProcessedCheckedDetail();
}

class _HiddenDangerProcessedCheckedDetail extends State<HiddenDangerProcessedCheckedDetail> {
  TextEditingController remark = TextEditingController();

  @override
  bool get wantKeepAlive => true;

  bool isAnimating = false;

  String myUserId;

  HideDangerInfoModel initData;
  HideDanger hideDanger = HideDanger();

  String theme = '';
  String imageUrl = '';

  @override
  void initState() {
    super.initState();
    getInitInfo();
  }

  void getInitInfo() async {
    await SharedPreferences.getInstance().then((data) {
      if (data != null) {
        setState(() {
          this.theme = data.getString("theme") ?? KColorConstant.DEFAULT_COLOR;
          imageUrl = data.getString('imageUrl') ?? '';
        });
      }
    }).then((data) {
      loadData();
    });
  }

  void loadData() async {
    setState(() {
      isAnimating = true;
    });
    await getHiddenDangerModel(context,this.widget.dangerId, this.widget.taskId, isFinish: this.widget.isFinish).then((data) {
      setState(() {
        if (data != null) {
          initData = data;
          List<String> photos = [];
          (initData.photoUrls ?? []).forEach((item) {
            photos.add(imageUrl + item);
          });
          initData.photoUrls = photos;
        }
        isAnimating = false;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    ///null == routeList || routeList.length <= 0
    if (initData == null || initData.dangerId == null) {
      return Scaffold(
          appBar: AppBar(
        title: const Text(
          "隐患验证详情",
        ),
        actions: <Widget>[],
        centerTitle: true,
        elevation: 0.2,
        brightness: Brightness.light,
      ));
    }

    return Scaffold(
      appBar: AppBar(
        title: const Text(
          '隐患验证详情',
        ),
        actions: <Widget>[],
        centerTitle: true,
        elevation: 0.2,
        brightness: Brightness.light,
      ),
      body: SingleChildScrollView(
        child: Container(
          color: Colors.white,
          child: Column(
            children: <Widget>[
              initData.dangerType == 2
                  ? Column(
                      children: <Widget>[
                        Row(
                          children: <Widget>[
                            Expanded(
                              flex: 5,
                              child: Container(
                                padding: const EdgeInsets.only(left: 10, top: 10),
                                height: 50,
                                child: const Text(
                                  "点名称",
                                  style: TextStyle(color: Colors.black, fontSize: 18),
                                ),
                              ),
                            ),
                            Expanded(
                              flex: 10,
                              child: Text(initData.riskInfo == null ? "-" : initData.riskInfo.pointName),
                            )
                          ],
                        ),
                        //点编号
                        Row(
                          children: <Widget>[
                            Expanded(
                              flex: 5,
                              child: Container(
                                padding: EdgeInsets.only(left: 10, top: 10),
                                height: 50,
                                child: const Text(
                                  "点编号",
                                  style: TextStyle(color: Colors.black, fontSize: 18),
                                ),
                              ),
                            ),
                            Expanded(
                              flex: 10,
                              child: Text(initData.riskInfo == null ? "-" : initData.riskInfo.pointNo),
                            )
                          ],
                        ),
                        // Divider(),
                        //等级
                        Row(
                          children: <Widget>[
                            Expanded(
                              flex: 5,
                              child: Container(
                                padding: EdgeInsets.only(left: 10, top: 10),
                                height: 50,
                                child: Text(
                                  "等级",
                                  style: TextStyle(color: Colors.black, fontSize: 18),
                                ),
                              ),
                            ),
                            Expanded(
                              flex: 10,
                              child: Text("${initData.riskInfo != null ? initData.riskInfo.pointLevel : "--"}"),
                            ),
                          ],
                        ),
                        //分割线
                        Container(
                          color: Colors.grey[100],
                          height: 10,
                        ),
                        Row(
                          children: <Widget>[
                            Container(
                              padding: EdgeInsets.only(left: 10, top: 10),
                              height: 50,
                              child: Text(
                                "检查依据",
                                style: TextStyle(
                                  fontWeight: FontWeight.w500,
                                  fontSize: 18,
                                ),
                              ),
                            ),
                          ],
                        ),

                        initData.riskInfo != null && initData.riskInfo.basis != null
                            ? Column(
                                children: initData.riskInfo.basis.map((base) {
                                  return Container(
                                    height: 30,
                                    decoration: BoxDecoration(
                                        border: Border(bottom: BorderSide(color: Color.fromRGBO(244, 244, 244, 1)))),
                                    width: MediaQuery.of(context).size.width,
                                    margin: EdgeInsets.only(left: 30),
                                    child: Text(
                                      json.decode(base)["name"].toString(),
                                      style: TextStyle(color: Colors.black, fontSize: 16),
                                    ),
                                  );
                                }).toList(),
                              )
                            : Container(),
                        Container(
                          color: Colors.grey[100],
                          height: 10,
                        ),
                      ],
                    )
                  : Text(""),

              ///隐患名称
              Row(
                children: <Widget>[
                  Expanded(
                    flex: 5,
                    child: Container(
                      padding: EdgeInsets.only(left: 10, top: 10),
                      width: 150,
                      height: 50,
                      child: Row(
                        children: <Widget>[
                          // Expanded(
                          //   child: Text(
                          //     "*",
                          //     style: TextStyle(color: Colors.red),
                          //   ),
                          //   flex: 0,
                          // ),
                          Expanded(
                            child: Text(
                              "隐患名称",
                              style: TextStyle(
                                fontWeight: FontWeight.w500,
                                fontSize: 18,
                              ),
                            ),
                            flex: 19,
                          ),
                        ],
                      ),
                    ),
                  ),
                  Expanded(
                    flex: 10,
                    child: Container(
                      child: Text(initData.dangerName ?? ""),
                      padding: EdgeInsets.only(top: 5, right: 10),
                    ),
                  ),
                ],
              ),

              ///隐患地点
              initData.position == null
                  ? Container()
                  : Row(
                      children: <Widget>[
                        Expanded(
                          flex: 5,
                          child: Container(
                            padding: EdgeInsets.only(left: 10, top: 10),
                            width: 150,
                            height: 50,
                            child: Row(
                              children: <Widget>[
                                // Expanded(
                                //   child: Text(
                                //     "*",
                                //     style: TextStyle(color: Colors.red),
                                //   ),
                                //   flex: 0,
                                // ),
                                Expanded(
                                  child: Text(
                                    "隐患地点",
                                    style: TextStyle(
                                      fontWeight: FontWeight.w500,
                                      fontSize: 18,
                                    ),
                                  ),
                                  flex: 19,
                                ),
                              ],
                            ),
                          ),
                        ),
                        Expanded(
                          flex: 10,
                          child: Text(initData.position ?? "-"),
                        ),
                      ],
                    ),

              ///隐患等级
              Row(
                children: <Widget>[
                  Expanded(
                    flex: 5,
                    child: Container(
                      padding: EdgeInsets.only(left: 10, top: 10),
                      width: 150,
                      height: 50,
                      child: Row(
                        children: <Widget>[
                          // Expanded(
                          //   child: Text(
                          //     "*",
                          //     style: TextStyle(color: Colors.red),
                          //   ),
                          //   flex: 0,
                          // ),
                          Expanded(
                            child: Text(
                              "隐患等级",
                              style: TextStyle(
                                fontWeight: FontWeight.w500,
                                fontSize: 18,
                              ),
                            ),
                            flex: 19,
                          ),
                        ],
                      ),
                    ),
                  ),
                  Expanded(
                    flex: 10,
                    child: Text(
                      initData.levelDesc ?? "",
                      style: TextStyle(color: initData.level == 1 ? Colors.orange : Colors.red),
                    ),
                  ),
                ],
              ),

              //拍照取证
              Container(
                child: GestureDetector(
                  child: Row(
                    children: <Widget>[
                      Expanded(
                        flex: 3,
                        child: Container(
                          padding: const EdgeInsets.only(left: 10, top: 10),
                          height: 50,
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.start,
                            children: const <Widget>[
                              Expanded(
                                child: Text(
                                  "现场照片",
                                  textAlign: TextAlign.left,
                                  style: TextStyle(
                                    fontWeight: FontWeight.w500,
                                    fontSize: 18,
                                  ),
                                ),
                                flex: 9,
                              ),
                            ],
                          ),
                        ),
                      ),
                      Expanded(
                        flex: 7,
                        child: Container(
                          child: Wrap(
                              direction: Axis.horizontal,
                              spacing: -25.0, // 主轴(水平)方向间距
                              alignment: WrapAlignment.end, //沿主轴方向居中
                              children: initData.photoUrls != null
                                  ? initData.photoUrls.map((f) {
                                      return Column(
                                        mainAxisAlignment: MainAxisAlignment.end,
                                        children: <Widget>[
                                          Container(
                                            width: 40,
                                            height: 40,
                                            //  margin: EdgeInsets.only(right: 5),
                                            decoration: BoxDecoration(
                                                color: Colors.transparent,
                                                borderRadius: BorderRadius.all(const Radius.circular(20.0)),
                                                image: DecorationImage(image: NetworkImage(f), fit: BoxFit.cover)),
                                          ),
                                        ],
                                      );
                                    }).toList()
                                  : []),
                        ),
                      ),
                      Expanded(
                        flex: 1,
                        child: Container(
                          child: Icon(
                            Icons.keyboard_arrow_right,
                            color: Theme.of(context).primaryColor,
                            size: 22,
                          ),
                        ),
                      ),
                    ],
                  ),
                  onTap: () {
                    Navigator.push(context, MaterialPageRoute(builder: (context) {
                      return PhotoViewPage(initData.photoUrls);
                    }));
                  },
                ),
              ),

              Container(
                color: Colors.grey[100],
                height: 10,
              ),
              //执行日志
              Container(
                padding: const EdgeInsets.only(left: 15),
                width: MediaQuery.of(context).size.width,
                height: 55,
                child: GestureDetector(
                  child: Row(
                    children: <Widget>[
                      const Expanded(
                        child: Text("执行日志",
                            textAlign: TextAlign.left,
                            style: TextStyle(
                              fontWeight: FontWeight.w500,
                              fontSize: 19,
                            )),
                        flex: 9,
                      ),
                      Expanded(
                        child: Icon(
                          Icons.keyboard_arrow_right,
                          color: Theme.of(context).primaryColor,
                        ),
                        flex: 1,
                      ),
                    ],
                  ),
                  onTap: () {
                    Navigator.push(context, MaterialPageRoute(builder: (context) {
                      return HidenDangerFlowRecord(initData.dangerId);
                    }));
                  },
                ),
              ),
              Container(
                color: Colors.grey[100],
                height: 10,
              ),

              //整改日期
              Row(
                children: <Widget>[
                  Expanded(
                    flex: 5,
                    child: Container(
                      padding: EdgeInsets.only(left: 10, top: 10),
                      width: 150,
                      height: 50,
                      child: Row(
                        children: <Widget>[
                          // Expanded(
                          //   child: Text(
                          //     "*",
                          //     style: TextStyle(color: Colors.red),
                          //   ),
                          //   flex: 0,
                          // ),
                          Expanded(
                            child: Text(
                              "治理日期",
                              style: TextStyle(
                                fontWeight: FontWeight.w500,
                                fontSize: 18,
                              ),
                            ),
                            flex: 19,
                          ),
                        ],
                      ),
                    ),
                  ),
                  Expanded(
                    flex: 10,
                    child: Text(
                      DateFormat('yyyy-MM-dd').format(DateTime.parse(initData.reformLimitDate == null
                          ? DateTime.now().toString()
                          : initData.reformLimitDate.toString())),
                      style: TextStyle(color: Colors.black),
                    ),
                  ),
                ],
              ),

              //治理方式
              Row(
                children: <Widget>[
                  Expanded(
                    flex: 5,
                    child: Container(
                      padding: EdgeInsets.only(left: 10, top: 10),
                      width: 150,
                      height: 50,
                      child: Row(
                        children: <Widget>[
                          // Expanded(
                          //   child: Text(
                          //     "*",
                          //     style: TextStyle(color: Colors.red),
                          //   ),
                          //   flex: 0,
                          // ),
                          Expanded(
                            child: Text(
                              "治理方式",
                              style: TextStyle(
                                fontWeight: FontWeight.w500,
                                fontSize: 18,
                              ),
                            ),
                            flex: 19,
                          ),
                        ],
                      ),
                    ),
                  ),
                  Expanded(
                    flex: 10,
                    child: Text(
                      initData.reformTypeDesc ?? "-",
                      style: TextStyle(color: Colors.black),
                    ),
                  ),
                ],
              ),

              //治理措施
              Container(
                padding: EdgeInsets.only(left: 15),
                width: MediaQuery.of(context).size.width,
                height: 55,
                child: GestureDetector(
                  child: Row(
                    children: <Widget>[
                      Expanded(
                        child: Text("治理措施",
                            textAlign: TextAlign.left,
                            style: TextStyle(
                              fontWeight: FontWeight.w500,
                              fontSize: 19,
                            )),
                        flex: 9,
                      ),
                      Expanded(
                        child: Icon(
                          Icons.keyboard_arrow_right,
                          color: Theme.of(context).primaryColor,
                        ),
                        flex: 1,
                      ),
                    ],
                  ),
                  onTap: () {
                    Navigator.push(context, MaterialPageRoute(builder: (context) {
                      return HiddenDangerProcessedRectificationMeasuresShow(this.initData);
                    }));
                  },
                ),
              ),

              Container(
                color: Colors.grey[100],
                height: 10,
              ),

              ///验收结果
              Row(
                children: <Widget>[
                  Expanded(
                    flex: 5,
                    child: Container(
                      padding: EdgeInsets.only(left: 10, top: 10),
                      width: 150,
                      height: 50,
                      child: Row(
                        children: <Widget>[
                          Expanded(
                            child: Text(
                              "*",
                              style: TextStyle(color: Colors.red),
                            ),
                            flex: 0,
                          ),
                          Expanded(
                            child: Text(
                              "验收结果",
                              style: TextStyle(
                                fontWeight: FontWeight.w500,
                                fontSize: 18,
                              ),
                            ),
                            flex: 19,
                          ),
                        ],
                      ),
                    ),
                  ),
                  Expanded(
                    flex: 10,
                    child: Text(
                      initData.dangerStateDesc == null ? "-" : initData.dangerStateDesc,
                      style: TextStyle(
                          color: initData.recheckInfo == null
                              ? Colors.black
                              : (initData.recheckInfo.recheckState == 2 ? Colors.green : Colors.red)),
                    ),
                  ),
                ],
              ),
            ],
          ),
        ),
      ),
    );
  }
}
