import 'dart:convert';
import 'dart:io';

import 'package:amos_flutter_ui/amos_flutter_ui.dart';
import 'package:base/consts/color.dart';
import 'package:base/services/company_services.dart';
import 'package:base/view/ImageViewPage.dart';
import 'package:flutter/material.dart';
import 'package:flutter_datetime_picker/flutter_datetime_picker.dart';
import 'package:get/get.dart';
import 'package:intl/intl.dart';
import 'package:modal_progress_hud/modal_progress_hud.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../model/Hidden_Danger/hidden_danger_model.dart';
import '../../services/HiddenDanger.dart';
import '../../view/CheckExecute/ImageList.dart';
import '../../view/hidedanger_manage/hidden_danger_check.dart';
import '../../view/hidedanger_manage/hidden_danger_flowRecord.dart';
import '../../view/hidedanger_manage/hidden_danger_found.dart';
import '../../view/hidedanger_manage/hidden_danger_processed_details_rescinded.dart';
import '../../view/hidedanger_manage/hidden_danger_rectification.dart';

class HiddenDangerReview extends StatefulWidget {
  final int dangerId;
  final num state;
  final String taskId;

  static goToPage(num state, num dangerId, String taskId, BuildContext context) {
    Navigator.push(context, MaterialPageRoute(builder: (context) {
      switch (state) {
        case 1: //待评审
          return HiddenDangerReview(dangerId, taskId);
          break;
        case 2: //待治理
          return HiddenDangerRectification(dangerId, taskId);
          break;
        case 3: //安措计划中
          return HiddenDangerProcessedDetailsRescinded(dangerId, taskId, false);
          break;
        case 4: //待验证
          return HiddenDangerProcessedDetailsChecked(dangerId, taskId);
          break;
        case 5: //治理完毕
          return HiddenDangerProcessedDetailsChecked(dangerId, taskId);
          break;
        case 6: //已撤销
          return HiddenDangerProcessedDetailsRescinded(dangerId, taskId, false);
          break;
        default:
          return HiddenDangerProcessedDetailsRescinded(dangerId, taskId, false);
          break;
      }
    }));
  }

  const HiddenDangerReview(this.dangerId, this.taskId, {this.state});

  @override
  _HiddenDangerReview createState() => _HiddenDangerReview();
}

class _HiddenDangerReview extends State<HiddenDangerReview> {
  bool get wantKeepAlive => true;
  bool canOperate = true;
  bool isAnimating = false;

  // 当前点的附件
  List<File> imageList;
  String myUserId;
  List<String> photoUrls = List(5);
  HideDangerInfoModel initData;
  HideDanger hidedanger = HideDanger();
  String theme = '';
  String imageUrl = '';

  // 当前页码
  int pageIndex = 0;

  // 是否有下一页
  bool hasNext = false;
  var date = DateTime.now();
  Map choosePerson = {};

  @override
  void initState() {
    super.initState();
    hidedanger.limitDate.text = DateTime.now().add(const Duration(days: 30)).toString().substring(0, 10);
    getInitInfo();
  }

  Color getLevelTextBgColor(int level) {
    if (level == 0) return const Color.fromRGBO(183, 28, 28, 1);
    if (level == 1) return const Color.fromRGBO(251, 140, 0, 1);
    if (level == 2) return const Color.fromRGBO(229, 57, 53, 1);
    return Colors.black;
  }

  Future<void> getInitInfo() async {
    await SharedPreferences.getInstance().then((data) {
      if (data != null) {
        setState(() {
          theme = data.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
          imageUrl = data.getString('imageUrl') ?? '';
        });
      }
    }).then((data) {
      loadData();
    });
  }

  Future<void> loadData() async {
    setState(() {
      isAnimating = true;
    });
    await getHiddenDangerModel(context, widget.dangerId, widget.taskId).then((data) {
      setState(() {
        if (data != null) {
          initData = data;
          List<String> photos = [];
          (initData.photoUrls ?? []).forEach((item) {
            photos.add(imageUrl + item);
          });
          initData.photoUrls = photos;
          if (widget.state != null && initData.dangerState != null && widget.state != initData.dangerState) {
            HiddenDangerReview.goToPage(initData.dangerState, initData.dangerId, widget.taskId, context);
          }
        }
        isAnimating = false;
      });
    });
  }

  Future<void> _upDateImg(List<File> att) async {
    setState(() {
      isAnimating = true;
      canOperate = false;
    });
    await updataImg(att).then((data) {
      setState(() {
        ///保存文件路径
        if (data.success) {
          hidedanger.photoUrls = data.message;
          HiddenDangerFound.popUpMsg('图片上传成功!');
        } else {
          HiddenDangerFound.popUpMsg(data.message);
        }
        isAnimating = false;
        canOperate = true;
      });
    });
  }

  Future<void> _saveReviewResult(HideDanger hd, radio, String taskId, String gradeValue) async {
    setState(() {
      isAnimating = true;
      canOperate = false;
    });
    var result = 0;
    if (radio == 1) {
      result = 2;
    } else {
      result = 3;
    }
    var jsonFlow = {'photoUrls': hd.photoUrls};
    await saveReviewResult(hd, result, initData.currentFlowRecordId, jsonFlow, taskId, initData.dangerId, gradeValue: gradeValue)
        .then((data) {
      setState(() {
        if (data.success) {
          HiddenDangerFound.popUpMsg(data.message);
          Navigator.pop(context);
        } else {
          HiddenDangerFound.popUpMsg(data.message);
        }
        isAnimating = false;
        canOperate = true;
      });
    });
  }

  bool _checkNeed() {
    if (radioValue != 2) {
      if (hidedanger.limitDate.text == '') {
        HiddenDangerFound.popUpMsg('请选择治理期限！');
        return false;
      }
    } else {
      if (hidedanger.remark.text == '') {
        HiddenDangerFound.popUpMsg('评审结果不通过！请填写评审说明！');
        return false;
      }
    }
    return true;
  }

  ///初始化单选数据
  var radioValue = 1;
  var gradeValue = 0;

  @override
  Widget build(BuildContext context) {
    if (initData == null || initData.dangerId == null) {
      return Scaffold(
          appBar: AppBar(
        title: const Text(
          '隐患评审',
        ),
        actions: <Widget>[
          Align(
              child: Padding(
            padding: const EdgeInsets.only(right: 8),
            child: GestureDetector(
              child: const Icon(
                Icons.save,
                size: 25,
              ),
            ),
          ))
        ],
        centerTitle: true,
        elevation: 0.2,
        brightness: Brightness.light,
      ));
    }
    return Scaffold(
      appBar: AppBar(
        title: const Text(
          '隐患评审',
        ),
        actions: <Widget>[
          Align(
              child: Padding(
            padding: const EdgeInsets.only(right: 8),
            child: GestureDetector(
              onTap: () {
                if (canOperate) {
                  if (_checkNeed()) {
                    _saveReviewResult(hidedanger, radioValue, initData.taskId, gradeValue.toString());
                  }
                } else {
                  HiddenDangerFound.popUpMsg('正在执行操作！请稍等...');
                }
              },
              child: const Icon(
                Icons.save,
                size: 25,
              ),
            ),
          ))
        ],
        centerTitle: true,
        elevation: 0.2,
        brightness: Brightness.light,
      ),
      body: ModalProgressHUD(
        child: SingleChildScrollView(
          child: Container(
            color: Colors.white,
            child: Column(
              children: <Widget>[
                // 风险点名称
                initData.dangerType == 2
                    ? Column(
                        children: <Widget>[
                          Row(
                            children: <Widget>[
                              Expanded(
                                flex: 5,
                                child: Container(
                                  padding: const EdgeInsets.only(left: 10, top: 10),
                                  height: 50,
                                  child: const Text(
                                    '点名称',
                                    style: TextStyle(color: Colors.black, fontSize: 18),
                                  ),
                                ),
                              ),
                              Expanded(
                                flex: 10,
                                child: Text(
                                  initData.riskInfo == null ? '-' : initData.riskInfo.pointName,
                                ),
                              )
                            ],
                          ),
                          Row(
                            children: <Widget>[
                              Expanded(
                                flex: 5,
                                child: Container(
                                  padding: const EdgeInsets.only(left: 10, top: 10),
                                  height: 50,
                                  child: const Text(
                                    '点编号',
                                    style: TextStyle(color: Colors.black, fontSize: 18),
                                  ),
                                ),
                              ),
                              Expanded(
                                flex: 10,
                                child: Text(initData.riskInfo == null ? '-' : initData.riskInfo.pointNo),
                              )
                            ],
                          ),
                          Row(
                            children: <Widget>[
                              Expanded(
                                flex: 5,
                                child: Container(
                                  padding: const EdgeInsets.only(left: 10, top: 10),
                                  height: 50,
                                  child: const Text(
                                    '等级',
                                    style: TextStyle(color: Colors.black, fontSize: 18),
                                  ),
                                ),
                              ),
                              Expanded(
                                flex: 10,
                                child: Text("${initData.riskInfo != null ? initData.riskInfo.pointLevel : "--"}"),
                              ),
                            ],
                          ),
                          Container(
                            color: Colors.grey[100],
                            height: 10,
                          ),
                          Row(
                            children: <Widget>[
                              Container(
                                padding: const EdgeInsets.only(left: 10, top: 10),
                                height: 50,
                                child: const Text(
                                  '检查依据',
                                  style: TextStyle(
                                    fontWeight: FontWeight.w500,
                                    fontSize: 18,
                                  ),
                                ),
                              ),
                            ],
                          ),
                          initData.riskInfo != null && initData.riskInfo.basis != null
                              ? Column(
                                  children: initData.riskInfo.basis.map((base) {
                                    return Container(
                                      height: 30,
                                      decoration: const BoxDecoration(
                                          border: Border(bottom: BorderSide(color: Color.fromRGBO(244, 244, 244, 1)))),
                                      width: MediaQuery.of(context).size.width,
                                      margin: const EdgeInsets.only(left: 30),
                                      child: Text(
                                        json.decode(base)['name'].toString(),
                                        style: const TextStyle(color: Colors.black, fontSize: 16),
                                      ),
                                    );
                                  }).toList(),
                                )
                              : Container(),
                          Container(
                            color: Colors.grey[100],
                            height: 10,
                          ),
                        ],
                      )
                    : const Text(''),
                Row(
                  children: <Widget>[
                    Expanded(
                      flex: 5,
                      child: Container(
                        padding: const EdgeInsets.only(left: 10, top: 10),
                        height: 50,
                        child: Row(
                          children: const <Widget>[
                            Expanded(
                              child: Text(
                                '隐患名称',
                                style: TextStyle(color: Colors.black, fontSize: 18),
                              ),
                              flex: 19,
                            ),
                          ],
                        ),
                      ),
                    ),
                    Expanded(
                      flex: 10,
                      child: Container(
                        child: Text(
                          initData.dangerName ?? '-',
                        ),
                        padding: const EdgeInsets.only(right: 10, top: 5),
                      ),
                    ),
                  ],
                ),
                //隐患地点
                initData.position == null
                    ? Container()
                    : Row(
                        children: <Widget>[
                          Expanded(
                            flex: 5,
                            child: Container(
                              padding: const EdgeInsets.only(left: 10, top: 10),
                              height: 50,
                              child: Row(
                                children: const <Widget>[
                                  Expanded(
                                    child: Text(
                                      '隐患地点',
                                      style: TextStyle(color: Colors.black, fontSize: 18),
                                    ),
                                    flex: 19,
                                  ),
                                ],
                              ),
                            ),
                          ),
                          Expanded(
                            flex: 10,
                            child: Text(initData.position ?? '-'),
                          ),
                        ],
                      ),
                //隐患等级
                Row(
                  children: <Widget>[
                    Expanded(
                      flex: 5,
                      child: Container(
                        padding: const EdgeInsets.only(left: 10, top: 10),
                        height: 50,
                        child: Row(
                          children: const <Widget>[
                            Expanded(
                              child: Text(
                                '隐患等级',
                                style: TextStyle(color: Colors.black, fontSize: 18),
                              ),
                              flex: 19,
                            ),
                          ],
                        ),
                      ),
                    ),
                    Expanded(
                      flex: 10,
                      child: Text(initData.levelDesc ?? '-', style: TextStyle(color: getLevelTextBgColor(initData.level))),
                    ),
                  ],
                ),
                Container(
                  child: GestureDetector(
                    child: Row(
                      children: <Widget>[
                        Expanded(
                          flex: 3,
                          child: Container(
                            padding: const EdgeInsets.only(left: 10, top: 10),
                            height: 50,
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              children: const <Widget>[
                                Expanded(
                                  child: Text(
                                    '现场照片',
                                    textAlign: TextAlign.left,
                                    style: TextStyle(color: Colors.black, fontSize: 18),
                                  ),
                                  flex: 9,
                                ),
                              ],
                            ),
                          ),
                        ),
                        Expanded(
                          flex: 7,
                          child: Container(
                            child: Wrap(
                                direction: Axis.horizontal,
                                spacing: -25.0, // 主轴(水平)方向间距
                                alignment: WrapAlignment.end, //沿主轴方向居中
                                children: initData.photoUrls != null
                                    ? initData.photoUrls.map((f) {
                                        return Column(
                                          mainAxisAlignment: MainAxisAlignment.end,
                                          children: <Widget>[
                                            Container(
                                              width: 40,
                                              height: 40,
                                              //  margin: EdgeInsets.only(right: 5),
                                              decoration: BoxDecoration(
                                                  color: Colors.transparent,
                                                  borderRadius: const BorderRadius.all(Radius.circular(20.0)),
                                                  image: DecorationImage(image: NetworkImage(f), fit: BoxFit.cover)),
                                            ),
                                          ],
                                        );
                                      }).toList()
                                    : []),
                          ),
                        ),
                        Expanded(
                          flex: 1,
                          child: Container(
                            child: GestureDetector(
                              //50  89  206
                              child: Icon(
                                Icons.keyboard_arrow_right,
                                color: Theme.of(context).primaryColor,
                                size: 22,
                              ),
                              onTap: () {
                                Navigator.push(context, MaterialPageRoute(builder: (context) {
                                  return PhotoViewPage(initData.photoUrls);
                                }));
                              },
                            ),
                          ),
                        ),
                      ],
                    ),
                    onTap: () {
                      if (initData.photoUrls != null && initData.photoUrls.isNotEmpty) {
                        Navigator.push(context, MaterialPageRoute(builder: (context) {
                          return PhotoViewPage(initData.photoUrls);
                        }));
                      }
                    },
                  ),
                ),
                Container(
                  color: Colors.grey[100],
                  height: 10,
                ),
                Container(
                  padding: const EdgeInsets.only(left: 17),
                  width: MediaQuery.of(context).size.width,
                  height: 55,
                  child: GestureDetector(
                    child: Row(
                      children: <Widget>[
                        const Expanded(
                          child: Text('执行日志',
                              textAlign: TextAlign.left,
                              style: TextStyle(
                                fontWeight: FontWeight.w500,
                                fontSize: 19,
                              )),
                          flex: 9,
                        ),
                        Expanded(
                          child: Icon(
                            Icons.keyboard_arrow_right,
                            color: Theme.of(context).primaryColor,
                          ),
                          flex: 1,
                        ),
                      ],
                    ),
                    onTap: () {
                      Navigator.push(context, MaterialPageRoute(builder: (context) {
                        return HidenDangerFlowRecord(initData.dangerId);
                      }));
                    },
                  ),
                ),
                Container(
                  color: Colors.grey[100],
                  height: 10,
                ),
                Container(
                  padding: const EdgeInsets.only(
                    left: 10,
                  ),
                  width: MediaQuery.of(context).size.width,
                  height: 50,
                  child: Row(
                    children: const <Widget>[
                      Expanded(
                        child: Text(
                          '*',
                          style: TextStyle(color: Colors.red),
                        ),
                        flex: 0,
                      ),
                      Expanded(
                        child: Text(
                          '评审结果',
                          style: TextStyle(color: Colors.black, fontSize: 18),
                        ),
                        flex: 19,
                      ),
                    ],
                  ),
                ),
                Container(
                    padding: const EdgeInsets.only(
                      left: 10,
                      top: 5,
                    ),
                    width: MediaQuery.of(context).size.width,
                    height: 50,
                    child: Row(
                      children: <Widget>[
                        Expanded(
                          flex: 1,
                          child: Row(
                            children: <Widget>[
                              Radio(
                                activeColor: Theme.of(context).primaryColor,
                                value: 1,
                                groupValue: radioValue,
                                onChanged: (val) {
                                  setState(() {
                                    radioValue = val;
                                  });
                                },
                              ),
                              GestureDetector(
                                child: const Text('通过'),
                                onTap: () {
                                  setState(() {
                                    radioValue = 1;
                                  });
                                },
                              )
                            ],
                          ),
                        ),
                        Expanded(
                          flex: 1,
                          child: Row(
                            children: <Widget>[
                              Radio(
                                activeColor: Theme.of(context).primaryColor,
                                value: 2,
                                groupValue: radioValue,
                                onChanged: (val) {
                                  setState(() {
                                    radioValue = val;
                                  });
                                },
                              ),
                              GestureDetector(
                                child: const Text('不通过'),
                                onTap: () {
                                  setState(() {
                                    radioValue = 2;
                                  });
                                },
                              )
                            ],
                          ),
                        ),
                        const Expanded(
                          flex: 1,
                          child: Text(''),
                        )
                      ],
                    )),
                radioValue == 1
                    ? Container(
                        padding: const EdgeInsets.only(left: 0, top: 10, bottom: 5),
                        width: MediaQuery.of(context).size.width - 20,
                        child: Column(
                          children: <Widget>[
                            Container(
                              padding: const EdgeInsets.only(
                                left: 10,
                              ),
                              width: MediaQuery.of(context).size.width,
                              height: 50,
                              child: Row(
                                children: const <Widget>[
                                  Expanded(
                                    child: Text(
                                      '*',
                                      style: TextStyle(color: Colors.red),
                                    ),
                                    flex: 0,
                                  ),
                                  Expanded(
                                    child: Text(
                                      '隐患等级确认',
                                      style: TextStyle(color: Colors.black, fontSize: 18),
                                    ),
                                    flex: 19,
                                  ),
                                ],
                              ),
                            ),
                            Container(
                              width: MediaQuery.of(context).size.width - 20,
                              padding: const EdgeInsets.only(
                                top: 5,
                                bottom: 5,
                              ),
                              child: Row(
                                mainAxisAlignment: MainAxisAlignment.start,
                                children: <Widget>[
                                  Expanded(
                                    flex: 1,
                                    child: Row(
                                      children: <Widget>[
                                        Radio(
                                          activeColor: Theme.of(context).primaryColor,
                                          value: 0,
                                          groupValue: gradeValue,
                                          onChanged: (val) {
                                            setState(() {
                                              gradeValue = val;
                                              hidedanger.limitDate.text =
                                                  DateTime.now().add(const Duration(days: 30)).toString().substring(0, 10);
                                            });
                                          },
                                        ),
                                        GestureDetector(
                                          child: const Text('安全问题'),
                                          onTap: () {
                                            setState(() {
                                              gradeValue = 0;
                                            });
                                          },
                                        )
                                      ],
                                    ),
                                    //带文字的单选按钮 value值=groupValue值 即选中状态
                                  ),
                                  Expanded(
                                    flex: 1,
                                    child: Row(
                                      children: <Widget>[
                                        Radio(
                                          activeColor: Theme.of(context).primaryColor,
                                          value: 1,
                                          groupValue: gradeValue,
                                          onChanged: (val) {
                                            setState(() {
                                              hidedanger.limitDate.text =
                                                  DateTime.now().add(const Duration(days: 7)).toString().substring(0, 10);
                                              gradeValue = val;
                                            });
                                          },
                                        ),
                                        GestureDetector(
                                          child: const Text('一般隐患'),
                                          onTap: () {
                                            setState(() {
                                              gradeValue = 1;
                                            });
                                          },
                                        )
                                      ],
                                    ),
                                  ),
                                  Expanded(
                                    flex: 1,
                                    child: Row(
                                      children: <Widget>[
                                        Radio(
                                          activeColor: Theme.of(context).primaryColor,
                                          value: 2,
                                          groupValue: gradeValue,
                                          onChanged: (val) {
                                            setState(() {
                                              hidedanger.limitDate.text = DateTime.now().toString().substring(0, 10);
                                              gradeValue = val;
                                            });
                                          },
                                        ),
                                        GestureDetector(
                                          child: const Text('重大隐患'),
                                          onTap: () {
                                            setState(() {
                                              gradeValue = 2;
                                            });
                                          },
                                        )
                                      ],
                                    ),
                                    //带文字的单选按钮 value值=groupValue值 即选中状态
                                  ),
                                ],
                              ),
                            ),
                          ],
                        ),
                      )
                    : Container(),

                ///治理人
                /*initData.dangerType == 1 &&*/ radioValue == 1
                    ? Row(
                        children: <Widget>[
                          Expanded(
                            child: Container(
                              padding: const EdgeInsets.only(left: 10, top: 10, bottom: 5),
                              width: MediaQuery.of(context).size.width - 50,
                              child: Column(
                                children: <Widget>[
                                  Row(
                                    children: const <Widget>[
                                      Expanded(
                                        child: Text(
                                          '*',
                                          style: TextStyle(color: Colors.red),
                                        ),
                                        flex: 0,
                                      ),
                                      Expanded(
                                        child: Text(
                                          '治理人',
                                          style: TextStyle(color: Colors.black, fontSize: 18),
                                        ),
                                        flex: 19,
                                      ),
                                    ],
                                  ),
                                  Container(
                                      width: MediaQuery.of(context).size.width - 50,
                                      margin: const EdgeInsets.only(top: 5),
                                      padding: const EdgeInsets.only(
                                        top: 5,
                                        bottom: 5,
                                      ),
                                      color: const Color.fromRGBO(244, 244, 244, 1),
                                      child: GestureDetector(
                                        child: Row(
                                          children: <Widget>[
                                            Expanded(
                                              child: Row(
                                                children: <Widget>[
                                                  Expanded(
                                                    flex: 9,
                                                    child: TextField(
                                                      enabled: false,
                                                      autofocus: false,
                                                      controller: hidedanger.reviewUserName,
                                                      maxLines: null,
                                                      decoration: const InputDecoration(
                                                        contentPadding: EdgeInsets.symmetric(vertical: 10.0, horizontal: 10),
                                                        border: InputBorder.none,
                                                        hintText: '治理人',
                                                        filled: true,
                                                        fillColor: Color.fromRGBO(244, 244, 244, 1),
                                                      ),
                                                      onEditingComplete: () {},
                                                    ),
                                                  ),
                                                  Expanded(
                                                    flex: 1,
                                                    child: Icon(
                                                      Icons.keyboard_arrow_right,
                                                      color: Theme.of(context).primaryColor,
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            ),
                                          ],
                                        ),
                                        onTap: () {
                                          Navigator.push(context, MaterialPageRoute(builder: (context) {
                                            return PersonChoose(
                                              person: choosePerson,
                                            );
                                          })).then((person) {
                                            if (person != null) {
                                              choosePerson.addAll(person);
                                              setState(() {
                                                hidedanger.reviewUserName.text = person['bizOrgName'];
                                                hidedanger.reviewUserIds = person['sequenceNbr'];
                                              });
                                            }
                                          });
                                        },
                                      )),
                                ],
                              ),
                            ),
                          ),
                        ],
                      )
                    : Container(),
                //整改日期
                radioValue == 1
                    ? Row(
                        children: <Widget>[
                          Expanded(
                            child: Container(
                              padding: const EdgeInsets.only(left: 10, top: 10, bottom: 5),
                              width: MediaQuery.of(context).size.width - 50,
                              child: Column(
                                children: <Widget>[
                                  Row(
                                    children: const <Widget>[
                                      Expanded(
                                        child: Text(
                                          '*',
                                          style: TextStyle(color: Colors.red),
                                        ),
                                        flex: 0,
                                      ),
                                      Expanded(
                                        child: Text(
                                          '整改日期',
                                          style: TextStyle(color: Colors.black, fontSize: 18),
                                        ),
                                        flex: 19,
                                      ),
                                    ],
                                  ),
                                  Container(
                                      width: MediaQuery.of(context).size.width - 50,
                                      margin: const EdgeInsets.only(top: 5, bottom: 10),
                                      padding: const EdgeInsets.only(
                                        top: 5,
                                        bottom: 5,
                                      ),
                                      color: const Color.fromRGBO(244, 244, 244, 1),
                                      child: GestureDetector(
                                        child: Row(
                                          children: <Widget>[
                                            Expanded(
                                              child: Row(
                                                children: <Widget>[
                                                  Expanded(
                                                    flex: 9,
                                                    child: TextField(
                                                      enabled: false,
                                                      keyboardType: TextInputType.number,
                                                      autofocus: false,
                                                      controller: hidedanger.limitDate,
                                                      maxLines: null,
                                                      decoration: const InputDecoration(
                                                        contentPadding: EdgeInsets.symmetric(vertical: 10.0, horizontal: 10),
                                                        border: InputBorder.none,
                                                        hintText: '选择整改日期',
                                                        filled: true,
                                                        fillColor: Color.fromRGBO(244, 244, 244, 1),
                                                      ),
                                                      onEditingComplete: () {
                                                        //print(this._controller.text);
                                                      },
                                                    ),
                                                  ),
                                                  Expanded(
                                                    flex: 1,
                                                    child: Icon(
                                                      Icons.date_range,
                                                      color: Theme.of(context).primaryColor,
                                                    ),
                                                  ),
                                                ],
                                              ),
                                            ),
                                          ],
                                        ),
                                        onTap: () {
                                          DatePicker.showDatePicker(context,
                                              showTitleActions: true,
                                              minTime: DateTime(date.year, date.month, date.day),
                                              maxTime: DateTime(2199, 12, 31),
                                              theme: DatePickerTheme(
                                                  itemStyle: const TextStyle(color: Colors.black, fontWeight: FontWeight.bold),
                                                  doneStyle: TextStyle(color: Theme.of(context).primaryColor, fontSize: 16)),
                                              onConfirm: (date) {
                                            var selDate = DateFormat('yyyy-MM-dd').format(date);
                                            hidedanger.limitDate.text = DateFormat('yyyy-MM-dd').format(DateTime.parse(selDate)
                                                .add(const Duration(days: 1))
                                                .add(const Duration(seconds: -1)));
                                          }, currentTime: DateTime.now(), locale: LocaleType.zh);
                                        },
                                      )),
                                ],
                              ),
                            ),
                          ),
                        ],
                      )
                    : Container(),
                Container(
                  color: Colors.grey[100],
                  height: 10,
                ),
                //拍照取证
                Container(
                  child: GestureDetector(
                    child: Row(
                      children: <Widget>[
                        Expanded(
                          flex: 3,
                          child: Container(
                            padding: const EdgeInsets.only(left: 10, top: 5),
                            height: 50,
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.start,
                              children: const <Widget>[
                                Expanded(
                                  child: Text(
                                    '  ',
                                    style: TextStyle(color: Colors.red),
                                  ),
                                  flex: 0,
                                ),
                                Expanded(
                                  child: Text(
                                    '拍照取证',
                                    textAlign: TextAlign.left,
                                    style: TextStyle(color: Colors.black, fontSize: 18),
                                  ),
                                  flex: 9,
                                ),
                              ],
                            ),
                          ),
                        ),
                        Expanded(
                          flex: 7,
                          child: Container(
                            child: Wrap(
                                spacing: -25.0, // 主轴(水平)方向间距
                                alignment: WrapAlignment.end, //沿主轴方向居中
                                children: hidedanger.photoUrls != ''
                                    ? hidedanger.photoUrls.split(',').map((f) {
                                        return Column(
                                          mainAxisAlignment: MainAxisAlignment.end,
                                          children: <Widget>[
                                            Container(
                                              width: 40,
                                              height: 40,
                                              //  margin: EdgeInsets.only(right: 5),
                                              decoration: BoxDecoration(
                                                  color: Colors.transparent,
                                                  borderRadius: const BorderRadius.all(Radius.circular(20.0)),
                                                  image: DecorationImage(image: NetworkImage(f), fit: BoxFit.cover)),
                                            ),
                                          ],
                                        );
                                      }).toList()
                                    : []),
                          ),
                        ),
                        Expanded(
                          flex: 1,
                          child: Container(
                            child: Icon(
                              Icons.photo_camera,
                              color: Theme.of(context).primaryColor,
                              size: 22,
                            ),
                          ),
                        ),
                        Expanded(
                          flex: 1,
                          child: Container(
                            child: Icon(
                              Icons.keyboard_arrow_right,
                              color: Theme.of(context).primaryColor,
                              size: 22,
                            ),
                          ),
                        ),
                      ],
                    ),
                    onTap: () {
                      Navigator.push(context, MaterialPageRoute(builder: (context) {
                        return ImageList(imageList);
                      })).then((v) {
                        if (v != null) {
                          setState(() {
                            imageList = v;
                            _upDateImg(imageList);
                          });
                        }
                      });
                    },
                  ),
                ),
                Container(
                  color: Colors.grey[100],
                  height: 10,
                ),
                //评审说明
                Row(
                  children: <Widget>[
                    Expanded(
                      flex: 10,
                      child: Container(
                        padding: const EdgeInsets.only(left: 10, top: 10),
                        height: 50,
                        child: Row(
                          mainAxisAlignment: MainAxisAlignment.start,
                          children: <Widget>[
                            radioValue == 2
                                ? const Expanded(
                                    child: Text(
                                      '*',
                                      style: TextStyle(color: Colors.red),
                                    ),
                                    flex: 0,
                                  )
                                : Container(),
                            const Expanded(
                              child: Text(
                                '评审说明',
                                textAlign: TextAlign.left,
                                style: TextStyle(color: Colors.black, fontSize: 18),
                              ),
                              flex: 9,
                            ),
                          ],
                        ),
                      ),
                    ),
                  ],
                ),
                Container(
                  width: MediaQuery.of(context).size.width - 50,
                  height: 100,
                  margin: const EdgeInsets.only(bottom: 30),
                  decoration: const BoxDecoration(color: Color.fromRGBO(244, 244, 244, 1)),
                  child: TextField(
                    maxLength: 500,
                    autofocus: false,
                    controller: hidedanger.remark,
                    enableInteractiveSelection: true,
                    maxLines: null,
                    decoration: const InputDecoration(
                      contentPadding: EdgeInsets.symmetric(vertical: 10.0, horizontal: 10),
                      border: InputBorder.none,
                      hintText: '请输入',
                      filled: true,
                      fillColor: Color.fromRGBO(244, 244, 244, 1),
                    ),
                    onEditingComplete: () {},
                  ),
                ),
                Container(
                  color: Colors.grey[100],
                  height: 10,
                ),
              ],
            ),
          ),
        ),
        inAsyncCall: isAnimating,
        opacity: 0.7,
        progressIndicator: const CircularProgressIndicator(),
      ),
    );
  }
}

///@Description     人员选择页面
///@author          helinlin
///@create          2021-09-03 15:32
class PersonChoose extends StatefulWidget {
  Map person; //单选回显
  List persons; //多选回显
  bool multi; //是否多选

  PersonChoose({this.person, this.persons, this.multi = false});

  @override
  PersonChooseState createState() => PersonChooseState();
}

class PersonChooseState extends State<PersonChoose> {
  final List persons = [];
  final Widget _divider = const Divider(
    color: Colors.grey,
  );
  final String _idKey = 'sequenceNbr';
  final String _nameKey = 'bizOrgName';

  @override
  void initState() {
    super.initState();
    getData();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      resizeToAvoidBottomInset: false,
      appBar: AppBar(
        title: const Text('请选择治理人员'),
      ),
      body: GestureDetector(
        onTap: () => FocusScope.of(context).requestFocus(FocusNode()),
        child: Column(
          children: [
            Expanded(
              child: ListView.separated(
                  shrinkWrap: true,
                  itemBuilder: (BuildContext context, int index) {
                    return InkWell(
                      onTap: () {
                        setState(() {
                          var person = persons[index];
                          if (widget.multi ?? false) {
                            int index = -1;
                            widget.persons.asMap().forEach((key, value) {
                              if (person[_idKey] == value[_idKey]) {
                                index = key;
                              }
                            });
                            if (index >= 0) {
                              widget.persons.removeAt(index);
                            } else {
                              widget.persons.add(person);
                            }
                          } else {
                            widget.person = person;
                          }
                        });
                      },
                      child: Row(
                        children: [
                          Checkbox(
                              activeColor: Theme.of(context).primaryColor,
                              value: isChoose(index),
                              onChanged: (value) {
                                setState(() {
                                  widget.person = persons[index];
                                });
                              }),
                          Expanded(
                              child: ListTile(
                                  title: Text(
                            (persons[index][_nameKey]) ?? '',
                            style: const TextStyle(fontSize: 14),
                          ))),
                        ],
                      ),
                    );
                  },
                  separatorBuilder: (BuildContext context, int index) {
                    return _divider;
                  },
                  itemCount: persons.length),
            ),
            Container(
              padding: const EdgeInsets.all(10),
              child: Row(
                children: [
                  Expanded(
                    child: FlatButton(
                      color: Theme.of(context).primaryColor,
                      height: 40,
                      onPressed: () {
                        Get.back(result: widget.person);
                      },
                      child: const Text(
                        '确定',
                        style: TextStyle(color: Colors.white),
                      ),
                    ),
                  ),
                ],
              ),
            )
          ],
        ),
      ),
    );
  }

  bool isChoose(int index) {
    if (widget.multi ?? false) {
      bool isChoose = false;
      widget.persons.forEach((element) {
        if (element[_idKey] == (persons[index][_idKey])) {
          isChoose = true;
        }
      });
      return isChoose;
    } else {
      return widget.person[_idKey] == (persons[index][_idKey]);
    }
  }

  ///获取人员数据
  Future<void> getData() {
    Future.delayed(Duration.zero, () {
      MsgBox.showProgressDialog(context, content: '加载中，请稍后。。。');
      getPersonList().then((value) {
        setState(() {
          persons.addAll(value);
        });
      }).whenComplete(() {
        Get.back();
      });
    });
  }
}
