import 'package:base/consts/color.dart';
import 'package:base/consts/external_assets_package_key.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:flutter/material.dart';
import 'package:flutter_easyrefresh/easy_refresh.dart';
import 'package:modal_progress_hud/modal_progress_hud.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../model/CheckPoint.dart';
import '../../services/move_inspection.dart';
import '../CheckExecute/navigation_checkexec.dart';
import '../move_inspection/move_point_search.dart';
import '../move_inspection/move_spot_add.dart';

class MoveSpotListScreen extends StatefulWidget {
  @override
  _MoveSpotListScreenState createState() => _MoveSpotListScreenState();
}

class _MoveSpotListScreenState extends State<MoveSpotListScreen>
    with AutomaticKeepAliveClientMixin {
  @override
  bool get wantKeepAlive => true;

  bool isAnimating = false;

  List<CheckPoint> initData = [];

  int pageIndex = 0;
  bool hasNext = false;

  final EasyRefreshController _controllers = EasyRefreshController();

  String theme = '';

  @override
  Widget build(BuildContext context) {
    if (theme.isEmpty) {
      return const Scaffold(body: Text(''));
    }

    return Scaffold(
        backgroundColor: const Color.fromRGBO(242, 246, 249, 1),
        appBar: AppBar(
          title: const Text(
            '移动巡检',
          ),
          centerTitle: true,
          elevation: 0.2,
          brightness: Brightness.light,
          actions: <Widget>[
            GestureDetector(
              child: Container(
                child:const Icon(Icons.search),
                padding: const EdgeInsets.only(right: 5),
              ),
              onTap: () {
                Navigator.push(context,
                    MaterialPageRoute(builder: (context) {
                  return MovePointSearch();
                }));
              },
            ),
            const Padding(
              padding: EdgeInsets.only(right: 10),
            ),
            // 添加移动巡检
            // GestureDetector(
            //   child: Container(
            //     child: const Icon(Icons.add_circle_outline_outlined),
            //     padding: const EdgeInsets.only(right: 5),
            //   ),
            //   onTap: () {
            //     Navigator.push(context,
            //         MaterialPageRoute(builder: (context) {
            //       return MoveSpotAdd();
            //     })).then((result) {
            //       if (null != result && result) {
            //         setState(() {
            //           pageIndex = 0;
            //           initData = [];
            //         });
            //         getData();
            //       }
            //     });
            //   },
            // ),
            // const Padding(
            //   padding: EdgeInsets.only(right: 6),
            // )
          ],
        ),
        body: ModalProgressHUD(
          inAsyncCall: isAnimating,
          child: EasyRefresh(
            enableControlFinishRefresh: false,
            enableControlFinishLoad: true,
            controller: _controllers,
            footer: MaterialFooter(),
            header: MaterialHeader(),
            child: ListView.builder(
              padding: const EdgeInsets.only(top: 4),
              itemCount: initData.length,
              itemBuilder: (BuildContext context, int index) {
                return Container(
                    margin: const EdgeInsets.only(left: 10, right: 10),
                    child: Card(
                        elevation: 0.2,
                        child: ListTile(
                            isThreeLine: true,
                            dense: false,
                            subtitle: Column(
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: <Widget>[
                                const Padding(
                                  padding: EdgeInsets.only(top: 5),
                                ),
                                Text(
                                  (index + 1).toString() +
                                      '.' +
                                      initData[index].name,
                                  style: const TextStyle(
                                      fontSize: 18.0,
                                      fontWeight: FontWeight.w600),
                                ),
                                const Padding(
                                  padding: EdgeInsets.only(top: 5),
                                ),
                                Text(
                                  '编号:' + initData[index].pointNo,
                                  style: const TextStyle(
                                      fontSize: 14.0, color: Colors.grey),
                                ),
                                const Padding(
                                  padding: EdgeInsets.only(top: 5),
                                ),
                              ],
                            ),
                            trailing: Icon(
                              Icons.keyboard_arrow_right,
                              color: Theme.of(context).primaryColor,
                            ),
                            onTap: () {
                              Navigator.push(context,
                                  MaterialPageRoute(builder: (context) {
                                return NavigationCheckExec(
                                    initData[index].id,
                                    pointName: initData[index].name);
                              }));
                            })));
              },
            ),
            onRefresh: () async {
              await Future.delayed(const Duration(seconds: 1), () {
                setState(() {
                  pageIndex = 0;
                  initData = [];
                });
                _controllers.resetLoadState();
                getData();
              });
            },
            onLoad: () async {
              await Future.delayed(const Duration(seconds: 1), () {
                if (hasNext) {
                  setState(() {
                    pageIndex = pageIndex + 1;
                  });
                  getData();
                }
              });
            },
          ),
          opacity: 0.2,
          progressIndicator: const CircularProgressIndicator(),
        ));
  }

  @override
  void initState() {
    super.initState();
    getData();
    initConfig();
  }

  Future<void> initConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        theme =
            preferences.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  Future<void> getData() async {
    setState(() {
      isAnimating = true;
    });
    await getMoveInspectionList(pageIndex).then((data) {
      setState(() {
        if (null != data) {
          for (final p in data.content) {
            initData.add(CheckPoint.fromJson(p));
          }
        }
        _controllers.finishLoad(noMore: data.last);
        isAnimating = false;
        hasNext = !data.last;
      });
    });
  }
}
