/*
import 'package:amos_flutter_ui/amos_flutter_ui.dart';

import 'package:base/consts/color.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_qr_reader/flutter_qr_reader.dart';
import 'package:permission_handler/permission_handler.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../model/plan_inspection/plan_task_detail.dart';
import '../../services/no_plan_inspection.dart';
import '../../services/plan_inspection_services.dart';
import '../../view/CheckExecute/navigation_checkexec.dart';

class QrPage extends StatefulWidget {
  final num planTaskId;

  const QrPage(this.planTaskId);

  @override
  State<StatefulWidget> createState() => _QrPageState();
}

class _QrPageState extends State<QrPage> {
  final GlobalKey qrKey = GlobalKey(debugLabel: 'QR');
  var qrText = '';
  QrReaderViewController _controller;
  bool camState = false;
  int returnTimes = 0;
  final Permission _permission = Permission.camera;
  PermissionStatus _permissionStatus = PermissionStatus.undetermined;
  PlanTaskDetail initData;
  String theme = '';

  @override
  void initState() {
    super.initState();
    // 加载计划数据
    loadData();
  }

  Future<void> _listenForPermissionStatus() async {
    final status = await _permission.status;
    setState(() => _permissionStatus = status);
  }

  Future<void> requestPermission(Permission permission) async {
    final status = await permission.request();
    setState(() {
      print(status);
      _permissionStatus = status;
      print(_permissionStatus);
    });
  }

  Future<void> loadData() async {
    await queryPlanTaskById(widget.planTaskId).then((data) {
      setState(() {
        initData = data;
      });
      initConfig();
      _listenForPermissionStatus();

      if (_permissionStatus == PermissionStatus.granted) {
        setState(() {
          camState = true;
        });
      } else {
        requestPermission(_permission).then((v) {
          if (_permissionStatus == PermissionStatus.granted) {
            setState(() {
              camState = true;
            });
          } else {
            setState(() {
              camState = false;
            });
            MsgBox.showMessageOnly('请授予权限后重新操作！', context);
          }
        });
      }
    });
  }

  Future<void> initConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        theme = preferences.getString('theme') ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          title: const Text(
            '二维码扫描',
          ),
          centerTitle: true,
          elevation: 0.2,
          brightness: Brightness.light,
        ),
        body: Column(
          children: <Widget>[
            Expanded(
              child: Stack(
                children: <Widget>[
                  camState
                      ? QrReaderView(
                          width: 400,
                          height: 1000,
                          callback: (container) {
                            _controller = container;
                            _controller.startCamera(onScan);
                          })
                      : Container(
                          decoration: const BoxDecoration(
                            color: Colors.black,
                          ),
                        ),
                  Container(
                      height: 40,
                      width: double.infinity,
                      margin: const EdgeInsets.only(left: 60, right: 60, top: 40),
                      child: Container(
                        child: const Text(
                          '对准二维码',
                          style: TextStyle(fontSize: 16, color: Colors.white),
                        ),
                      ),
                      decoration: const BoxDecoration(
                        color: Colors.black38,
                        borderRadius: BorderRadius.all(Radius.circular(25.0)),
                      ),
                      alignment: Alignment.center),
                  GestureDetector(
                    child: Center(
                      child: Stack(
                        children: <Widget>[
                          const Padding(
                            padding: EdgeInsets.only(bottom: 10),
                          ),
                          SizedBox(
                            height: 300.0,
                            width: 270.0,
                            child: Container(
                              decoration: BoxDecoration(border: Border.all(color: Colors.white, width: 1.0)),
                            ),
                          ),
                          Positioned(
                            child: Container(
                              width: 270.0,
                              height: 1,
                              color: Colors.white,
                            ),
                          )
                        ],
                      ),
                    ),
                    onTap: () {
                      _controller.setFlashlight();
                    },
                  )
                ],
              ),
              flex: 4,
            ),
          ],
        ));
  }

  void onScan(String v, List<Offset> offsets) {
    if (v != null && v.isNotEmpty) {
      setState(() {
        returnTimes = returnTimes + 1;
      });
      if (returnTimes == 1) {
        scan(v);
      }
      _controller.stopCamera();
    }
  }

  void scan(String code) {
    print(code);
    if (code.isNotEmpty) {
      getContent(code);
    } else {
      shortMessage('标签内容无法识别！').then((v) {
        if (_controller != null) {
          setState(() {
            returnTimes = 0;
          });
          _controller.startCamera(onScan);
        }
      });
    }
  }

  Future<void> getContent(String no) async {
    if (null == initData) {
      shortMessage('计划数据不存在！').then((v) {
        if (_controller != null) {
          setState(() {
            returnTimes = 0;
          });
          _controller.startCamera(onScan);
        }
      });
      return;
    }
    int pointNum = initData.points.where((f) => f.pointNO == no).toList().length;
    print(no);
    if (pointNum <= 0) {
      shortMessage('此点非巡检计划中的点，请确认后重新执行！').then((v) {
        if (_controller != null) {
          setState(() {
            returnTimes = 0;
          });
          _controller.startCamera(onScan);
        }
      });
      return;
    }

    await getQueryPlanTaskBySerialInfo(1, no, widget.planTaskId).then((data) {
      // 跳转页面
      if (data != null && data.success) {
        Point _execPoint;
        for (final _point in initData.points) {
          if (_point.pointId == data.id) {
            _execPoint = _point;
            break;
          }
        }
        if (null == _execPoint) {
          shortMessage('此点非巡检计划中的点，请确认后重新执行！').then((v) {
            if (_controller != null) {
              setState(() {
                returnTimes = 0;
              });
              _controller.startCamera(onScan);
            }
          });
        } else {
          if (_execPoint.finish != 0) {
            shortMessage('该巡检点已执行巡检！').then((v) {
              if (_controller != null) {
                setState(() {
                  returnTimes = 0;
                });
                _controller.startCamera(onScan);
              }
            });
            return;
          }
          setState(() {
            camState = false;
          });
          Navigator.push(context, MaterialPageRoute(builder: (context) {
            return NavigationCheckExec(data.id, planId: widget.planTaskId, pointName: _execPoint.name, checkMode: 'QR');
          })).then((v) {
            if (_controller != null) {
              setState(() {
                returnTimes = 0;
              });
              _controller.startCamera(onScan);
            }
            setState(() {
              camState = true;
            });
            // 重新加载计划数据
            loadData();
          });
        }
      } else {
        shortMessage(data.message).then((v) {
          if (_controller != null) {
            setState(() {
              returnTimes = 0;
            });
            _controller.startCamera(onScan);
          }
        });
      }
    });
  }
}
*/
