import 'package:amos_flutter_utils/amos_flutter_utils.dart';

import 'package:base/consts/color.dart';
import 'package:base/utils/GetConfig.dart';
import 'package:flutter/material.dart';
import 'package:shared_preferences/shared_preferences.dart';

import '../../model/Task/ProcessInfo.dart';
import '../../model/Task/TaskModel.dart';
import '../../services/TaskServices.dart';
import '../../view/task_detail/task_feedback_detail_screen.dart';

class ProcessingInfoPage extends StatefulWidget {
  final int taskid;
  final TaskModel taskData;

  const ProcessingInfoPage({Key key, @required this.taskid, @required this.taskData}) : super(key: key);

  @override
  _ProcessingInfoPageState createState() => _ProcessingInfoPageState();
}

class _ProcessingInfoPageState extends State<ProcessingInfoPage> {
  List<ProssingInfo> initData = List();
  String theme = "";

  @override
  void initState() {
    getData();
    super.initState();
    initConfig();
  }

  initConfig() async {
    SharedPreferences.getInstance().then((preferences) {
      setState(() {
        this.theme = preferences.getString("theme") ?? KColorConstant.DEFAULT_COLOR;
      });
    });
  }

  getData() async {
    await getProcessInfo(widget.taskid).then((data) {
      setState(() {
        initData = data;
      });
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        backgroundColor: Colors.white,
        appBar: AppBar(
          title: Text(
            "处理信息",
          ),
          centerTitle: true,
          elevation: 0.2,
          brightness: Brightness.light,
        ),
        body: ListView.builder(
            padding: const EdgeInsets.all(5.0),
            itemCount: initData.length,
            itemBuilder: (BuildContext context, int index) {
              return GestureDetector(
                child: BuildItem(index),
                onTap: () {
                  Navigator.push(context, MaterialPageRoute(builder: (context) {
                    FeedBack feedback = widget.taskData.feedback.singleWhere((f) => f.id == initData[index].id);
                    return TaskFeecbackDetailPage(
                      showfeedback: feedback,
                    );
                  }));
                },
              );
            }));
  }

  Widget BuildItem(int index) {
    return Stack(
      children: <Widget>[
        Container(
          padding: const EdgeInsets.only(left: 10.0, right: 10.0),
          child: Row(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: <Widget>[
              const SizedBox(
                width: 5.0,
              ),
              const SizedBox(
                width: 5.0,
              ),
              Expanded(
                child: Container(
                  padding: const EdgeInsets.only(left: 15.0, top: 20.0),
                  decoration: const BoxDecoration(border: Border(left: BorderSide(color: Color(0xFFD6d6d6)))),
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: <Widget>[
                      Text(
                        initData[index].messageType ?? "",
                        style: const TextStyle(color: Colors.green, fontSize: 15.0, fontWeight: FontWeight.bold),
                      ),
                      const SizedBox(
                        height: 5.0,
                      ),
                      Text(
                        initData.isNotEmpty
                            ? DateUtils.timestampToDate(initData[index].feedbackTime ?? 0) +
                                "  " +
                                initData[index].userName
                            : "",
                        style: const TextStyle(color: Colors.grey, fontSize: 12.0),
                      ),
                      const SizedBox(
                        height: 5.0,
                      ),
                      const Text(
                        "反馈信息:",
                        style: TextStyle(color: Colors.grey, fontSize: 12.0),
                      ),
                      const SizedBox(
                        height: 5.0,
                      ),
                      Text(
                        //"软件页面无法开启",
                        initData.isNotEmpty ? initData[index].message : "",
                        style: const TextStyle(color: Colors.grey, fontSize: 12.0),
                      ),
                      const SizedBox(
                        height: 10.0,
                      ),
                      const Padding(
                        padding: EdgeInsets.only(left: 1.0, right: 1.0),
                        child: Divider(
                          height: 0.5,
                          color: Color(0XFFd9d9d9),
                        ),
                      ),
                    ],
                  ),
                ),
              ),
            ],
          ),
        ),
        const Padding(
          padding: EdgeInsets.only(
            left: 8.0,
            top: 20.0,
          ),
          child: Icon(Icons.brightness_1, color: Colors.green),
        ),
      ],
    );
  }
}
