# 说明

安全预控标准版 app

基于flutter开发混合app的标准模板，包含常用的http请求、组件通信、路由功能、屏幕适配等。

## 安全预控

## sdk 版本说明

flutter v1.22.6

## 开发工具

推荐使用 `Android Studio`, 也可以使用 `VS Code` ，均需要安装相应的`Dart`和 `Flutter`插件。

## 开始

- 1.执行 `flutter package get`拉取依赖包
- 2.运行模拟器
- 3.使用 `Andorid Studio` 重新配置一下入口文件，选择 `Edit Conifigurations -> + -> Flutter -> Dart entrypoint` 选择入口文件`src/app.dart`
- 4.如果使用VSCode的话,执行 `flutter run src/app.dart`

项目的目录结构可参考Flutter 模板项目的文档

- [Flutter模板项目简介](./doc/README.md)

- 打包 `flutter build apk`

### 项目页面目录结构说明

```conf
├─main         入口
├─entry        业务入口
├─consts        常量设置
├─extension     类扩展
├─model        模型
├─pages        巡检隐患功能集合
│  ├─CheckExecute        巡检执行页面功能
│  ├─hidedanger_manage     隐患相关功能
│  ├─inspection     巡检记录
│  ├─message     消息页面
│  ├─move_inspection     移动巡检
│  ├─my        我的二级页面
│  ├─no_plan_inspection     无计划巡检
│  ├─plan_inspection     计划巡检
│  ├─offline     离线模式功能
│  └─task    巡检任务
├─routes    路由
├─services   系统服务
├─utils          装备数据交互
├─view          装备页面及功能
│  ├─login    登录
│  ├─platform   装备业务
│  │  ├─offline   离线装备业务
│  │  ├─platform.dart   首页
│  │  ├─equip_warehousing.dart   扫码入口
│  │  ├─fire_agent_in_stock.dart   灭火药剂装备损耗
│  │  ├─create_scrap.dart   报废
│  │  └─profile        我的
│  ├─statistic   装备详情
│  ├─common   公用页面
│      └─profile        我的
└─widgets  封装通用widget
```

## 1.入口

1级入口

-  `src/app.dart`

```dart
void main() => runApp(
  MultiProvider(
    providers: providers,
    child: MyApp(),
  )
);
```

- 二级入口 `src/entry/index.dart`

  主要是项目基础构建，基于`MaterialApp` , 初始入口`Login`

```dart
@override
Widget build(BuildContext context) {
  return MaterialApp(
    debugShowCheckedModeBanner: false,
    title: '装备管理',
    onGenerateRoute: Application.router.generator,
    theme: AppTheme.norTheme,
    home: Login()
  );
}
```

- 三级入口  `src/views/index.dart`

  主要为业务的底部选项卡模块，目前包括工作台、统计、我的，该业务模块为后台配置，可进行动态配置。

  **PermissionViewManger** 为权限管理类，可根据权限数据动态获取底部views和barItems


### 2.工作台

- 器材装备管理
- 消防车辆管理
- 灭火药剂管理

上面业务模块也为后台动态配置

![权限配置1](./doc/images/1.png)

![权限配置2](./doc/images/2.png)

![权限配置3](./doc/images/3.png)


需要配置后，在角色管理 -> 权限配置中勾选相应的配置项。

用户重新登录以后就可以拥有相应的权限.

已经默认添加项目未配置，路由配置不正确的处理。

**工作台入口文件**

`lib/view/platform/platform.dart`


项目路由采用了`fluro`三方库，参数传递处理默认在`src/routes/route_handler.dart` 中处理

为了区分不同的业务模块，创建了 **RouteModel** 类 ，文件地址 `src/model/route_model.dart`,

通过`category` 和 `item` 属性来区分模块，定义了常量类

- **RouteCategoryFrontComponentConst**
- **RouteItemFrontComponentConst**

![权限配置3](./doc/images/4.png)


可以根据不同的业务模块做不同的业务跳转以及业务逻辑处理。


**二维码扫描页面**

`src/view/platform/equip_warehousing.dart`

此页面统一处理项目中扫码, 识别装备和车辆的二维码。二维码开头标识为后台定义。

| 扫码标识 |      |
| :------- | :--: |
| 车辆     | 03#  |
| 装备     | 01#  |



**搜索九大类分类页面**

`src/view/category/category_detail_list.dart`

#### 3.统计

`src/view/statistic/statistic.dart`

饼图采用了 `fl_chart: ^0.10.1` 三方库绘制。

#### 4.我的

`src/view/statistic/profile.dart`

>>>>>>> develop-1225
