package com.yeejoin.amos.connect.dao.entity;

import com.yeejoin.amos.connect.utils.ExcelColumn;

import javax.persistence.*;
import java.io.Serializable;


@Entity
@Table(name="i_point_config")
public class PointConfigVo implements Serializable{
	/**
	 * 
	 */
	private static final long serialVersionUID = -7259637704136034266L;
	@Id
	@GeneratedValue(strategy=GenerationType.AUTO)
	@Column(name = "ID",nullable=false,unique=true)
	private Long id;
	private Long commonAddress;
	@ExcelColumn(value = "信息地址", col = 1)
	private Integer originatorAddress;
	private String value;
	@ExcelColumn(value = "点名称", col = 2)
	private String name;
	@ExcelColumn(value = "点分类", col = 3)
	private String pointClassify;
	@ExcelColumn(value = "点编码", col = 4)
	private String pointCode;
	@ExcelColumn(value = "说明", col = 5)
	private String remark;
	@ExcelColumn(value = "是否有效", col = 6)
	private boolean invalid;
	private String channelNo;

	private String pointType;
	
	public PointConfigVo() {};
	
	public PointConfigVo(Long id, Long commonAddress, Integer originatorAddress, String pointType, String pointClassify, boolean invalid, String channelNo, String name, String pointCode ) {
		super();
		this.id = id;
		this.commonAddress = commonAddress;
		this.originatorAddress = originatorAddress;
		this.name = name;
		this.pointClassify = pointClassify;
		this.pointCode = pointCode;
		this.invalid = invalid;
		this.channelNo = channelNo;
		this.pointType = pointType;
	}
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public Long getCommonAddress() {
		return commonAddress;
	}
	public void setCommonAddress(Long commonAddress) {
		this.commonAddress = commonAddress;
	}
	public Integer getOriginatorAddress() {
		return originatorAddress;
	}
	public void setOriginatorAddress(Integer originatorAddress) {
		this.originatorAddress = originatorAddress;
	}
	public String getValue() {
		return value;
	}
	public void setValue(String value) {
		this.value = value;
	}
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getRemark() {
		return remark;
	}
	public void setRemark(String remark) {
		this.remark = remark;
	}
	public boolean getInvalid() {
		return invalid;
	}
	public void setInvalid(boolean invalid) {
		this.invalid = invalid;
	}
	public String getChannelNo() {
		return channelNo;
	}
	public void setChannelNo(String channelNo) {
		this.channelNo = channelNo;
	}
	public String getPointCode() {
		return pointCode;
	}
	public void setPointCode(String pointCode) {
		this.pointCode = pointCode;
	}
	public String getPointType() {
		return pointType;
	}
	public void setPointType(String pointType) {
		this.pointType = pointType;
	}
	public String getPointClassify() {
		return pointClassify;
	}
	public void setPointClassify(String pointClassify) {
		this.pointClassify = pointClassify;
	}
	
	@Override
	public String toString() {
		return "PointConfigVo [id=" + id + ", commonAddress=" + commonAddress + ", originatorAddress="
				+ originatorAddress + ", value=" + value + ", name=" + name + ", pointClassify=" + pointClassify
				+ ", pointCode=" + pointCode + ", remark=" + remark + ", invalid=" + invalid + ", channelNo="
				+ channelNo + ", pointType=" + pointType + "]";
	}
	
	
}
