package com.yeejoin.amos;

import java.io.IOException;
import java.net.URISyntaxException;

import org.springframework.beans.BeansException;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.cloud.client.discovery.EnableDiscoveryClient;
import org.springframework.cloud.netflix.feign.EnableFeignClients;
import org.springframework.cloud.netflix.hystrix.EnableHystrix;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

import com.yeejoin.amos.iec104.context.FireAutoIntfContext;

import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * amosfireAutoIntf启动类
 *
 * @author as-gaodongdong
 */
@SpringBootApplication
@EnableTransactionManagement
@EnableConfigurationProperties
@EnableSwagger2
@ServletComponentScan
@EnableDiscoveryClient
@EnableFeignClients
@EnableHystrix
@EnableScheduling
public class YeeAmosIec104IntfStart implements ApplicationContextAware {

    /**
     * 	启动FireAutoIntf-server
     *
     * @param args
     * @throws IOException
     * @throws URISyntaxException
     */
    public static void main(String[] args) {
        System.out.println("FireAutoIntf server starting...");
        try {
            SpringApplication application = new SpringApplication(
                    YeeAmosIec104IntfStart.class);
            Environment environment = application.run(args).getEnvironment();
            System.out.println("FireAutoIntf server is running...");
            System.out.println("SwaggerUI: 	http://localhost:"
                    + environment.getProperty("server.port")
                    + "/swagger-ui.html");
        } catch (Exception e) {
            System.out.println("error occur when run FireAutoIntf server! " + e);
        }
    }

    /**
     * 获取并缓存上下文
     */
    @Override
    public void setApplicationContext(ApplicationContext applicationContext)
            throws BeansException {
        // 1.缓存spring上下文
    	FireAutoIntfContext.getInstance().setApplicationContext(applicationContext);
    }

    /**
     * 跨域过滤器
     *
     * @return
     */
    @Bean
    @Order(0)
    public CorsFilter corsFilter() {
        final UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        final CorsConfiguration config = new CorsConfiguration();
        config.setAllowCredentials(true);// 允许cookies跨域
        config.addAllowedOrigin("*");// #允许向该服务器提交请求的URI，*表示全部允许，在SpringMVC中，如果设成*，会自动转成当前请求头中的Origin
        config.addAllowedHeader("*");// #允许访问的头信息,*表示全部
        config.setMaxAge(3600L);// 预检请求的缓存时间（秒），即在这个时间段里，对于相同的跨域请求不会再预检了
        config.addAllowedMethod("OPTIONS");
        config.addAllowedMethod("HEAD");
        config.addAllowedMethod("GET");
        config.addAllowedMethod("PUT");
        config.addAllowedMethod("POST");
        config.addAllowedMethod("DELETE");
        config.addAllowedMethod("PATCH");
        source.registerCorsConfiguration("/**", config);
        return new CorsFilter(source);
    }

}