/**
 *
 */
package com.yeejoin.amos.iec104.business.constants;

import org.apache.log4j.Logger;

import java.text.SimpleDateFormat;

/**
 * iot常量
 *
 * @author as-youjun
 */
public class IEC104Constant {

    /**
     * 构造方法
     */
    private IEC104Constant() {
        Logger.getLogger(this.getClass()).debug(IEC104Constant.CONSTRUCTOR);
    }

    /**
     * 网络服务ip
     */
    public static final String NET_SERVER_HOST = "0.0.0.0";

    /**
     * 时间格式(yyyy-MM-dd HH:mm:ss)
     */
    public static final SimpleDateFormat SIMPLEDATAFORMAT_YMDHMS = new SimpleDateFormat(
            "yyyy-MM-dd HH:mm:ss");

    /**
     * 构造方法字符串
     */
    public static final String CONSTRUCTOR = "constructor...";

    /**
     * 轮询job最大线程数
     */
    public static final int POLLING_JOB_THREAD_MAX_NUM = 20;

    /**
     * amos线程池数量
     */
    public static final int AMOS_THREAD_NUM = 20;

    /**
     * 设备测试最大线程数
     */
    public static final int TEST_EQUIPMENT_THREAD_MAX_NUM = 5;

    /**
     * 时间格式字符串：yyyy-MM-dd HH:mm:ss
     */
    public static final String DATE_TIME_STR_YMDHMS = "yyyy-MM-dd HH:mm:ss";

    /**
     * bar
     */
    public static final String BAR = "-";

    /**
     * Underline
     */
    public static final String UNDERLINE = "_";

    /**
     * user
     */
    public static final String USER = "user";

    /**
     * token
     */
    public static final String TOKEN = "token";

    /**
     * loginType
     */
    public static final String LOGIN_TYPE = "loginType";

    /**
     * subGraphId
     */
    public static final String SUB_GRAPH_ID = "subGraphId";

    public static final String ADMIN_ID = "1";
    /**
     * 帧报文异常
     */
    public static final String FRAME_EXECPTION = "FRAME";
    /**
     * 性能指标
     */
    public static final String METRIC = "METRIC";
    /**
     * 报文通道
     */
    public static final String CHANNEL = "CHANNEL";

    /**
     * 设备状态(掉线)告警
     */
    public static final String EQUIPMENT_STATUS = "EQUIPMENT_STATUS";

    /**
     * 设备连通性告警告警
     */
    public static final String EQUIPMENT_CONNECTION = "EQUIPMENT_CONNECTION";

    /**
     * 通道注册
     */
    public static final String REGISTER = "REGISTER";

    /**
     * 通道注销
     */
    public static final String UNREGISTER = "UNREGISTER";
    /**
     * 报文正常
     */
    public static final String NORMAL = "NORMAL";
    /**
     * 报文异常
     */
    public static final String UNNORMAL = "UNNORMAL";
    /**
     * 告警socket类型
     */
    public static final String ALARM_SOCKET = "ALARM_SOCKET";
    /**
     * 数据socket类型
     */
    public static final String METRIC_SOCKET = "METRIC_SOCKET";
    /**
     * 数据socket类型
     */
    public static final String MORPHIC_SOCKET = "MORPHIC_SOCKET";

    /**
     * false
     */
    public static final Boolean FAIL_BOOLEAN_VALUE = Boolean.FALSE;

    /**
     * 0
     */
    public static final Integer ZERO_INT_VALUE = Integer.parseInt("0");

    /**
     * -1
     */
    public static final Integer FAIL_INT_VALUE = Integer.parseInt("-1");

    /**
     * -1
     */
    public static final Long FAIL_LONG_VALUE = Long.parseLong("-1");

    /**
     * -1
     */
    public static final Short FAIL_SHORT_VALUE = Short.parseShort("-1");

    /**
     *
     */
    public static final Float FAIL_FLOAT_VALUE = Float.parseFloat("-1");

    /**
     * -1
     */
    public static final Double FAIL_DOUBLE_VALUE = Double.parseDouble("-1");

    /**
     * 空格
     */
    public static final Character FAIL_CHARACTER_VALUE = Character.valueOf(' ');

    /**
     * 失败
     */
    public static final int FAILURE = 0;

    /**
     * 成功
     */
    public static final int SUCCESS = 1;

    /**
     * 在线
     */
    public static final String ONLINE = "在线";

    /**
     * 掉线
     */
    public static final String OFFLINE = "掉线";

    /**
     * 通
     */
    public static final String OPEN = "通";

    /**
     * 不通
     */
    public static final String OFF = "不通";

    /**
     * ip
     */
    public static final String IP = "ip";

    /**
     * #
     */
    public static final String SHARP = "#";

    /**
     * 设备相关常量
     *
     * @author as-youjun
     */
    public static final class EquipmentConstant {

        /**
         * 下划线
         */
        public static final String UNDERLINE = "_";

        /**
         * 设备属性key前缀
         */
        public static final String KEY_PREFIX_EQUIP = "equip_";

        /**
         * 能力属性key前缀
         */
        public static final String KEY_PREFIX_CPBL = "cpbl_";

        /**
         * 接口属性key前缀
         */
        public static final String KEY_PREFIX_INTFC = "intfc_";

        /**
         * 测试设备标识
         */
        public static final String TEST_EQUIPMENT = "test_equipment";

        /**
         * 选择接口key
         */
        public static final String KEY_SELINTFCIDS = "selIntfcIds";

        /**
         * 选择能力key
         */
        public static final String KEY_SELCPBLIDS = "selCpblIds";

        /**
         * 测试接口标识
         */
        public static final String CONNECT = "connect";

        /**
         * 测试指标标识
         */
        public static final String METRIC = "metric";

        /**
         * 测试接口key
         */
        public static final String CONNECTDATA = "connectData";

        /**
         * 测试指标key
         */
        public static final String METRICDATA = "metricData";

        /**
         * sourceId
         */
        public static final String SOURCEID = "sourceId";

        /**
         * frameType
         */
        public static final String FRAMETYPE = "frameType";

        /**
         * labelType
         */
        public static final String LABELTYPE = "labelType";

        /**
         * quotaSelected
         */
        public static final String QUOTASELECTED = "quotaSelected";

        /**
         * eqpId设备id
         */
        public static final String EQPID = "eqpId";

        /**
         * 设备连通性判断时长:超过eqp_connected_time_span毫秒的缓存数据无效！！！
         */
        public static final long EQP_CONNECTED_TIME_SPAN = 120000;//2分钟

    }

    /**
     * TCP
     */
    public static final String TCP = "TCP";

    public static final String PIE_CHAR = "pieChar";
    public static final String BAR_CHAR = "barChar";
    public static final String HBAR_CHAR = "hbarChar";
    public static final String LINE_CHAR = "lineChar";
    public static final String DOUGHUNT_CHAR = "doughuntChar";
    public static final String ROSE_CHAR = "roseChar";
    public static final String AREA_CHAR = "areaChar";
    public static final String DIMENSION = "dimension";
    public static final String MEASURE = "measure";

    
    public static final String ALARM_MESSAGE = "alarm";
    public static final String GENERAL_MESSAGE = "general";
}
