package com.yeejoin.amos.iec104.business.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import com.yeejoin.amos.connect.dao.entity.ConfigVo;
import com.yeejoin.amos.connect.dao.entity.PointConfigVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import com.yeejoin.amos.iec104.business.param.PointParam;
import com.yeejoin.amos.iec104.business.service.intfc.IConfService;
import com.yeejoin.amos.iec104.business.service.intfc.IPointConfigService;
import com.yeejoin.amos.iec104.tcp.server.session.Session;
import com.yeejoin.amos.iec104.tcp.server.session.SessionManager;
import com.yeejoin.amos.iec104.utils.ExcelUtils;
import com.yeejoin.amos.op.core.common.response.CommonResponse;
import com.yeejoin.amos.op.core.util.CommonResponseUtil;
import com.yeejoin.amos.security.authorization.Authorization;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping(value = "/point")
@Api(tags="转发表配置")
public class PointController extends BaseController{
	private final Logger log = LoggerFactory.getLogger(PointController.class);
	
	@Autowired
	private IConfService confService;
	@Autowired
	private IPointConfigService pointConfigService;

	/**
	 * 巡检点状态发生变化
	 * 
	 * @param ids
	 * @return
	 */
//	@ApiOperation(value = "巡检点状态发生变化", notes = "巡检点状态发生变化")
//	@PostMapping(value = "/noticePointChange", produces = "application/json;charset=UTF-8")
//	@Authorization(ingore=true)
//	public CommonResponse noticePointChange(@ApiParam(value = "巡检点ID", required = true)@RequestBody(required = false) List<Long> ids) {
//		try {
//			log.debug("巡检点ID pointId======="+ids);
//			if (ObjectUtils.isEmpty(ids)) {
//				return CommonResponseUtil.failure("巡检点ID不可以为空");
//			}
//			return CommonResponseUtil.success();
//		} catch (Exception e) {
//			log.error(e.getMessage(), e);
//			return CommonResponseUtil.failure("消息通知失败");
//		}
//	}
	
	@ApiOperation(value = "导出模板", notes = "导出模板")
	@RequestMapping(value = "/export/model", method = RequestMethod.GET)
	@Authorization(ingore=true)
	public CommonResponse exportModel(HttpServletResponse response) {
		List<PointConfigVo> list = new ArrayList<>();
		list.add(new PointConfigVo());
		try {
			ExcelUtils.writeExcel(response, null, PointConfigVo.class);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return CommonResponseUtil.success();
	}
	
	@ApiOperation(value = "导入转发表", notes = "导入转发表")
	@RequestMapping(value = "/import", method = RequestMethod.POST)
	@Authorization(ingore=true)
	public CommonResponse importClientPoint(@RequestParam(value="file", required = false) MultipartFile file, @RequestParam("serviceId") String serviceId,@RequestParam("pointType") String pointType) {
		if (ObjectUtils.isEmpty(serviceId)) {
			return CommonResponseUtil.success();
		}
		ConfigVo vo = confService.getServerByServiceId(serviceId);
		List<PointConfigVo> list = ExcelUtils.readExcel("", PointConfigVo.class, file);
		
		list.forEach(
			b -> {
	        	b.setChannelNo(vo.getChannelNo());
	        	b.setPointType(pointType);
			}
		);
		pointConfigService.save(list);
		return CommonResponseUtil.success();
	}
	
	@ApiOperation(value = "导入转发表", notes = "导入转发表")
	@RequestMapping(value = "/delete/{serviceId}", method = RequestMethod.DELETE)
	@Authorization(ingore=true)
	public CommonResponse deleteClientPoint(@PathVariable("serviceId") String serviceId) {
		if (ObjectUtils.isEmpty(serviceId)) {
			return CommonResponseUtil.success();
		}
		ConfigVo vo = confService.getServerByServiceId(serviceId);
		pointConfigService.deleteByChannelNo(vo.getChannelNo());
		return CommonResponseUtil.success();
	}
	
//	@ApiOperation(value = "导入转发表", notes = "导入转发表")
//	@RequestMapping(value = "/service/import", method = RequestMethod.POST)
//	@Authorization(ingore=true)
//	public CommonResponse importServicePoint(@RequestParam(value="uploadFile", required = false) MultipartFile file, @RequestParam("serviceId") String serviceId,@RequestParam("pointType") String pointType) {
//		ConfigVo vo = confService.getServerByTypeAndServiceId("IEC_SERVER", serviceId);
//		List<PointConfigVo> list = ExcelUtils.readExcel("", PointConfigVo.class, file);
//		
//		list.forEach(
//			b -> {
//	        	b.setChannelNo(vo.getChannelNo());
//	        	b.setPointType(pointType);
//			}
//		);
//		pointConfigService.save(list);
//		return CommonResponseUtil.success();
//	}
	@ApiOperation(value = "根据通道编码获取摇信点数据", notes = "根据通道编码获取点数据")
	@RequestMapping(value = "/yx/{serviceId}", method = RequestMethod.GET)
	@Authorization(ingore=true)
	public CommonResponse getYxPointByChannelNo(@PathVariable("serviceId") String serviceId) {
		if (ObjectUtils.isEmpty(serviceId)) {
			return CommonResponseUtil.success();
		}
		ConfigVo vo = confService.getServerByServiceId(serviceId);
		if (ObjectUtils.isEmpty(vo)) {
			return CommonResponseUtil.success();
		}
		return CommonResponseUtil.success(pointConfigService.getAllYXPointData(vo.getChannelNo()));
	}
	
	@ApiOperation(value = "根据通道编码获取摇信点数据", notes = "根据通道编码获取点数据")
	@RequestMapping(value = "/pointType/{serviceId}", method = RequestMethod.GET)
	@Authorization(ingore=true)
	public CommonResponse getYxPointType(@PathVariable("serviceId") String serviceId) {
		if (ObjectUtils.isEmpty(serviceId)) {
			return CommonResponseUtil.success();
		}
		ConfigVo vo = confService.getServerByServiceId(serviceId);
		if (ObjectUtils.isEmpty(vo)) {
			return CommonResponseUtil.failure("没有相关服务接口");
		}
		List<String> list = pointConfigService.getYcPointType(vo.getChannelNo());
		return CommonResponseUtil.success(list);
	}
	
	@ApiOperation(value = "根据通道编码获取遥测点数据", notes = "根据通道编码获取点数据")
	@RequestMapping(value = "/yc/{serviceId}", method = RequestMethod.GET)
	@Authorization(ingore=true)
	public CommonResponse getYcPointByChannelNo(@PathVariable("serviceId") String serviceId) {
		if (ObjectUtils.isEmpty(serviceId)) {
			return CommonResponseUtil.success();
		}
		ConfigVo vo = confService.getServerByServiceId(serviceId);
		if (ObjectUtils.isEmpty(vo)) {
			return CommonResponseUtil.success();
		}
		return CommonResponseUtil.success(pointConfigService.getAllYCPointData(vo.getChannelNo()));
	}
	
	@ApiOperation(value = "触发告警", notes = "触发告警")
	@RequestMapping(value = "/trigger/soe", method = RequestMethod.PUT)
	@Authorization(ingore=true)
	public CommonResponse triggerSOE(@RequestBody PointParam point) {
		log.info(point.toString());
		PointConfigVo vo = pointConfigService.findPointByPointCode(point.getPointCode());
		if(ObjectUtils.isEmpty(vo)) {
			return CommonResponseUtil.failure("該點位不存在");
		}
		if ("yc".equals(vo.getPointType())) {
			return CommonResponseUtil.failure("該點位為遙測點位");
		}
		vo.setValue(point.getValue());
//		ConfigVo config = confService.getServerByChannleNoId(vo.getChannelNo());
		Collection<Session> c = SessionManager.getInstance().getClients();
		for (Session s : c) {
			s.addSOE(vo);
			s.addSEC(vo);
		}
		pointConfigService.updatePoint(vo);
		return CommonResponseUtil.success(vo);
	}
	
	@ApiOperation(value = "触发变位", notes = "触发变位")
	@RequestMapping(value = "/trigger/sec", method = RequestMethod.PUT)
	@Authorization(ingore=true)
	public CommonResponse triggerSEC(@RequestBody PointParam point) {
		log.info(point.toString());
		PointConfigVo vo = pointConfigService.findPointByPointCode(point.getPointCode());
		if(ObjectUtils.isEmpty(vo)) {
			return CommonResponseUtil.failure("該點位不存在");
		}
		vo.setValue(point.getValue());
//		ConfigVo config = confService.getServerByChannleNoId(vo.getChannelNo());
		Collection<Session> c = SessionManager.getInstance().getClients();
		for (Session s : c) {
			s.addSEC(vo);
		}
		pointConfigService.updatePoint(vo);
		return CommonResponseUtil.success(vo);
	}
}
